/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkInterpreter.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.46 $
=========================================================================*/



/**
 *  \file 
 *  \brief class Interpreter : The bbtk language interpreter
 */
/**
 *  \class bbtk::Interpreter 
 *  \brief The bbtk language interpreter
 */

#ifndef __bbtkInterpreter_h__
#define __bbtkInterpreter_h__

#include "bbtkVirtualExec.h"
#include "bbtkExecuter.h"
#include "bbtkInterpreterVirtual.h"

#include <fstream>
#include <deque>


namespace bbtk
{

#ifdef USE_WXWIDGETS
  class WxConsole;
#endif
  
	

	
	

  //=======================================================================
  class BBTK_EXPORT Interpreter : public InterpreterVirtual
  {
    BBTK_OBJECT_INTERFACE_NO_CONDES(Interpreter);
    typedef Object InterpreterVirtual;
  public:
    static Pointer New(const std::string& cpp_file = "");
    static Pointer New(VirtualExec::Pointer);


    /// Sets the inputs of the workspace :
    /// the map is passed as is to the Executer
    void SetInputs(const std::map<std::string,std::string>& m)
    { mVirtualExecuter->SetInputs(m); }

    /// Puts the executer in "no exec" mode,
    /// which creates but does not execute pipelines.
    void SetNoExecMode(bool m) { mVirtualExecuter->SetNoExecMode(m); }

    /// Puts the executer in "no error" mode, 
    /// Errors do not stop execution (but warnings are produced)
    void SetNoErrorMode(bool m) { mVirtualExecuter->SetNoErrorMode(m);}
    ///
    //typedef Executer::DialogModeType DialogModeType;
    typedef VirtualExec::DialogModeType DialogModeType;

    void SetDialogMode(DialogModeType t) { mVirtualExecuter->SetDialogMode(t);}


    /// Gets the Executer 
    VirtualExec::Pointer GetExecuter() const { return mVirtualExecuter; }

    /*
    // For 'break' commands observation
    typedef boost::signals::trackable BreakObserverType;
    typedef boost::signal<void ()>  BreakSignalType;
    typedef BreakSignalType::slot_function_type BreakCallbackType;
  
    // Adds a callback when 'break' command issued
    void AddBreakObserver( BreakCallbackType );
    */

  protected:

	  
    /// Resets all
    virtual void commandReset();

	  
    /// Displays help (entry point of any help)
    virtual void commandHelp(const std::vector<std::string>& words);

    /// Displays help on all the commands
    void HelpCommands();

	  
    /// Displays help on a particular command 
    virtual void commandHelp( const std::string& command );

    ///
    virtual void commandGraph(const std::vector<std::string>& words);

    ///
    virtual void commandConfig() const; 
    /// 
    //    void Print(const std::string&);

    virtual void commandIndex(const std::string& filename, 
	       const std::string& type = "Initials");

	  
    /// Creates and connects the piece of pipeline which defines a GUI 
    /// for the box box. 
    /// Define it as a complex box type with name instanceName+"Type"
    /// The instance is called instanceName
    /// and connected to the existing pipeline
     virtual void commandNewGUI(const std::string& box,const std::string& instanceName);
     virtual void commandDebug(const std::string& arg);
	  virtual void commandNew(const std::string &boxType,const std::string &boxName);
	  virtual void commandDelete(const std::string &boxName);
	  virtual void commandConnection(const std::string &nodeFrom,const std::string &outputLabel,const std::string &nodeTo,const std::string &inputLabel);
	  virtual void commandPackage(const std::string &packageName);
	  virtual void commandEndPackage();
	  virtual void commandDefine(const std::string &name,const std::string &pack,const std::string &scriptfilename);
	  virtual void commandEndDefine();
	  virtual void commandKind(const std::string &kind);
	  virtual void commandPrint(const std::string &value);
	  virtual void commandExec(const std::string &word);
	  virtual void commandInput(const std::string &name,const std::string &box,const std::string &input,const std::string  &help);
	  virtual void commandOutput(const std::string &name,const std::string &box,const std::string &output,const std::string  &help);
	  virtual void commandSet(const std::string &box,const std::string &input,const std::string &value);
	  virtual void commandAuthor(const std::string &author);
	  virtual void commandCategory(const std::string &categorytype);
	  virtual void commandDescription(const std::string &description);
	  virtual void commandClear();
	  virtual void commandInclude(const std::string &word, bool ok);
	  virtual void commandLoad(const std::string &packageName);
	  virtual void commandUnload(const std::string &packageName);
	  virtual void commandBreak();
	  virtual void commandQuit();
	  virtual void commandMessage();
	  virtual void commandMessage(const std::string &kind,const  std::string &levelstr);
	  virtual void SetCurrentFileName(const std::string &fullPathScriptName); 
	  virtual void SetTypeOfScript_Application();

	  
	  
	  /// Constructor
	  Interpreter(const std::string& cpp_file = "");
	  Interpreter(VirtualExec::Pointer);
	  
  private:

	  	  
    void Init(VirtualExec::Pointer, const std::string& cpp_file);


    //==================================================================
    // ATTRIBUTES

    /// The command executer used
    bbtk::VirtualExec::Pointer mVirtualExecuter;
    bbtk::Executer::WeakPointer mRealExecuter;


  protected:
	  ~Interpreter();

	  /// 
	  virtual void CatchInterpreterException( const InterpreterException& e );
	  virtual void CatchBbtkException( const bbtk::Exception& e );
	  virtual void CatchStdException( const std::exception& e );
	  virtual void CatchUnknownException();
	  
	  
  };
  // EO class Interpreter



}
#endif
