/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkKW.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.4 $
=========================================================================*/



#ifdef USE_KWWIDGETS

#include "bbtkKW.h"
#include "bbtkMessageManager.h"
#include "vtkKWApplication.h"


//#include "vtkConditionVariable.h"
//#include "vtkMultiThreader.h"

#include <ctime>

extern "C" int Bbtk_Init(Tcl_Interp *interp);

namespace bbtk
{

  bool _dummy_rmt = 
    bbtk::MessageManager::RegisterMessageType("kw",
					      "KWWidgets related messages",0);



  //=========================================================================
  static vtkKWApplication* mgKWApp = 0;
  //static vtkMultiThreader* mgMultiThreader = 0;  
  /*
  static vtkKWWindowBase* mgKWTopWindow = 0;
  static vtkKWWindowBase* mgKWTopWindowParent = 0;
  static bool mgKWAutoDestroyTopWindow = true;
  */
  static int mgKWNbWindowsAlive  = 0;
  static int mgKWNbWindowsShown  = 0;
  //=========================================================================

  
  // static vtkMutexLock* mgKWAppLock;

  //=========================================================================
  VTK_THREAD_RETURN_TYPE vtkKWApplicationStart( void* arg )
  {  
    bbtkDebugMessage("kw",1,"  --> Starting KWApplication in separate thread"
		     <<std::endl);

    mgKWApp->Start();
    
    return VTK_THREAD_RETURN_VALUE;
  }


  //=========================================================================

  //=========================================================================
  // BBTKKWSIG
  static KW::Signal_type mgKWSignal;
  // \BBTKKWSIG
  //=========================================================================

  //=========================================================================
  vtkKWApplication* KW::GetApplication()
  {
    CreateKWAppIfNeeded();
    return mgKWApp;
  }
  //=========================================================================


  //=========================================================================
  void KW::CreateKWAppIfNeeded()
  {
    if (mgKWApp == 0) 
      {
	bbtkDebugMessage("kw",1,"  --> Initializing Tcl"<<std::endl);
	int argc = 1;
	char bbtk[5] = "bbtk";
	char* argv[1];
	argv[0] = bbtk;
	Tcl_Interp *interp = vtkKWApplication::InitializeTcl(argc, 
							     argv, &std::cerr);
	if (!interp)
	  {
	    bbtkGlobalError("KW::CreateKWAppIfNeeded() : InitializeTcl failed");
	  }

	bbtkDebugMessage("kw",1,"  --> Creating bbtk KWApplication"
			 <<std::endl);
	mgKWApp = vtkKWApplication::New();
	mgKWApp->SetName("bbtk");

	Bbtk_Init(interp);


	/*
	if (mgMultiThreader == 0)
	  {
	    bbtkDebugMessage("kw",1,"  --> Creating MultiThreader"<<std::endl);
	    mgMultiThreader = vtkMultiThreader::New();
	  }
	    bbtkDebugMessage("kw",1,"  --> Spawning KWApplication"<<std::endl);
	mgMultiThreader->SetNumberOfThreads( 1 );
	int t = mgMultiThreader->SpawnThread  	(  vtkKWApplicationStart, 0);
	bbtkDebugMessage("kw",1,"  --> Spawned in thread "<<t<<std::endl);
	*/

	// Dies as soon as it starts because no window at this point !!!
	//	mgKWApp->Start();

	/*
	clock_t endwait;
	endwait = clock () + (100 * CLOCKS_PER_SEC )/ 1000;
	while (clock() < endwait) {}
	*/
 
	bbtkDebugMessage("kw",1,"  --> KWApplication running ..."
			 <<std::endl);
     } 
  }
  //=========================================================================

  //=========================================================================
  void KW::DestroyKWAppIfNeeded()
  {
    if (mgKWApp!= 0) 
      {
	bbtkDebugMessage("kw",1,"  --> Destructing bbtk KWApplication"<<std::endl);
	mgKWApp->Delete();
      }
  }
  //=========================================================================

  //========================================================================= 
  /* 
  void KW::SetTopWindowParent(vtkKWWidget* w)
  {
    if (mgTopWindowParent != 0)
      {
	bbtkGlobalError("KW::SetTopWindowParent : top window parent != 0");
      }
    mgKWTopWindowParent = w;
  }
  //=========================================================================
  */
  /*
  //=========================================================================
  void KW::CreateTopWindowIfNeeded()
  {
    if (mgKWTopWindow!=0) return;
    bbtkDebugMessage("kw",1,"  --> Creating bbtk top KW window"<<std::endl);

    CreateKWAppIfNeeded();

    mgKWTopWindow = vtkKWWindowBase::New();
    mgKWTopWindow->SupportHelpOff();
    mgKWApp->AddWindow(mgKWTopWindow);
    mgKWTopWindow->Create();
    //    mgKWTopWindow->Withdraw()
  }
  //=========================================================================

  //=========================================================================
  void KW::DestroyTopWindowIfNeeded()
  {
    if ( (mgKWNbWindowsAlive==0) && 
	 (mgKWAutoDestroyTopWindow) )
      {
	bbtkDebugMessage("kw",1,"  --> Destructing bbtk top KW window"<<std::endl);
 	mgKWTopWindow->Close();
 	mgKWTopWindow->Delete();
	mgKWTopWindow = 0;
	
	DestroyKWAppIfNeeded();
      }
  } 
  //=========================================================================
  */
  /*
  //=========================================================================
  void KW::LoopUntilAllWindowsClose()
  {
    int i = 0;
    while (mgTopWindow != 0)
      {
	if (i % 100 == 0) 
	  {
	    bbtkDebugMessage("kw",2,"KW::Loop "<<i << std::endl);
	  }
	i++;
	kwMilliSleep(10);

      }
  }
  //=========================================================================
  */

  /*
  //=========================================================================
  vtkKWWindowBase* KW::GetTopWindow() 
  { 
    KW::CreateTopWindowIfNeeded();
    return mgKWTopWindow; 
  }
  //=========================================================================
  
  //=========================================================================
  bool KW::TopWindowExists()
  {
    return (mgKWTopWindow!=0);
  }
  //=========================================================================
  */

  // BBTKKWSIG
  //=========================================================================
  void KW::AddSignalObserver(Slot_function_type f)
  {
    mgKWSignal.connect(f);
  }
  //=========================================================================
  // \BBTKKWSIG

  /*
  //=========================================================================
  void KW::SetAutoDestroyTopWindow(bool b)
  {
    mgKWAutoDestroyTopWindow = b;
  }
  //=========================================================================
  */  

  /*
  //=========================================================================
  void KW::SetTopWindow(vtkKWWindowBase* w) 
  {
    if ( mgKWTopWindow ) 
      {
	bbtkGlobalError("KW::SetTopWindow : top window already set !");
      } 
    mgKWTopWindow = w;
  }
  //=========================================================================
  */

  //=========================================================================
  void KW::IncNbWindowsAlive() 
  { 
    mgKWNbWindowsAlive++; 
    bbtkDebugMessage("kw",2,"* Number of KW windows alive = "
		     <<mgKWNbWindowsAlive
		     <<std::endl);
    // BBTKKWSIG
    mgKWSignal();
    // \BBTKKWSIG
  }
  //=========================================================================

  //=========================================================================
  void KW::DecNbWindowsAlive()
  { 
    mgKWNbWindowsAlive--; 
    bbtkDebugMessage("kw",2,"* Number of KW windows alive = "
		     <<mgKWNbWindowsAlive
		     <<std::endl);

    //    DestroyTopWindowIfNeeded();
     // BBTKKWSIG
    mgKWSignal();
    // \BBTKKWSIG
  }
  //=========================================================================
  
  //=========================================================================
  void KW::IncNbWindowsShown() 
  { 
    mgKWNbWindowsShown++; 
    bbtkDebugMessage("kw",2,"* Number of KW windows shown = "
		     <<mgKWNbWindowsShown
		     <<std::endl);
    // BBTKKWSIG
    mgKWSignal();
    // \BBTKKWSIG
  }
  //=========================================================================

  //=========================================================================
  void KW::DecNbWindowsShown()
  { 
    mgKWNbWindowsShown--; 
    bbtkDebugMessage("kw",2,"* Number of KW windows shown = "
		     <<mgKWNbWindowsShown
		     <<std::endl);

    //   DestroyTopWindowIfNeeded();

    // BBTKKWSIG
    mgKWSignal();
    // \BBTKKWSIG
  }
  //=========================================================================


  //=========================================================================
  int  KW::GetNbWindowsAlive() 
  { 
    return mgKWNbWindowsAlive; 
  }
  //=========================================================================
  
  //=========================================================================
  bool KW::IsSomeWindowAlive() 
  { 
    return (mgKWNbWindowsAlive>0);
  }
  //=========================================================================
  
  
  //=========================================================================
  int  KW::GetNbWindowsShown() 
  { 
    return mgKWNbWindowsShown; 
  }
  //=========================================================================
  
  //=========================================================================
  bool KW::IsSomeWindowShown() 
  { 
    return (mgKWNbWindowsShown>0);
  }
  //=========================================================================
  
  /*
  //=========================================================================
  KW::BusyCursor::BusyCursor()
  {
    mCursor = 0;
    if (TopWindowExists()) 
      { 	
	bbtkDebugMessage("kw",2,
			 "KW::BusyCursor::BusyCursor()"<<std::endl);
	   mCursor = new kwBusyCursor; 
	//::kwBeginBusyCursor(); 
    }
  }
  KW::BusyCursor::~BusyCursor()
  {
    if (mCursor) delete mCursor;
  }
  //=========================================================================
  */
  /*
  //=========================================================================
  void KW::ResetCursor() 
  {
    if (!TopWindowExists()) return;
    bbtkDebugMessage("kw",9,"KW::ResetCursor()"<<std::endl);
    while (kwIsBusy()) ::kwEndBusyCursor();
  }
  //=========================================================================
  //=========================================================================
  void KW::BeginBusyCursor() 
  {
    if (!TopWindowExists()) return;
    bbtkDebugMessage("kw",9,"KW::BeginBusyCursor()"<<std::endl);
    ::kwBeginBusyCursor();
  }
  //=========================================================================
  //=========================================================================
  void KW::EndBusyCursor()
  {
    if (!TopWindowExists()) return;
    bbtkDebugMessage("kw",9,"KW::EndBusyCursor()"<<std::endl);
    ::kwEndBusyCursor();
  }
  //=========================================================================
  */

}

#endif
