/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkKWBlackBox.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.11 $
=========================================================================*/


/**
 *  \file 
 *  \brief 
 */

#ifdef USE_KWWIDGETS

#include "bbtkKWBlackBox.h"
#include "bbtkBlackBoxOutputConnector.h"
#include "vtkKWBlackBoxDialog.h"

namespace bbtk
{
  //=========================================================================
  // KWBlackBox
  //=========================================================================

  //=========================================================================
  //=========================================================================
  //=========================================================================
  //=========================================================================
  BBTK_BLACK_BOX_IMPLEMENTATION(KWBlackBox,WidgetBlackBox<wxWindow>);
  //=========================================================================
  
  //==================================================================    
  /// Callback for creating a Dialog window (modal)
  void WxBlackBox::bbCreateDialogWindow()
  {
    KW::GetApplication();
    vtkKWBlackBoxDialog* win = vtkKWBlackBoxDialog::New();
    show = (Window*) win;
    win->bbSetBlackBox( GetThisPointer<KWBlackBox>());
    KW::GetApplication()->AddWindow((vtkKWWindowBase*)win);
    win->Create();
    win->SetResizable(0,0);
    
    bbUserCreateWidget(win->GetFrame());
    /*
      KW::GetApplication()->Script
      ("pack %s -expand yes -fill both",
      bbGetOutputWidget()->GetWidgetName());
    */
    
    KW::GetApplication()->Script("place %s -x 0 -y 0 -width %d -height %d",
				 bbGetOutputWidget()->GetWidgetName(),
				 bbGetInputWinWidth(),
				 bbGetInputWinHeight());
  }
  //==================================================================    

  //==================================================================    
  /// Callback for creating a Frame window 
  void WxBlackBox::bbCreateFrameWindow()
  {
    bbtkWarning("KW: Frame windows not supported: creating a Dialog!");
    bbCreateDialogWindow();
  }
  //==================================================================    


  //==================================================================
  vtkKWWidget*  KWBlackBox::bbCreateWidgetOfInput(const std::string& in, 
						  vtkKWFrame* parent)
  {
    vtkKWWidget* w = 0;
    // If input is connected 
    BlackBoxInputConnector* c = bbGetInputConnectorMap().find(in)->second ;
    if ( c->IsConnected() )			
      {
	// Get black box from 
	BlackBox::Pointer from = 
	  c->GetConnection()->GetBlackBoxFrom();
	// Cast it into a KWBlackBox
	KWBlackBox::Pointer wfrom = boost::dynamic_pointer_cast<KWBlackBox>(from);
	// Call bbCreateWidget
	wfrom->bbUserCreateWidget(parent);
	// Get the widget created
	w = wfrom->bbGetOutputWidget();
      }
    return w;
  }
  //==================================================================


  //==================================================================
  //  void KWBlackBox::InitWindowManagerIfNeeded() { KW::
  void KWBlackBox::IncNbWindowsAlive() { KW::IncNbWindowsAlive(); }
  void KWBlackBox::DecNbWindowsAlive() { KW::DecNbWindowsAlive(); }
  int  KWBlackBox::GetNbWindowsAlive() { return KW::GetNbWindowsAlive(); }
  bool KWBlackBox::IsSomeWindowAlive() { return KW::IsSomeWindowAlive(); }
  
  void KWBlackBox::IncNbWindowsShown() { KW::IncNbWindowsShown(); }
  void KWBlackBox::DecNbWindowsShown() { KW::DecNbWindowsShown(); }
  int  KWBlackBox::GetNbWindowsShown() { return KW::GetNbWindowsShown(); }
  bool KWBlackBox::IsSomeWindowShown() { return KW::GetNbWindowsShown(); }
  //==================================================================
  
}//namespace bbtk

#endif

