/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkMessageManager.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.17 $
=========================================================================*/



/**
 * \file
 * \brief class MessageManager : Manages the messages displayed by bbtk (code)
 */
#include "bbtkMessageManager.h"

namespace bbtk 
{

  MessageManager::MessageManager() 
    : mMaxMessageLength(8)//, mAllLevel(0), mMaxLevel(9)
    
  {
    std::string key;
    key ="all";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Minimum level for all kind of messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key ="max";
    mMessageLevel[key] = 9;
    mMessageHelp[key] = "Maximum level for all kind of messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key ="kernel";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Messages generated by the core classes of the lib";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key ="process";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Messages related to box processing";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "help";
    mMessageLevel[key] = 1;
    mMessageHelp[key] = "Help messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "error";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Error messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "warning";
    mMessageLevel[key] = 1;
    mMessageHelp[key] = "Warning messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "output";
    mMessageLevel[key] = 1;
    mMessageHelp[key] = "Output messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "debug";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Debug messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "config";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Configuration related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "data";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Data related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "widget";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Widgets related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "wx";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "wxWidgets related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "qt";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Qt related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "gui";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Graphical user interface related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "object";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "object memory related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "package";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Packages related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "connection";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Connections related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "change";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "Box i/o changes related messages";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    key = "code";
    mMessageLevel[key] = 0;
    mMessageHelp[key] = "If positive then codes of the messages are displayed";
    if (mMaxMessageLength<key.length()) mMaxMessageLength = key.length();
    }




  MessageManager::~MessageManager() 
  {
    //      std::cout << "~MessageManager"<<std::endl;
  }
  


  MessageManager* MessageManager::GetInstance() 
  { 
    static MessageManager* m = 0;
    if (!m) m = new MessageManager();
    return m; 
  }

  bool MessageManager::RegisterMessageType(std::string key, 
						  std::string help,
						  unsigned char default_level) 
  {
    GetInstance()->mMessageLevel[key] = default_level;
    GetInstance()->mMessageHelp[key] = help;
    if (GetInstance()->mMaxMessageLength<key.length()) 
      GetInstance()->mMaxMessageLength = key.length();
    return true;
  }
  



  void MessageManager::SetMessageLevel(std::string key, 
					      unsigned char level) 
  {
    std::map<std::string,int>::iterator i;
    i = GetInstance()->mMessageLevel.find(key);
    if (i!=GetInstance()->mMessageLevel.end()) 
      {
	(*i).second = level;
      }
    else 
      {
	bbtkWarning("MessageManager::SetMessageLevel : message type=<"
		    <<key<<"> unregistered");
      }
    
  }
  
  
  
  int MessageManager::GetMessageLevel(std::string key) 
  {
    int l = GetInstance()->mMessageLevel["all"];
    std::map<std::string,int>::iterator i = 
      GetInstance()->mMessageLevel.find(key);
    if (i!=GetInstance()->mMessageLevel.end()) {
      if ( (*i).second > l ) l = (*i).second;      
    }
    int m = GetInstance()->mMessageLevel["max"];
    if (l>m) l=m;
    return l;
  }



  void MessageManager::PrintInfo() 
  {
    bbtkMessage("help",1,"================ Messages =================" 
		<< bbtkendl);
    bbtkMessage("help",1, "Kind");
    for (int k=0;
	 k<(int)(GetInstance()->mMaxMessageLength-2);
	 k++) 
      {
	bbtkMessageCont("help",1," "); 
      }
    bbtkMessageCont("help",1,"Level  Nature" << bbtkendl);
    std::map<std::string,int>::iterator i;
    std::map<std::string,std::string>::iterator j;  
    for (i=GetInstance()->mMessageLevel.begin(),
	   j=GetInstance()->mMessageHelp.begin();
	 i!=GetInstance()->mMessageLevel.end();++i,++j) {
      bbtkMessage("help",1, (*i).first);
      for (int k=0;
	   k<(int)(GetInstance()->mMaxMessageLength+2-(*i).first.length());
	   k++) {
	bbtkMessageCont("help",1," ");
      }
      bbtkMessageCont("help",1, (*i).second << "\t" 
		      << (*j).second << bbtkendl);
    }
    bbtkMessage("help",1,"===========================================" 
		<< bbtkendl);
  }
  
  std::string MessageManager::FormatKey(const std::string& key,
					int value)
  {
    std::string s;
    if ( GetInstance()->mMessageLevel["code"] != 0 )
      {
	s = key.substr(0,4);
	std::stringstream ss;
	ss << value;
	//	s += " ";
	s += ss.str();
	s += "> ";
      }
    return s;
  }
}
