/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkObject.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.12 $
=========================================================================*/




#include "bbtkObject.h"
#include "bbtkMessageManager.h"
#include "bbtkPackage.h"

namespace bbtk
{ 
  

  //=======================================================================
  Object::ObjectListType Object::mgObjectList;
  Object::ObjectListType Object::mgPackageList;
  //=======================================================================

  //=======================================================================
  Object::Object()
  { 
  }
  //=======================================================================


  //=======================================================================
  Object::~Object()
  { 
  }
  //=======================================================================

  //=======================================================================
  void Object::InsertInObjectList(Pointer p)
  { 
    bbtkDebugMessage("object",9,"##> Object::InsertInObjectList(\""
		     <<p->GetObjectName()<<"\" ["<<p<<"])"<<std::endl);
    boost::weak_ptr<Object> w(p);
    mgObjectList.insert(w); 
  }
  //=======================================================================

  //=======================================================================
  void Object::InsertInPackageList(Pointer p)
  { 
    bbtkDebugMessage("object",9,"##> Object::InsertInPackageList(\""
		     <<p->GetObjectName()<<"\" ["<<p<<"])"<<std::endl);
    boost::weak_ptr<Object> w(p);
    mgPackageList.insert(w); 
  }
  //=======================================================================


  //=======================================================================
  void Object::RemoveFromObjectList(WeakPointer p)
  { 
    bbtkDebugMessage("object",9,"##> Object::RemoveFromObjectList()"
		     <<std::endl);
    mgObjectList.erase(p);

  }
  //=======================================================================


  //=======================================================================
  std::string Object::GetObjectName() const
  {
    return std::string("**Unknown object**");
  }
  //=======================================================================

  //=======================================================================
  std::string Object::GetObjectInfo() const
  {
    return std::string("");
  }
  //=======================================================================
  
  //=======================================================================
  void Object::PrintObjectListInfo(const std::string& name)
  {
    
    std::cout 
      << "=============== Living bbtk::Object pointers ========="<<std::endl;

    long n = 0;
    long u = 0;
    size_t m = 0;
    ObjectListType::iterator i;
    for (i = mgObjectList.begin();
	 i!=mgObjectList.end();
	 ++i)
      {
	if (i->use_count() == 0) 
	  {
	    u++;
	  }
	else 
	  { 
	    Object::Pointer p(i->lock());
	    if (p->GetObjectName().find(name) != std::string::npos ) 
	      {
		std::cout << n << "/" << mgObjectList.size() << " ";
		PrintObjectInfo(p);
		m += p->GetObjectSize();
		n++;
	      }
	  }
      }
    std::cout 
      << "------------------------------------------------------"<<std::endl; 

    std::cout << " Total : "<<n<<" objects - "<<m<<" b"<<std::endl;
    if (u==1)
      {
	std::cout<<"* Note : "<<u
		 <<" object in list has 0 ref count, "
		 <<"i.e. are no more accessible by bbtk but did not properly destroyed because another ref counting system is holding them !"<<std::endl;
      }
    else if (u>1)
      {
	std::cout<<"* Note : "<<u
		 <<" objects in list have 0 ref count, "
		 <<"i.e. are no more accessible by bbtk but did not properly destroyed because another ref counting system is holding them !"<<std::endl;
      }
    std::cout
      << "============ EO Living bbtk::Object pointers ========="<<std::endl;
	
  }
  //=======================================================================

  /*
  //=======================================================================
  void Object::PrintObjectInfo(const std::string& name)
  {
    long n = 0;
    ObjectListType::iterator i;
    for (i = mgObjectList.begin();
	 i!=mgObjectList.end();
	 ++i)
      {
	n++;
	if (i->use_count() == 0) continue;
	Object::Pointer p(i->lock());	
	if (p->GetObjectName().find(name) != std::string::npos ) 
	  {
	    std::cout << n << "/" << mgObjectList.size() << " ";
	    PrintObjectInfo(p);
	  }
      }
  }
  //=======================================================================
  */
  //=======================================================================
  void Object::PrintObjectInfo(const Object::Pointer& p)
  {
    std::cout << "* [" << p << "] \t" 
	      << p.use_count()-1 << " r \t"
	      << p->GetObjectRecursiveSize() << " ("
	      << p->GetObjectSize() << ") b \t"
	      << p->GetObjectName() 
	      << std::endl;
    std::cout << p->GetObjectInfo();
  }
  //=======================================================================

  //=======================================================================
  /// Objects deleter
  void Object::Deleter::operator() (Object* p)
  {
    std::string name = p->GetObjectName();
#ifdef BBTK_COMPILE_DEBUG_MESSAGES
    void* adr = (void*)p;
    bbtkDebugMessage("object",1,"##> Object::Deleter : deleting \""
		     <<name<<"\" ["<<adr<<"]"<<std::endl);
#endif
    int remaining = this->Delete(p);
    if (remaining == 0)
      {
	Object::RemoveFromObjectList(mPointer);
	bbtkDebugMessage("object",2,"<## Object::Deleter : \""<<name<<"\" ["
			 <<adr<<"] deleted"<<std::endl);
      }
    else
      {
	bbtkWarning("##### Object::Deleter \""<<name<<"\" failed !!! "
		    << remaining << " reference(s) still around..."
		    <<std::endl); 
      }
  }
  //=======================================================================




  //=======================================================================
  void Object::ReleasePackages()
  {
    bbtkDebugMessage("object",1,"##> Object::ReleasePackages()"<<std::endl);
    // Release package pointers
    ObjectListType::iterator i;
    for (i = mgPackageList.begin();
	 i!= mgPackageList.end();
	 ++i)
      {
	if (i->use_count() != 0) 
	  { 
	    bbtkDebugMessage("object",1,"##> Releasing package '"<<
			     i->lock()->GetThisPointer<Package>()->GetName()
			     <<"'"<<std::endl);
	    //	    Object::Pointer p(i->lock());
	    Package::WeakPointer w(i->lock()->GetThisPointer<Package>());
	    Package::Release(w);
	    /*
	    if (p->GetObjectName().find(name) != std::string::npos ) 
	      {
		std::cout << n << "/" << mgObjectList.size() << " ";
		PrintObjectInfo(p);
		m += p->GetObjectSize();
		n++;
	      }
	    */
	  }
      }  

  }
  //=======================================================================




  //=======================================================================
  bool StaticInitTime::PrintObjectListInfo = false;
  //=======================================================================
  //=======================================================================
  StaticInitTime::StaticInitTime() 
  {
  }
  //=======================================================================
  //=======================================================================
  StaticInitTime::~StaticInitTime()
  {
    Object::ReleasePackages();

    if (PrintObjectListInfo) 
      {
	std::cout << std::endl
		  << "************************** main ended *******************"
		  << std::endl << std::endl;
	Object::PrintObjectListInfo("");
      }
    if (Object::GetObjectsCount()>0)
      {
 	std::cout << std::endl;
	std::cout << "**************************** WARNING *************************"
		  <<std::endl; 
	std::cout << "**** "<< Object::GetObjectsCount()
		  <<" bbtk objects still alive after main ended"<<std::endl;
	if (!PrintObjectListInfo) 
	  {
	    
	    std::cout << "**** "
		      <<"Rerun bbi with -D option or put 'debug -D' in bbs file"
		  <<std::endl;
	    std::cout << "**** "
		      <<"to view the objects list "
		      <<std::endl;
	  }
	std::cout << "**************************************************************"
		  <<std::endl
		  <<std::endl;

     }
  }
  //=======================================================================
  //=======================================================================
  //  The static instance
  static StaticInitTime i;
  //=======================================================================

}
