/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkQt.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.4 $
=========================================================================*/


#include "bbtkQt.h"
#include "bbtkMessageManager.h"

#ifdef USE_QT

#include <QApplication>


namespace bbtk
{
  //=========================================================================
  //  class QtApp;
  //=========================================================================

  //=========================================================================
  static QApplication* mgQtApp = 0;
  //  static wxWindow* mgTopWindow = 0;
  //  static wxWindow* mgTopWindowParent = 0;
  //  static bool mgAutoDestroyTopWindow = true;
  static int mgNbWindowsAlive  = 0;
  static int mgNbWindowsShown  = 0;
  //=========================================================================

  //=========================================================================
  // BBTKWXSIG
  static Qt::Signal_type mgQtSignal;
  // \BBTKWXSIG
  //=========================================================================

 
  //=========================================================================
  // The wxApp class which is used when no user wxApp was created
  /*
  class QtApp : public wxApp
  {
  public:
    bool OnInit( );
    int  OnExit() { return true; }
  };
  //=========================================================================
  IMPLEMENT_APP_NO_MAIN(QtApp);
  //=========================================================================
  bool QtApp::OnInit( )
  {	 
    wxApp::OnInit();
#ifdef __WXGTK__
    //See http://www.wxwindows.org/faqgtk.htm#locale
    setlocale(LC_NUMERIC, "C");
#endif
    return true;
  }
  */
  //=========================================================================

  int argc = 1;
  const char* argv = "QApp";

  //=========================================================================
  void Qt::CreateQtAppIfNeeded()
  {
    

  if (QApplication::instance()==0)
      {

	if (mgQtApp != 0) 
	  {
	    bbtkGlobalError("Qt::CreateQtAppIfNeeded() : INTERNAL ERROR ! (QCoreApplication::instance()==0) && (mgQtApp != 0)");
	  }
	bbtkDebugMessage("widget",1,"  --> Creating bbtk QApplication"<<std::endl);
	char* aargv = const_cast<char*>(argv);
	mgQtApp = new QApplication(argc,&aargv);


	bbtkDebugMessage("widget",9,"  --> QApplication::instance = "<<QApplication::instance()<<std::endl);

	/*
	std::cout << ">>>> mgQtApp.exec()"<<std::endl;
	
	mgQtApp->exec();

	std::cout << "<<<< mgQtApp.exec()"<<std::endl;
	*/
      }
    
  }
  //=========================================================================

  //=========================================================================
  void Qt::DestroyQtAppIfNeeded()
  {
    /*
    if (mgQtApp!= 0) 
      {
	bbtkDebugMessage("wx",1,"  --> Destructing bbtk QApplication"<<std::endl);
	//delete mgQtApp;
	//	mgQtApp = 0;
	// Uninit wx
	//	wxUninitialize();
      }
    */
  }
  //=========================================================================

  //=========================================================================  
  void Qt::SetTopWindowParent(QWidget* w)
  {
    /*
    if (mgTopWindowParent != 0)
      {
	bbtkGlobalError("Qt::SetTopWindowParent : top window parent != 0");
      }
    mgTopWindowParent = w;
    */
  }
  //=========================================================================

  //=========================================================================
  void Qt::CreateTopWindowIfNeeded()
  {
    /*
    if (mgTopWindow!=0) return;
    bbtkDebugMessage("wx",1,"  --> Creating bbtk top window"<<std::endl);

    CreateQtAppIfNeeded();

    wxWindow* top = 
      new wxFrame(mgTopWindowParent,
		  -1,
		  _T("TOP BBTK FRAME (YOU SHOULD NOT SEE ME !!)"));
    top->Hide();

    Qt::SetTopWindow(top);
    */
  }
  //=========================================================================

  //=========================================================================
  void Qt::DestroyTopWindowIfNeeded()
  {
    /*
    if ( (mgNbWindowsAlive==0) && 
	 (mgAutoDestroyTopWindow) )
      {
	bbtkDebugMessage("wx",1,"  --> Destructing bbtk top window"<<std::endl);
 	mgTopWindow->Close();
	mgTopWindow = 0;
	
	DestroyQtAppIfNeeded();
      }
    */
  } 
  //=========================================================================

  //=========================================================================
  void Qt::LoopUntilAllWindowsClose()
  {
    /*
    int i = 0;
    while (mgTopWindow != 0)
      {
	if (i % 100 == 0) 
	  {
	    bbtkDebugMessage("wx",2,"Qt::Loop "<<i << std::endl);
	  }
	i++;
	wxMilliSleep(10);

      }
    */
  }
  //=========================================================================

  //=========================================================================
  QWidget* Qt::GetTopWindow() 
  { 
    /*
    Qt::CreateTopWindowIfNeeded();
    return mgTopWindow; 
    */
    return 0;
  }
  //=========================================================================
  
  //=========================================================================
  bool Qt::TopWindowExists()
  {
    //return (mgTopWindow!=0);
    return true;
  }
  //=========================================================================

  // BBTKWXSIG
  //=========================================================================
  void Qt::AddSignalObserver(Slot_function_type f)
  {
    mgQtSignal.connect(f);
  }
  //=========================================================================
  // \BBTKWXSIG

  //=========================================================================
  void Qt::SetAutoDestroyTopWindow(bool b)
  {
    // mgAutoDestroyTopWindow = b;
  }
  //=========================================================================
  
  //=========================================================================
  void Qt::SetTopWindow(QWidget* w) 
  {
    /*
    if ( mgTopWindow ) 
      {
	bbtkGlobalError("wx::SetTopWindow : top window already set !");
      } 
    mgTopWindow = w;
    */
  }
  //=========================================================================


  //=========================================================================
  void Qt::IncNbWindowsAlive() 
  { 
    mgNbWindowsAlive++; 
    bbtkDebugMessage("wx",2,"* Number of windows alive = "<<mgNbWindowsAlive
		     <<std::endl);
    // BBTKWXSIG
    mgQtSignal();
    // \BBTKWXSIG
  }
  //=========================================================================

  //=========================================================================
  void Qt::DecNbWindowsAlive()
  { 
    mgNbWindowsAlive--; 
    bbtkDebugMessage("wx",2,"* Number of windows alive = "<<mgNbWindowsAlive
		     <<std::endl);

    DestroyTopWindowIfNeeded();
     // BBTKWXSIG
    mgQtSignal();
    // \BBTKWXSIG
  }
  //=========================================================================
  
  //=========================================================================
  void Qt::IncNbWindowsShown() 
  { 
    mgNbWindowsShown++; 
    bbtkDebugMessage("wx",2,"* Number of windows shown = "<<mgNbWindowsShown
		     <<std::endl);
    // BBTKWXSIG
    mgQtSignal();
    // \BBTKWXSIG
  }
  //=========================================================================

  //=========================================================================
  void Qt::DecNbWindowsShown()
  { 
    mgNbWindowsShown--; 
    bbtkDebugMessage("wx",2,"* Number of windows shown = "<<mgNbWindowsShown
		     <<std::endl);

    DestroyTopWindowIfNeeded();

    // BBTKWXSIG
    mgQtSignal();
    // \BBTKWXSIG
  }
  //=========================================================================


  //=========================================================================
  int  Qt::GetNbWindowsAlive() 
  { 
    return mgNbWindowsAlive; 
  }
  //=========================================================================
  
  //=========================================================================
  bool Qt::IsSomeWindowAlive() 
  { 
    return (mgNbWindowsAlive>0);
  }
  //=========================================================================
  
  
  //=========================================================================
  int  Qt::GetNbWindowsShown() 
  { 
    return mgNbWindowsShown; 
  }
  //=========================================================================
  
  //=========================================================================
  bool Qt::IsSomeWindowShown() 
  { 
    return (mgNbWindowsShown>0);
  }
  //=========================================================================
  

  //=========================================================================
  Qt::BusyCursor::BusyCursor()
  {
    /*
    mCursor = 0;
    if (wxApp::GetInstance()!=0) 
      { 	
	bbtkDebugMessage("wx",2,
			 "Qt::BusyCursor::BusyCursor() : creating new cursor"
			 <<std::endl);
	mCursor = new wxBusyCursor; 
    }
    */
  }
  Qt::BusyCursor::~BusyCursor()
  {
    /*
    if (mCursor)
      { 
	delete mCursor;
	bbtkDebugMessage("wx",2,
			 "Qt::BusyCursor::~BusyCursor() : deleting cursor"<<std::endl);
      }
    */
  }
  //=========================================================================

  /*
  //=========================================================================
  void Qt::ResetCursor() 
  {
    if (!TopWindowExists()) return;
    bbtkDebugMessage("wx",9,"Qt::ResetCursor()"<<std::endl);
    while (wxIsBusy()) ::wxEndBusyCursor();
  }
  //=========================================================================
  //=========================================================================
  void Qt::BeginBusyCursor() 
  {
    if (!TopWindowExists()) return;
    bbtkDebugMessage("wx",9,"Qt::BeginBusyCursor()"<<std::endl);
    ::wxBeginBusyCursor();
  }
  //=========================================================================
  //=========================================================================
  void Qt::EndBusyCursor()
  {
    if (!TopWindowExists()) return;
    bbtkDebugMessage("wx",9,"Qt::EndBusyCursor()"<<std::endl);
    ::wxEndBusyCursor();
  }
  //=========================================================================
  */

} // namespace bbtk

#else
//=======================================================================
// WITHOUT WX
//=========================================================================
namespace bbtk
{
  Qt::BusyCursor::BusyCursor()
  {
  }
  Qt::BusyCursor::~BusyCursor()
  {
  }
  //=========================================================================

} // namespace bbtk
#endif

