/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkQtBlackBox.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.4 $
=========================================================================*/


/**
 *  \file 
 *  \brief 
 */

#ifdef USE_QT


#include "bbtkQtBlackBox.h"
//#include "bbtkBlackBoxOutputConnector.h"
//#include "bbtkQtBlackBoxDialog.h"
#include "bbtkQtBlackBoxDialog.h"


namespace bbtk
{



  //=========================================================================
  // QtBlackBox
  //=========================================================================

  //=========================================================================
  //=========================================================================
  //=========================================================================
  //=========================================================================
  BBTK_BLACK_BOX_IMPLEMENTATION(QtBlackBox,WidgetBlackBox<QWidget>);
  //=========================================================================
  
  //==================================================================    
  /// Callback for creating a Dialog window (modal)
  void QtBlackBox::bbCreateDialogWindow()
  {
    Qt::CreateQtAppIfNeeded();
    QtBlackBoxDialog* w = 0;  
    w = new QtBlackBoxDialog( GetThisPointer<QtBlackBox>(),
			      0, 
			      bbGetInputWinTitle() 
			      + " - bbtk (c) CREATIS LRMN",
			      bbGetInputWinWidth() , 
			      bbGetInputWinHeight()  );
  }
  //==================================================================    

  //==================================================================    
  /// Callback for creating a Frame window 
  void QtBlackBox::bbCreateFrameWindow()
  {
    
    this->bbCreateDialogWindow();

  }
  //==================================================================    

  //==================================================================    
  void QtBlackBox::bbUserSetDefaultValues()
  {
    bbtkBlackBoxDebugMessage("widget",5,"QtBlackBox::bbUserSetDefaultValues()"<<std::endl);
    bbmWindow = 0;
  }
  //==================================================================    

  //==================================================================    
  void QtBlackBox::bbUserInitializeProcessing()
  {
  }
  //==================================================================    
 
  //==================================================================    
  void QtBlackBox::bbUserFinalizeProcessing()
  {
    bbtkBlackBoxDebugMessage("widget",5,"==> QtBlackBox::bbUserFinalizeProcessing()"<<std::endl);
    bbDestroyWindow();
    bbtkBlackBoxDebugMessage("widget",5,"<== QtBlackBox::bbUserFinalizeProcessing()"<<std::endl);
  }
  //==================================================================    
   
  //==================================================================    
  void QtBlackBox::bbSetWindow(QWidget* w) 
  {
    bbtkBlackBoxDebugMessage("widget",9,"==> QtBlackBox::bbSetWindow("<<w<<")"<<std::endl);
    if ((bbmWindow != 0)&&(w!=0)) 
      { 
	std::cout << "ERRRRRRRROOOOR"<<std::endl; 
      }
    bbmWindow = w;
  }
  //==================================================================    

  //==================================================================    
  void QtBlackBox::bbShowWindow()
  {
    if ((bbmWindow) && (!bbIsShown()))
      {
	bbtkBlackBoxDebugMessage("widget",3,"==> QtBlackBox::bbShowWindow()"
			 <<std::endl);
 	if (bbGetInputWinDialog()) 
	  {
	    bbmWindow->updateGeometry();
	    ((QDialog*)bbmWindow)->exec();
	    bbDestroyWindow();	
	  }
	else
	  {
	    bbmWindow->updateGeometry();
	    ((QDialog*)bbmWindow)->exec();
	    bbSetShown(true);
	  } 
    }
  }
  //==================================================================    

  //==================================================================    
  void QtBlackBox::bbDestroyWindow()
  {
    bbtkBlackBoxDebugMessage("widget",3,"==> QtBlackBox::bbDestroyWindow("<<bbmWindow<<")"<<std::endl);
    if (bbGetWindow()!=NULL) 
      {
	//       wxWindow* w = bbGetWindow();
	//bbSetWindow(0);
	// WE SHOULD DESTROY THE WINDOW WITH THE Close METHOD
	// HOWEVER I
	//w->Close(true);
	//
	delete bbGetWindow();
	bbSetShown(false);
      }
    bbtkBlackBoxDebugMessage("widget",3,"<== QtBlackBox::bbDestroyWindow("<<bbmWindow<<")"<<std::endl);

  }
  //==================================================================    

  //==================================================================
  //  void QtBlackBox::InitWindowManagerIfNeeded() { Qt::
  void QtBlackBox::IncNbWindowsAlive() { Qt::IncNbWindowsAlive(); }
  void QtBlackBox::DecNbWindowsAlive() { Qt::DecNbWindowsAlive(); }
  int  QtBlackBox::GetNbWindowsAlive() { return Qt::GetNbWindowsAlive(); }
  bool QtBlackBox::IsSomeWindowAlive() { return Qt::IsSomeWindowAlive(); }
  
  void QtBlackBox::IncNbWindowsShown() { Qt::IncNbWindowsShown(); }
  void QtBlackBox::DecNbWindowsShown() { Qt::DecNbWindowsShown(); }
  int  QtBlackBox::GetNbWindowsShown() { return Qt::GetNbWindowsShown(); }
  bool QtBlackBox::IsSomeWindowShown() { return Qt::GetNbWindowsShown(); }
  //==================================================================
  



}//namespace bbtk


#endif

