/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkQtBlackBoxDialog.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.5 $
=========================================================================*/



#ifdef USE_QT

#include "bbtkQtBlackBoxDialog.h"
#include "bbtkQtBlackBox.h"

namespace bbtk
{


  //=========================================================================
  QtBlackBoxDialog::QtBlackBoxDialog(QtBlackBox::Pointer box,
				     QWidget *parent,
				     const std::string& title,
				     int width, int height)

    :
    QDialog(parent),
    mBox(box)
				    //    QDialog( parent )
  {
    bbtkDebugMessage("widget",9,"["<<
		     box->bbGetName()<<"] QtBlackBoxDialog("<<parent<<",\""
		     <<title<<"\","<<width<<"x"<<height<<")"<<std::endl);
    Qt::IncNbWindowsAlive();
    // Sets up the GUI inherited from Ui::bbtkQtblackBoxDialog
    setupUi(this);
    resize ( width  , height );
    setWindowTitle(title.c_str());
    
    ///
    box->bbSetWindow(this);
   // Create the widget
    box->bbUserCreateWidget(widget);

    // Insert into the layout
    horizontalLayout->addWidget(box->bbGetOutputWidget());

 
    //    updateGeometry();

  }
  //=========================================================================
  
 
  //=========================================================================
  QtBlackBoxDialog::~QtBlackBoxDialog()
  {
    if (mBox.lock())
      bbtkDebugMessage("widget",9,"["<<mBox.lock()->bbGetName()
		       <<"] $$$$$$$$$$$$$$$$$$$ ~QtBlackBoxDialog()"
		       <<std::endl);
    else 
      bbtkDebugMessage("widget",9,"[DEAD] $$$$$$$$$$$$$$$$$$$$$ ~QtBlackBoxDialog()"<<std::endl);
    //bbtkDebugMessage("widget",9,"WxFrame::~WxFrame()"<<std::endl);
    if (mBox.lock()) mBox.lock()->bbSetWindow(0); 
    Qt::DecNbWindowsAlive();
  }
  //=========================================================================

}
#endif

