/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkTranscriptor.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.19 $
=========================================================================*/



/**
 *  \file 
 *  \brief class Transcriptor: level 0 of script execution (code)
 */

#include "bbtkTranscriptor.h"
#include "bbtkMessageManager.h"
#include "bbtkFactory.h"
#include "bbtkUtilities.h"
#include <fstream>

//#ifdef _USE_WXWIDGETS_
//#include <wx/textdlg.h>
//#endif

//#include "bbtkWxBlackBox.h"

#include "bbtkConfigurationFile.h"

namespace bbtk
{
  Transcriptor::Pointer Transcriptor::New(const std::string& filename)
  {
    return MakePointer(new Transcriptor(filename));
  }

/**
 *
 */
  Transcriptor::Transcriptor(const std::string& filename)
    :
      mDialogMode(NoDialog)
  {
    //VirtualExec();    
    bbtkDebugMessageInc("kernel",9,"Transcriptor()" <<std::endl);
 
     //std::ofstream *m_Fp = new std::ofstream();
    m_Fp.open (filename.c_str(), std::ios::out );

    std::string file,path;
    file = bbtk::Utilities::ExtractScriptName(filename,path);
    
    m_Fp << "#include \"bbtkExecuter.h\"" << std::endl; 
    m_Fp << "void " << file << "(bbtk::Executer::Pointer e)"<<std::endl;
    m_Fp << "{"<<std::endl;

    /*
#ifdef _USE_WXWIDGETS_
    m_Fp << "#ifdef _USE_WXWIDGETS_"<<std::endl;
    m_Fp << "#include \"bbtkWx.h\""<< std::endl<<std::endl;
    m_Fp << "class myApp : public wxApp"<<std::endl;
    m_Fp << "{"<<std::endl;
    m_Fp << "public:"<<std::endl;
    m_Fp << "  bool OnInit( );"<<std::endl;
    m_Fp << "  int  OnExit() { delete e; return true; }"<<std::endl;
    m_Fp << "  bbtk::Executer* e;"<<std::endl;
    m_Fp << "};"<<std::endl<<std::endl;
    m_Fp << "IMPLEMENT_APP(myApp);"<<std::endl<<std::endl;
    m_Fp << "bool myApp::OnInit( )"<<std::endl;
    m_Fp << "{"<<std::endl;
    m_Fp << "  wxApp::OnInit();"<<std::endl;
    m_Fp << "#ifdef __WXGTK__"<<std::endl;
    m_Fp << "  //See http://www.wxwindows.org/faqgtk.htm#locale"<<std::endl;
    m_Fp << "  setlocale(LC_NUMERIC, \"C\");"<<std::endl;
    m_Fp << "#endif"<<std::endl;
    m_Fp << "  wxInitAllImageHandlers();"<<std::endl;
    m_Fp << "  bbtk::Wx::CreateInvisibleTopWindow();"<<std::endl;
    m_Fp << "  try {"<<std::endl;
    m_Fp << "  e = new bbtk::Executer();"<<std::endl;
#else
    m_Fp << "main(int argc, char *argv[]) {"                << std::endl;
    m_Fp << "  bbtk::Executer *e = new bbtk::Executer();"   << std::endl;
#endif 
    */
    bbtkDebugDecTab("kernel",9);
 }

/**
 *
 */
  Transcriptor::~Transcriptor()
  {
  
    bbtkDebugMessageInc("kernel",9,"~Transcriptor()" <<std::endl);
    /*
#ifdef _USE_WXWIDGETS_
    m_Fp << "  }"<<std::endl;
    m_Fp << "  catch (bbtk::Exception err)"<<std::endl;
    m_Fp << "  {"<<std::endl;
    m_Fp << "    err.Print();"<<std::endl;
    m_Fp << "  } "<<std::endl;
    m_Fp << "  return true;"<<std::endl;
    m_Fp << "}"   << std::endl;
    m_Fp << "#endif"<<std::endl;
#else 
    m_Fp << "}"   << std::endl;
#endif
    */
    m_Fp << "}"   << std::endl;
    m_Fp.close();

    bbtkDebugDecTab("kernel",9);
  }
  

  void Transcriptor::Reset()
  {
     m_Fp << "  e->Reset( );" << std::endl;
  }

  void Transcriptor::Clear()
  {
     m_Fp << "  e->Clear( );" << std::endl;
  }

  void Transcriptor::SetWorkspaceName( const std::string& name )
  {
  
    m_Fp << "  e->SetWorkspaceName( \"" << name << "\" );" << std::endl;
  }

  void Transcriptor::BeginPackage (const std::string &name)
  {
     m_Fp << "  e->BeginPackage( \"" << name << "\" );" << std::endl;
  }

  void Transcriptor::EndPackage()
  {
     m_Fp << "  e->EndPackage( );" << std::endl;
  }

  void Transcriptor::Define (const std::string &name,
                             const std::string &pack,
                             const std::string &scriptfilename)
  {
     m_Fp << "  e->Define(\"" << name << "\", \"" <<  pack << "\", \""
          << scriptfilename  << "\" );" << std::endl;
  }

  void Transcriptor::SetCurrentFileName (const std::string &name )
  {
     m_Fp << "  e->SetCurrentFileName( \"" << name << "\" );" << std::endl;
  }

  void Transcriptor::EndDefine ()
  {
     m_Fp << "  e->EndDefine( );" << std::endl;
  }

  void Transcriptor::Kind(const std::string& kind)
  {
    m_Fp << "  e->Kind( \""<<kind<<"\" );" << std::endl;
  }


  void Transcriptor::Create ( const std::string& nodeType, 
                              const std::string& nodeName)
  {
    m_Fp << "  e->Create(\"" << nodeType << "\", \"" 
	 <<  nodeName << "\");" << std::endl;
  }


  void Transcriptor::Destroy (const std::string &nodeName)
  {
    m_Fp << "  e->Destroy(" <<  nodeName << ");" << std::endl;
  }

  void Transcriptor::Connect (const std::string &nodeFrom,
                              const std::string &outputLabel,
                              const std::string &nodeTo, 
                              const std::string &inputLabel)
  {
    m_Fp << "  e->Connect(\""<< nodeFrom << "\", \"" 
	 <<  outputLabel << "\", \""
	 << nodeTo  << "\", \"" << inputLabel<< "\");" << std::endl;
  }


  void Transcriptor::Execute (const std::string &nodeName)
  {
     m_Fp << "  e->Execute(\"" << nodeName << "\");" << std::endl;
  }

  void Transcriptor::DefineInput ( const std::string &name,
                                   const std::string &box,
                                   const std::string &input,
                                   const std::string& help)
  {
  
    m_Fp << "  e->DefineInput(\""<< name << "\", \"" <<  box << "\", \""
         << input << "\", \"" << help << "\");" << std::endl;
  }

  
  void Transcriptor::DefineOutput ( const std::string &name,
				    const std::string &box,
				    const std::string &output,
				    const std::string& help)
  {
    m_Fp << "  e->DefineOutput(\""<< name << "\", \"" <<  box << "\", \""
	 << output << "\", \"" << help << "\");" << std::endl;
  }

 
  void Transcriptor::Set (const std::string &box,
                          const std::string &input,
                          const std::string &value)
  {
    m_Fp << "  e->Set(\""<< box << "\", \"" << input
	 << "\", \"" << value << "\");"
         << std::endl;
  }

  std::string Transcriptor::Get(const std::string &box,
                                const std::string &output)
  {
  
    m_Fp << "  e->Get(\""<< box << "\", \"" << output << "\");"
         << std::endl;
    return "";
  }


  void Transcriptor::Author(const std::string &authorName)
  {
    
    m_Fp << "  e->Author(\"" << authorName << "\");" << std::endl;
  }

  void Transcriptor::Category(const std::string &category)
  {
    m_Fp << "  e->Category(\"" << category << "\");" << std::endl;
  }

  void Transcriptor::Description(const std::string &d)
  {
    m_Fp << "  e->Description(\"" << d << "\");" << std::endl;
  }

  /// prints the list of the boxes of the current descriptor
  void Transcriptor::PrintHelpListBoxes()
  {
     m_Fp << "  e->PrintBoxes( );" << std::endl;
 }

  std::string Transcriptor::ShowGraph(const std::string &nameblackbox,
				  const std::string &detailStr,
				  const std::string &levelStr,
				  const std::string &output_html,
				  const std::string &custom_header,
				  const std::string &custom_title,
				  bool system_display )
  {

       m_Fp << "  e->ShowGraph(\"" << nameblackbox  << "\", \"" 
                                      << detailStr     << "\", \""
                                      << levelStr      << "\", \""
                                      << output_html   << "\", \""
                                      << custom_header << "\", \""
                                      <<  custom_title << "\");"                                     
                                      << std::endl;

    return ""; 
  }

   std::string Transcriptor::ShowGraphInstances(const std::string &nameblackbox, int detail, int level,
                                               bool system_display)
  {
    return "";
  
  }

void Transcriptor::PrintHelpBlackBox(const std::string &nameblackbox, const std::string &detailStr, const std::string &levelStr)
  {
     
  }

  void Transcriptor::Print(const std::string & message)
  {
    m_Fp << "  e->Print(\"" <<message<<"\");"<<std::endl;
  }


  
  void Transcriptor::SetMessageLevel(const std::string &kind,
		       int level)
  {
    m_Fp << "  e->SetMessageLevel(\"" <<kind<<"\","<<level<<");"<<std::endl;
  }
  

  void Transcriptor::HelpMessages()
  {
    m_Fp << "  e->HelpMessages();"<<std::endl;
  }
  
  void Transcriptor::LoadPackage(const std::string &name )
  {
    m_Fp << "  e->LoadPackage(\"" <<name<<"\");"<<std::endl;
  }
  
  
  void Transcriptor::UnLoadPackage(const std::string &name )
  {
    m_Fp << "  e->UnLoadPackage(\"" <<name<<"\");"<<std::endl;
  }

 //==========================================================================
  std::string Transcriptor::GetObjectName() const
  {
    return std::string("Transcriptor");
  }
  //==========================================================================
  
  //==========================================================================
  std::string  Transcriptor::GetObjectInfo() const 
  {
    std::stringstream i;
    return i.str();
  }
  //==========================================================================

 //==========================================================================
size_t  Transcriptor::GetObjectSize() const 
{
  size_t s = Superclass::GetObjectSize();
  s += Transcriptor::GetObjectInternalSize();
  return s;
  }
  //==========================================================================
  //==========================================================================
size_t  Transcriptor::GetObjectInternalSize() const 
{
  size_t s = sizeof(Transcriptor);
  return s;
  }
  //==========================================================================
  //==========================================================================
  size_t  Transcriptor::GetObjectRecursiveSize() const 
  {
    size_t s = Superclass::GetObjectRecursiveSize();
    s += Transcriptor::GetObjectInternalSize();
    return s;
  }
  //==========================================================================

	
  //==========================================================================
	void Transcriptor::SetTypeOfScript_Application()
	{
	}
  //==========================================================================


}//namespace
