/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkUtilities.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.20 $
=========================================================================*/





/**
 *  \file 
 *  \brief struct bbtk::Utilities : various usefull methods 
 */

/**
 * \class bbtk::Utilities
 * \brief various usefull methods 
 */

#ifndef __bbtkUtilities_h_INCLUDED__
#define __bbtkUtilities_h_INCLUDED__

#include "bbtkConfigurationFile.h"
#include "bbtkSystem.h"
#include <string>
#include <sys/stat.h>
#ifdef CMAKE_HAVE_TERMIOS_H
#include <termios.h>
#define BBTK_USE_TERMIOS_BASED_PROMPT
#endif

#ifdef _MSC_VER
   #include <windows.h> 
   #include <direct.h>
#else
   #include <dirent.h>   
   #include <sys/types.h>
#endif

#include <cctype>    // std::toupper
//#include "bbtkMessageManager.h"

#if defined(__GNUC__) // gcc 4.3
#include <stdlib.h>
#endif

namespace bbtk
{
  /// Holds various usefull methods 
  struct BBTK_EXPORT Utilities
  {
    //  ======================================================================
    static std::string GetExecutablePath();

    // ======================================================================
    // See : http://www.techbytes.ca/techbyte103.html for more O.S.
    static bool FileExists(std::string strFilename);
    
    // =====================================================================
    static std::string ExtractPackageName(const std::string  &name, 
					  std::string& path);
    
    //=====================================================================
    static std::string ExtractScriptName(const std::string &name,
					 std::string& path);
    
    // ========================================================================
    static std::string ExpandLibName(const std::string &name, bool verbose);
    
    // =======================================================================
    static std::string MakeLibnameFromPath(std::string path, std::string pkgname);
    
    // =====================================================================
    static std::string MakePkgnameFromPath(std::string path, 
					   std::string pkgname, bool addExt);
    //========================================================================
    
    
    // =======================================================================
    /// Makes a valid filename with string (replaces invalid file seps 
    /// by valid ones)
    static inline void MakeValidFileName(std::string& name)
    {
      replace( name, 
	       INVALID_FILE_SEPARATOR , 
	       VALID_FILE_SEPARATOR);
    }

    // =======================================================================
    /// Returns the user settings dir, e.g. /home/username/.bbtk
    static std::string GetUserSettingsDir();

    // =======================================================================
    /// Builds the complete path to the file 'name' located 
    /// in user settings dir, e.g. /home/username/.bbtk/
    static std::string MakeUserSettingsFullFileName(const std::string& name);
    
    
    static bool IsAtRoot(std::string cwd);
    // ======================================================================
    
    static bool IsDirectory(std::string const &dirName);

    static void CreateDirectoryIfNeeded( std::string const &dirName);
    // =======================================================================
    
    static void SplitAroundFirstDot( const std::string& in,
				     std::string& left,
                                            std::string& right);
    //======================================================================
    static void SplitString ( const std::string& str, 
				     const std::string& delimiters, 
				     std::vector<std::string>& tokens);
    //====================================================================
    
    
    // ====================================================================
    
    static std::string get_file_name(const std::string& s) ;
    
    
    // ====================================================================
    /**
     * \brief   Explore a directory with possibility of recursion
     *          return number of files read
     * @param  dirpath   directory to explore
     * @param  recursive whether we want recursion or not
     */
    static int Explore(std::string const &dirpath, bool recursive, std::vector<std::string> &Filenames);
    
    
    //=======================================================================
    // Replaces substrings "\\n" by a real carriage return "\n"
    static void SubsBackslashN ( std::string& s );
    //=======================================================================


  //========================================================================
  // Usefull functions for html generation
  //========================================================================

    static inline void replace( std::string& str,
                                const std::string& what, 
                                const std::string& with )
    {
      std::string::size_type pos = str.find( what );
	  while ( pos != std::string::npos )
      {
        str.replace( pos, what.size(), with );
        pos = str.find( what, pos+what.size()-1 );
      } 
    }
    //========================================================================

    static inline void html_format(std::string& str)
    {
      replace( str, "&", "&amp;" );
      replace( str, "<", "&lt;" );
      replace( str, ">", "&gt;" );
    }
    
    
    //========================================================================
    // Usefull functions OPTIONS string
    //========================================================================

    
    static bool loosematch(std::string stdLine,std::string stdOptions);
    
   
    
    
  };
class BBTK_EXPORT NodeTreeC 
{
public:
	std::string data;
	std::vector<NodeTreeC> childs;

	NodeTreeC();
	NodeTreeC(std::string _data);
	~NodeTreeC();
	void insertChild(std::string _data);
	void treeTour(int lvl);
	void setData(std::string _data);
	void deleteTree();
};
  
} // namespace bbtk
 
#endif //#ifndef __bbtkUtilities_h_INCLUDED__
//EOF
