/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWidgetBlackBox.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.8 $
========================================================================*/



/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */
#ifndef __bbtkWidgetBlackBox_h_INCLUDED__
#define __bbtkWidgetBlackBox_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"

namespace bbtk
{




  //==================================================================
  /// Generic (template) Widget black box from which all 
  /// widget black boxes for a specific GUI toolkit inherit with 
  /// apropriate traits.
  /// Declares the common inputs / outputs and interface to all widget boxes

//JCP 09JUIN2009 BBTK_EXPORT
  template <class W>
	  
  class /*BBTK_EXPORT*/ WidgetBlackBox : public bbtk::AtomicBlackBox  
  { 
  public:
    //    typedef WidgetTraits Traits;
    typedef W Widget;
    typedef Widget* WidgetPointer;
    
    
    BBTK_BLACK_BOX_INTERFACE(WidgetBlackBox,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(WinTitle,std::string);
    BBTK_DECLARE_INPUT(WinWidth,int);
    BBTK_DECLARE_INPUT(WinHeight,int);
    BBTK_DECLARE_INPUT(WinDialog,bool);
    BBTK_DECLARE_INPUT(WinHide,Void);
    BBTK_DECLARE_INPUT(WinClose,Void);
    BBTK_DECLARE_OUTPUT(Widget,Widget*);

    //==================================================================
    /// Overloaded bbCreateWindow method for WidgetBlackBoxes which handles 
    /// the window creation if needed
    virtual void bbCreateWindow();
    virtual bool bbWindowIsCreated() { return false; }
    //==================================================================
    
    //==================================================================
    /// Overloaded bbShowWindow method for WidgetBlackBoxes which handles 
    /// the window creation if needed
    virtual void bbShowWindow() {}
    //==================================================================    

 
    /// Convenient method which returns true iff the output Widget is connected
    bool bbIsOutputWidgetConnected();

    //==================================================================    
    bool bbIsShown();
    //==================================================================    
 
   
    //==================================================================    
    /// User callback for creating the widget associated to the box
    /// ** Must be defined ** in user classes
    virtual void bbUserCreateWidget(Widget* parent) 
    {
      bbtkError(bbGetTypeName()<<" is a WidgetBlackBox whose bbUserCreateWidget methods is not overloaded : is it a feature or a bug ?!?");
    }
    //==================================================================    

	  
  protected:
    
    void bbSetShown(bool);

    //==================================================================
    /// Convenient method for layout widgets which creates and returns
    /// (calls bbUserCreateWidget) 
    /// the widget of the box connected to the input in.
    /// Returns NULL if the input is not connected
    Widget* bbCreateWidgetOfInput(const std::string& in, 
				  Widget* parent);
    //==================================================================

   //==================================================================    
    /// Callback for creating a Dialog window (modal)
    /// ** Must be defined ** in toolkit specific descendants 
    virtual void bbCreateDialogWindow()
    {
      bbtkError(bbGetTypeName()<<" is a WidgetBlackBox whose bbCreateDialogWindow method is not overloaded ?!?");
    }
    //==================================================================    

 //==================================================================    
    /// Callback for creating a Frame window 
    /// ** Must be defined ** in toolkit specific descendants 
    virtual void bbCreateFrameWindow()
    {
      bbtkError(bbGetTypeName()<<" is a WidgetBlackBox whose bbCreateFrameWindow method is not overloaded ?!?");
    }
    //==================================================================    
    //==================================================================
    /// Overloaded processing method for WidgetBlackBoxes
    virtual void bbProcess();
    //==================================================================

    //==================================================================
    /// Destroys the WidgetBlackBoxWindow associated to the box (if exists)
    virtual void bbDestroyWindow() {}
    //==================================================================

   

  private:
   
    /// Set to true when the 
    /// window containing the widget is shown
    bool bbmShown;
    /// Contains the "nested" WidgetBlackBoxes, 
    /// i.e. if this WidgetBox is a Layout the ones
    /// which are inserted into the layout 
    /// The list is updated by the method bbCreateWidgetOfInput
    /// It is emptied when ?
    std::vector<BlackBox::WeakPointer> bbmNestedWidgetBoxes;
  };
  //=================================================================
 

  //======================================================================
  /// Defines the bbUserCreateWidget method
#define BBTK_CREATE_WIDGET(CALLBACK)					\
  public:								\
  inline void bbUserCreateWidget(Widget* parent)			\
  {									\
    bbtkBlackBoxDebugMessage("widget",1,"**> Creating widget"		\
			     <<std::endl);				\
    CALLBACK(parent);							\
  }
  
  //======================================================================

  //======================================================================
  /// Defines the bbUserOnShow method
#define BBTK_ON_SHOW_WIDGET(CALLBACK)					\
  public:								\
  inline void bbUserOnShow()						\
  {									\
    bbtkBlackBoxDebugMessage("widget",1,"**> Showing"			\
			     <<std::endl);				\
    CALLBACK();								\
  }
  
  //======================================================================

  //=================================================================
  // WidgetBlackBoxDescriptor declaration
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(WidgetBlackBox,bbtk::AtomicBlackBox);
  BBTK_NAME("WidgetBlackBox_"+HumanTypeName<T>());
  // BBTK_DESCRIPTION("Widget box. The inputs marked with (*) are only used if the widget is not inserted in another widget.\n");
  BBTK_CATEGORY("widget");
  BBTK_TEMPLATE_INPUT(WidgetBlackBox,WinTitle,
	     "Title of the window (*)",
	     std::string);
  BBTK_TEMPLATE_INPUT(WidgetBlackBox,WinWidth,
	     "Width of the window (* : only used if the widget is not connected to a Layout box)",int);
  BBTK_TEMPLATE_INPUT(WidgetBlackBox,WinHeight,
	     "Height of the window (*)",int);
  BBTK_TEMPLATE_INPUT(WidgetBlackBox,WinDialog,
	     "Set to 'true' to create a dialog window, i.e. which blocks the pipeline until it is closed (modal) (*)",bool);
  BBTK_TEMPLATE_INPUT(WidgetBlackBox,WinHide,
	     "Any signal received hides the window (*)",Void);
  BBTK_TEMPLATE_INPUT(WidgetBlackBox,WinClose,
	     "Any signal received closes the window (*)",Void);
  typedef typename WidgetBlackBox<T>::WidgetPointer WidgetPointer;
  BBTK_TEMPLATE_OUTPUT(WidgetBlackBox,Widget,"Output widget",WidgetPointer);
  BBTK_END_DESCRIBE_BLACK_BOX(WidgetBlackBox);
  //=================================================================









} //namespace bbtk

// template code inclusion
#include "bbtkWidgetBlackBox.txx"

// WidgetBlackBoxWindow interface + code inclusion
#include "bbtkWidgetBlackBoxWindow.h"

#endif  //__bbtkWidgetBlackBox_h__
