/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================                                                                               
  Program:   bbtk
  Module:    $RCSfile: bbtkWidgetBlackBox.txx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.7 $
=========================================================================*/



/**
 *  \file 
 *  \brief 
 */


 
//#include "bbtkWidgetBlackBoxWindow.h"
#include "bbtkBlackBoxOutputConnector.h"


namespace bbtk
{

  //=========================================================================
  // WidgetBlackBox
  //=========================================================================

  //=========================================================================
  //=========================================================================
  //=========================================================================
  //=========================================================================
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(WidgetBlackBox,AtomicBlackBox);
  //=========================================================================
  
//=========================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbUserSetDefaultValues()
  {
    bbtkBlackBoxDebugMessage("widget",9,"WidgetBlackBox::bbUserSetDefaultValues()"<<std::endl);
    //    bbmWindow = 0;
    bbSetInputWinTitle(bbGetName());
    bbSetInputWinWidth(800);
    bbSetInputWinHeight(800);
    bbSetInputWinDialog(false);
    bbSetOutputWidget(0);
  }
  //=========================================================================

 
  //=========================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbUserInitializeProcessing()
  {
    bbmShown = false;
  }
  //=========================================================================

  //=========================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbUserFinalizeProcessing()
  {
    /*
    std::cout << "****** WidgetBlackBox<T>::bbUserFinalizeProcessing()"<<std::endl;
    bbtkBlackBoxDebugMessage("widget",9,"==> WidgetBlackBox::bbUserFinalizeProcessing() ["<<bbGetFullName()<<"]"<<std::endl);
    if (bbGetWindow()) 
      {
	bool shown = bbGetWindow()->bbIsShown();
	bbGetWindow()->bbDestroy();
	bbSetWindow(0);
	
	if (GetUseCount()==0)
	  {    
	    bbtkBlackBoxDebugMessage("widget",9,"**** HERE use count == 0"<<std::endl);
	    if (shown) DecNbWindowsShown();
	    DecNbWindowsAlive();
	  }

      }
    bbtkBlackBoxDebugMessage("widget",9,"<== WidgetBlackBox::bbUserFinalizeProcessing() ["<<bbGetFullName()<<"]"<<std::endl);
    */
  }
  //=========================================================================
  


 

  //=========================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbProcess()
  { 
    // TODO : update the window size and title 
    this->bbUserProcess(); 
  }
  //=========================================================================

  //=========================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbCreateWindow()
  { 


    // If output 'Widget' not connected then
    // it is a top level Widget have to create and show the Window
    if ( ! bbIsOutputWidgetConnected() )
      {
	// create the Window if does not exist
	if (!bbWindowIsCreated())
	  {
	    bbtkBlackBoxDebugMessage("widget",2,
			     "-> Creating the window"
			     <<std::endl);
	    // Reinitializing
	    bbSetShown(false);
	    bbmNestedWidgetBoxes.clear();
	    
	    //	    this->InitWindowManagerIfNeeded();
	    // If is a Dialog requested
	    if ( bbGetInputWinDialog() )
	      {
		bbtkBlackBoxDebugMessage("widget",2,
				 "   Input WinDialog set to true : creating a Dialog"
				 <<std::endl);
		this->bbCreateDialogWindow();
	      }
	    // Input WinDialog set to false : creating a Frame
	    else 
	      {
		bbtkBlackBoxDebugMessage("widget",2,
				 "   Input WinDialog set to false : creating a Frame"
				 <<std::endl);
		this->bbCreateFrameWindow();
	      }
	  }
	/*
	// Show the window
	if ( !bbGetWindow() )
	  {
	    bbtkInternalError("Need to show the Window of widget "<<bbGetName()
			      <<" however was not created by apropriate cb");
	  }
	*/

	/*
	bbtkBlackBoxDebugMessage("widget",2,
			 "-> Showing the window"
			 <<std::endl);
	//	bbGetWindow()->bbShow(); 
	this->bbShowWindow();
	*/
      }		  
    //   
  }
  //=========================================================================
  

  //==================================================================
  template <class T>  
  typename WidgetBlackBox<T>::WidgetPointer  
  WidgetBlackBox<T>::bbCreateWidgetOfInput
  (const std::string& in, typename WidgetBlackBox<T>::WidgetPointer parent)
  {
    bbtkBlackBoxDebugMessage("widget",2,"bbCreateWidgetOfInput("
			     <<in<<","<<parent<<")"
			     <<std::endl);
    Widget* w = 0;
    // If input is connected 
    BlackBoxInputConnector* c = bbGetInputConnectorMap().find(in)->second ;
    if ( c->IsConnected() )			
      {
	// Get black box from 
	BlackBox::Pointer from = 
	  c->GetConnection()->GetBlackBoxFrom();
	// Cast it into a WidgetBlackBox
	typename WidgetBlackBox<T>::Pointer wfrom 
	  = boost::dynamic_pointer_cast<WidgetBlackBox<T> >(from);
	// If the black box from construction is not done yet : do it
	 // If not constructed do it 
	wfrom->bbInitializeProcessing();
	// Call bbUserCreateWidget
	wfrom->bbUserCreateWidget(parent);
	// Get the widget created
	w = wfrom->bbGetOutputWidget();
	// Insert the box into the NestedWidgetBoxes list
	bbmNestedWidgetBoxes.push_back(from);
      }
    return w;
  }
  //==================================================================

  //=========================================================================
  template <class T>  
  bool WidgetBlackBox<T>::bbIsOutputWidgetConnected()
  {
    return ((*bbGetOutputConnectorMap().find("Widget")).second->GetConnectionVector().size() != 0 );
  }
  //==================================================================

  //==================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbSetShown(bool b)
  {
    if (b==bbmShown) return;

    bbtkBlackBoxDebugMessage("widget",5,"WidgetBlackBox::bbSetShown("
			     <<b<<")"
			     <<std::endl);
    
    bbmShown = b;
    if (b)
      {
	this->bbUserOnShow();
     }
    // Have to propagate to nested widgets
    std::vector<BlackBox::WeakPointer>::const_iterator i;
    for (i =bbmNestedWidgetBoxes.begin();
	 i!=bbmNestedWidgetBoxes.end();
	 ++i)
      {
	if (!i->expired()) i->lock()->bbSetShown(b);
      }
	 
  }
  //==================================================================

  //==================================================================
   template <class T>  
   bool WidgetBlackBox<T>::bbIsShown()
  {
    return bbmShown;
  }
  //==================================================================
 
  /*
 //==================================================================
  template <class T>  
   void WidgetBlackBox<T>::bbShowWindow()
  {
    bbtkBlackBoxDebugMessage("widget",1,"=> WidgetBlackBox::bbShowWindow() ["
			<<bbGetFullName()<<"]"<<std::endl);

    if (bbGetWindow()!=0) bbGetWindow()->bbShow();

    bbtkBlackBoxDebugMessage("widget",1,"<= WidgetBlackBox::bbShowWindow() ["
			<<bbGetFullName()<<"]"<<std::endl);
  }
  //==================================================================

  //==================================================================
  template <class T>  
   void WidgetBlackBox<T>::bbHideWindow()
  {
    bbtkBlackBoxDebugMessage("widget",1,"=> WidgetBlackBox::bbHideWindow() ["
			<<bbGetFullName()<<"]"<<std::endl);

    if (bbGetWindow()!=0) bbGetWindow()->bbHide();

    bbtkBlackBoxDebugMessage("widget",1,"<= WidgetBlackBox::bbHideWindow() ["
			<<bbGetFullName()<<"]"<<std::endl);
  }
  //==================================================================


  //==================================================================
  template <class T>  
  void WidgetBlackBox<T>::bbCloseWindow()
  {
    bbtkBlackBoxDebugMessage("widget",1,"=> WidgetBlackBox::bbCloseWindow() ["
			<<bbGetFullName()<<"]"<<std::endl);

    if (bbGetWindow()!=0) bbGetWindow()->bbDestroy();

    bbtkBlackBoxDebugMessage("widget",1,"<= WidgetBlackBox::bbCloseWindow() ["
			<<bbGetFullName()<<"]"<<std::endl);
  }
  //==================================================================

  //==================================================================
  template <class T>  
  typename WidgetBlackBox<T>::Window* 
  WidgetBlackBox<T>::bbGetContainingWindow()
  {
    if (bbGetWindow()!=0) return bbGetWindow();
    BlackBox::OutputConnectorMapType::const_iterator i 
      = bbGetOutputConnectorMap().find("Widget");
    if ( i->second->GetConnectionVector().size() != 0 ) 
      {
	return boost::static_pointer_cast<WidgetBlackBox>
	  (i->second->GetConnectionVector().front() //.lock()
	   ->GetBlackBoxTo())->bbGetContainingWindow();
      }
    return 0;
  }
  //==================================================================


  //==================================================================
  template <class T>  
  bool WidgetBlackBox<T>::bbIsShown()
  {
    if (bbGetContainingWindow()!=0)
      return bbGetContainingWindow()->bbIsShown();
    return false;
  }
  //==================================================================
  */

}//namespace bbtk




