/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWx.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.17 $
=========================================================================*/



#include "bbtkWx.h"
#include "bbtkMessageManager.h"

#ifdef _USE_WXWIDGETS_

namespace bbtk
{
  //=========================================================================
  class WxApp;
  //=========================================================================

  //=========================================================================
  static WxApp* mgWxApp = 0;
  static wxWindow* mgTopWindow = 0;
  static int mgNbWindowsAlive  = 0;
  //=========================================================================
  
  //=========================================================================
  // BBTKWXSIG
  static Wx::Signal_type mgWxSignal;
  // \BBTKWXSIG
  //=========================================================================

 
  //=========================================================================
  // The wxApp class which is used when no user wxApp was created
  class WxApp : public wxApp
  {
  public:
    bool OnInit( );
    int  OnExit() { return true; }
  };
  //=========================================================================
  IMPLEMENT_APP_NO_MAIN(WxApp);
  //=========================================================================
  bool WxApp::OnInit( )
  {	 
    wxApp::OnInit();
#ifdef __WXGTK__
    //See http://www.wxwindows.org/faqgtk.htm#locale
    setlocale(LC_NUMERIC, "C");
#endif
    return true;
  }
  //=========================================================================

  //=========================================================================
  void Wx::CreateWxAppIfNeeded()
  {
    if (wxApp::GetInstance()==0)
      {
	if (mgWxApp != 0) 
	  {
	    bbtkGlobalError("Wx::CreateWxAppIfNeeded() : INTERNAL ERROR ! (wxApp::GetInstance()==0) && (mgWxApp != 0)");
	  }
	bbtkDebugMessage("wx",1,"  --> Creating bbtk wxApp"<<std::endl);
	mgWxApp = new WxApp;
	wxApp::SetInstance(mgWxApp);
	wxInitialize();
      } 
  }
  //=========================================================================

  //=========================================================================
  void Wx::DestroyWxAppIfNeeded()
  {
    if (mgWxApp!= 0) 
      {
	//	bbtkDebugMessage("wx",1,"  --> Destructing bbtk WxApp"<<std::endl);
	//delete mgWxApp;
	//	mgWxApp = 0;
	// Uninit wx
	//	wxUninitialize();
      }
  }
  //=========================================================================


  //=========================================================================
  void Wx::ProcessPendingEvents()
  {
    /*
    if (Wx::GetTopWindow() != 0)
      {
	Wx::GetTopWindow()->DestroyChildren();
      }
    */

    /*
    wxApp* a = (wxApp*)wxApp::GetInstance();
    if (a==0) return;
    
    std::cout << "$$$$$$$$$$$$$$ PROCESS PENDING "<<std::endl;
    while (a->Pending())
      a->Dispatch();
    std::cout << "$$$$$$$$$$$$$$ PROCESS PENDING DONE"<<std::endl;
    */
  }


  //=========================================================================
  wxWindow* Wx::GetTopWindow() 
  { 
    return mgTopWindow; 
  }
  //=========================================================================
  

  // BBTKWXSIG
  //=========================================================================
  void Wx::AddSignalObserver(Slot_function_type f)
  {
    mgWxSignal.connect(f);
  }
  //=========================================================================
  // \BBTKWXSIG

  
  //=========================================================================
  void Wx::SetTopWindow(wxWindow* w) 
  {
    if ( mgTopWindow ) 
      {
	bbtkGlobalError("Wx::SetTopWindow : top window already set !");
      } 
    //mgTopWindow = w;
  }
  //=========================================================================


  //=========================================================================
  void Wx::IncNbWindowsAlive() 
  { 
    mgNbWindowsAlive++; 
    bbtkDebugMessage("wx",2,"* Number of windows alive = "<<mgNbWindowsAlive
		     <<std::endl);
    // BBTKWXSIG
    mgWxSignal();
    // \BBTKWXSIG
  }
  //=========================================================================

  //=========================================================================
  void Wx::DecNbWindowsAlive()
  { 
    mgNbWindowsAlive--; 
    bbtkDebugMessage("wx",2,"* Number of windows alive = "<<mgNbWindowsAlive
		     <<std::endl);

    // BBTKWXSIG
    mgWxSignal();
    // \BBTKWXSIG
  }
  //=========================================================================

  //=========================================================================
  int  Wx::GetNbWindowsAlive() 
  { 
    return mgNbWindowsAlive; 
  }
  //=========================================================================
  
  //=========================================================================
  bool Wx::IsSomeWindowAlive() 
  { 
    return (mgNbWindowsAlive!=0);
  }
  //=========================================================================
  

  //=========================================================================
  Wx::BusyCursor::BusyCursor()
  {
    mCursor = 0;
    if (wxApp::GetInstance()!=0) 
      { 	
	bbtkDebugMessage("wx",2,
			 "Wx::BusyCursor::BusyCursor() : creating new cursor"
			 <<std::endl);
	//mCursor = new wxBusyCursor; 
    }
  }
  //=========================================================================
  //=========================================================================
  Wx::BusyCursor::~BusyCursor()
  {
    if (mCursor)
      { 
	//delete mCursor;
	bbtkDebugMessage("wx",2,
			 "Wx::BusyCursor::~BusyCursor() : deleting cursor"<<std::endl);
      }
  }
  //=========================================================================



} // namespace bbtk

#else
//=======================================================================
// WITHOUT WX
//=========================================================================
namespace bbtk
{
   //=========================================================================
  Wx::BusyCursor::BusyCursor()
  {
  }
  Wx::BusyCursor::~BusyCursor()
  {
  }
  //=========================================================================

} // namespace bbtk
#endif

