/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxBlackBox.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.45 $
=========================================================================*/



#ifdef _USE_WXWIDGETS_

/**
 *  \file 
 *  \brief 
 */
 
#include "bbtkWxBlackBox.h"
#include "bbtkBlackBoxOutputConnector.h"

//#include "bbtkWxContainerBlackBox.h"
#include <wx/dialog.h>

//#include "bbtkData.h"
//#include "bbtkFactory.h"

namespace bbtk
{
  //=========================================================================
  // WxFrame
  //=========================================================================

  //==================================================================
  class WxFrame : public wxFrame
  {
  public:
    WxFrame(WxBlackBox::Pointer b,
	    wxWindow *parent,
	    wxString title,
	    wxSize size);
    ~WxFrame();
    void OnCloseWindow(wxCloseEvent& event);


    WxBlackBox::WeakPointer mBox;      
    DECLARE_EVENT_TABLE();
    
  };
  
  BEGIN_EVENT_TABLE(WxFrame, wxFrame)
  //  EVT_CLOSE(WxFrame::OnCloseWindow)
    END_EVENT_TABLE();
     //==================================================================
  
     //==================================================================
  WxFrame::WxFrame(WxBlackBox::Pointer b,
		   wxWindow *parent,
		   wxString title,
		   wxSize size) 
    : 
    wxFrame( parent, 
	     -1, 
	     title,
	     wxDefaultPosition,
	     size,
	     wxRESIZE_BORDER | 
	     wxSYSTEM_MENU  |
	     wxCLOSE_BOX |
	     wxMAXIMIZE_BOX | 
	     wxMINIMIZE_BOX | 
	     wxCAPTION  
	     ),
    mBox(b)
  {   
    bbtkDebugMessage("widget",9,"["<<b->bbGetName()<<"] WxFrame()"
		     <<std::endl);
    Wx::IncNbWindowsAlive();
    b->bbSetWindow(this);
    // Insert the widget into the window
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    b->bbUserCreateWidget(this);
    wxWindow* widget = b->bbGetOutputWidget();
    sizer->Add( widget, 1, wxALL|wxGROW, 2);
    SetSizer(sizer);
    Layout();
  }
  //==================================================================
  //==================================================================
  WxFrame::~WxFrame() 
    { 
      if (mBox.lock())
	bbtkDebugMessage("widget",9,"["<<mBox.lock()->bbGetName()
			 <<"] $$$$$$$$$$$$$$$$$$$ ~WxFrame()"
			 <<std::endl);
      else 
	bbtkDebugMessage("widget",9,"[DEAD] $$$$$$$$$$$$$$$$$$$$$ ~WxFrame()"<<std::endl);
      //bbtkDebugMessage("widget",9,"WxFrame::~WxFrame()"<<std::endl);
      if (mBox.lock()) mBox.lock()->bbSetWindow(0); 
      Wx::DecNbWindowsAlive();
    }
   //==================================================================
   //==================================================================
  void WxFrame::OnCloseWindow(wxCloseEvent& event)
    {
      if (mBox.lock())
	bbtkDebugMessage("widget",9,"["<<mBox.lock()->bbGetName()
			 <<"] $$$$$$$$$$$$$$$ WxFrame::OnCloseWindow()"<<std::endl);
      else
	bbtkDebugMessage("widget",9,"[DEAD] WxFrame::OnCloseWindow()"
			 <<std::endl);
      if (mBox.lock()) mBox.lock()->bbSetWindow(0); 
      Wx::DecNbWindowsAlive();
      
 	bbtkDebugMessage("widget",9,
			 "$$$$$$$$$$$$$$$ Destroy !!!"<<std::endl);
	//	this->Destroy();
    }
   //==================================================================

  //=========================================================================
  // WxDialog
  //=========================================================================

   //==================================================================
  // Dialog window which is modal
  class BBTK_EXPORT  WxDialog : public wxDialog
  {
  public:
    WxDialog(WxBlackBox::Pointer box, 
		     wxWindow *parent, 
		     wxString title, 
		     wxSize size);
    ~WxDialog();
    void OnCloseWindow(wxCloseEvent& event);


    WxBlackBox::WeakPointer mBox;      
    DECLARE_EVENT_TABLE();
    
  };
  
  BEGIN_EVENT_TABLE(WxDialog, wxDialog)
    EVT_CLOSE(WxDialog::OnCloseWindow)
    END_EVENT_TABLE();
  //=========================================================================

  //=========================================================================
  WxDialog::WxDialog(WxBlackBox::Pointer b,
		     wxWindow *parent,
		     wxString title,
		     wxSize size)
    :
    wxDialog( parent, 
		-1, 
		title,
		wxDefaultPosition,
		size,
		wxRESIZE_BORDER | 
		wxSYSTEM_MENU  |
		wxCLOSE_BOX |
		wxMAXIMIZE_BOX | 
		wxMINIMIZE_BOX | 
		wxCAPTION  
	      ),
    mBox(b)
  {
    bbtkDebugMessage("widget",9,"WxDialog::WxDialog ["<<b->bbGetName()<<"]"
		     <<std::endl);
    Wx::IncNbWindowsAlive();
    b->bbSetWindow(this);
    // Insert the widget into the window
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    b->bbUserCreateWidget(this);
    wxWindow* widget = b->bbGetOutputWidget();
    sizer->Add( widget, 1, wxALL|wxGROW, 2);
    SetSizer(sizer);
    Layout();
  }
  //==================================================================
  //==================================================================
  WxDialog::~WxDialog() 
    { 
      bbtkDebugMessage("widget",9,"WxDialog::~WxDialog()"<<std::endl);
      //bbtkDebugMessage("widget",9,"WxFrame::~WxFrame()"<<std::endl);
      //      if (mBox.lock()) mBox.lock()->bbSetWindow(0); 
      //      Wx::DecNbWindowsAlive();
    }
   //==================================================================
   //==================================================================
  void WxDialog::OnCloseWindow(wxCloseEvent& event)
    {
      bbtkDebugMessage("widget",9,"WxDialog::OnCloseWindow()"<<std::endl);
      if (mBox.lock()) mBox.lock()->bbSetWindow(0); 
      Wx::DecNbWindowsAlive();
      this->Destroy();
    }
   //==================================================================


 //=========================================================================
  // WxBlackBox
  //=========================================================================

  //=========================================================================
  //=========================================================================
  //=========================================================================
  //=========================================================================
  BBTK_BLACK_BOX_IMPLEMENTATION(WxBlackBox,WidgetBlackBox<wxWindow>);
  //=========================================================================
  
  //=========================================================================
  void WxBlackBox::bbUserSetDefaultValues()
  {
    bbtkBlackBoxDebugMessage("widget",5,"WxBlackBox::bbUserSetDefaultValues()"<<std::endl);
    bbmWindow = 0;
  }
  //=========================================================================

  //=========================================================================
  void WxBlackBox::bbUserInitializeProcessing()
  {
  }
  //==================================================================    

  //=========================================================================
  void WxBlackBox::bbUserFinalizeProcessing()
  {
    bbtkBlackBoxDebugMessage("widget",5,"==> WxBlackBox::bbUserFinalizeProcessing()"<<std::endl);
    bbDestroyWindow();
    bbtkBlackBoxDebugMessage("widget",5,"<== WxBlackBox::bbUserFinalizeProcessing()"<<std::endl);
  }
  //==================================================================    

  //==================================================================    
  /// Callback for creating a Dialog window (modal)
  void WxBlackBox::bbCreateDialogWindow()
  {
  bbtkBlackBoxDebugMessage("widget",3,
		     "==> WxBlackBox::bbCreateDialogWindow() - parent = "
		     <<Wx::GetTopWindow()
		     <<std::endl);
    WxDialog* w = 0;  
    w = new WxDialog( GetThisPointer<WxBlackBox>(),
		      Wx::GetTopWindow(),
		      std2wx( bbGetInputWinTitle()  
			      + " - bbtk (c) CREATIS"),
		      wxSize( bbGetInputWinWidth() , 
			      bbGetInputWinHeight() ) );
    w->Show(false);
    //    w->ShowModal();
  } 
  //=========================================================================

  //==================================================================    

  //==================================================================    
  /// Callback for creating a Frame window 
  void WxBlackBox::bbCreateFrameWindow()
  {
    bbtkBlackBoxDebugMessage("widget",3,
		     "==> WxBlackBox::bbCreateFrameWindow() - parent = "
		     <<Wx::GetTopWindow()
		     <<std::endl);
    WxFrame* w = 0;  
    w = new WxFrame( GetThisPointer<WxBlackBox>(),
		     Wx::GetTopWindow(),
		     std2wx( bbGetInputWinTitle()  
			     + " - bbtk (c) CREATIS"),
		     wxSize( bbGetInputWinWidth() , 
			     bbGetInputWinHeight() ) );
    w->Show();
   }

  //==================================================================    

  //==================================================================    
  void WxBlackBox::bbSetWindow(wxWindow* w) 
  {
    bbtkBlackBoxDebugMessage("widget",9,"==> WxBlackBox::bbSetWindow("<<w<<")"<<std::endl);
    if ((bbmWindow != 0)&&(w!=0)) 
      { 
	std::cout << "ERRRRRRRROOOOR"<<std::endl; 
      }
    bbmWindow = w;
  }
  //==================================================================    

  //==================================================================    
  void WxBlackBox::bbShowWindow()
  {
    if ((bbmWindow) && (!bbIsShown()))
      {
	bbtkBlackBoxDebugMessage("widget",3,"==> WxBlackBox::bbShowWindow()"
			 <<std::endl);
 	if (bbGetInputWinDialog()) 
	  {
	    ((WxDialog*)bbmWindow)->ShowModal();
	  }
	else
	  {
	    bbGetWindow()->Show();
	    bbSetShown(true);
	  } 
      }
  }
  //==================================================================    

  //==================================================================    
  void WxBlackBox::bbDestroyWindow()
  {
    bbtkBlackBoxDebugMessage("widget",3,"==> WxBlackBox::bbDestroyWindow("<<bbmWindow<<")"<<std::endl);
    if (bbGetWindow()!=NULL) 
      {
	//       wxWindow* w = bbGetWindow();
	//bbSetWindow(0);
	// WE SHOULD DESTROY THE WINDOW WITH THE Close METHOD
	// HOWEVER I
	//w->Close(true);
	//
	delete bbGetWindow();
	bbSetShown(false);
      }
    bbtkBlackBoxDebugMessage("widget",3,"<== WxBlackBox::bbDestroyWindow("<<bbmWindow<<")"<<std::endl);

  }
  //==================================================================    

}//namespace bbtk

#endif

