/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUICommand.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.9 $
=========================================================================*/



/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

#include "bbtkWxGUICommand.h"
#include "bbtkMessageManager.h"
#include "bbtkConfigurationFile.h"
#include "bbtkWxGUIPackageBrowser2.h" 

namespace bbtk
{
  //================================================================  
  BEGIN_EVENT_TABLE(WxGUICommand, wxPanel)
    EVT_TEXT_ENTER(WxGUICommand::ID_Text_Command, WxGUICommand::OnCommandEnter)
    EVT_BUTTON(WxGUICommand::ID_Btn_Go, WxGUICommand::OnBtnGo)
    EVT_BUTTON(WxGUICommand::ID_Btn_Include, WxGUICommand::OnBtnInclude)
    EVT_BUTTON(WxGUICommand::ID_Btn_Reset, WxGUICommand::OnBtnReset)
    EVT_BUTTON(WxGUICommand::ID_Btn_Config, WxGUICommand::OnBtnConfig)
    EVT_BUTTON(WxGUICommand::ID_Btn_GraphS, WxGUICommand::OnBtnGraphS)
    EVT_BUTTON(WxGUICommand::ID_Btn_GraphD, WxGUICommand::OnBtnGraphD)
    EVT_BUTTON(WxGUICommand::ID_Btn_Help, WxGUICommand::OnBtnHelp)
    EVT_BUTTON(WxGUICommand::ID_Btn_PackageBrowser, WxGUICommand::OnBtnPackageBrowser)
   END_EVENT_TABLE()
  //================================================================


  WxGUICommand::WxGUICommand(wxWindow *parent, WxGUICommandUser* user)
    : wxPanel(parent,-1),
      mUser(user)
  {
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    
    mwxTextCommand = 
      new wxComboBox(this,
		     ID_Text_Command,
		     _T(""),
		     wxDefaultPosition,
		     wxDefaultSize,
		     0, NULL,
		     wxTE_PROCESS_ENTER
		     //		    | wxTE_PROCESS_TAB 
		     //		    | wxWANTS_CHARS 
		     //		    //|  wxTAB_TRAVERSAL
		     );
    
    wxButton *btnGo 	= new wxButton(this,ID_Btn_Go,_T("Go"));	  
    
    wxFlexGridSizer *sizerCommand= new wxFlexGridSizer(2);
    sizerCommand->AddGrowableCol(0);
    sizerCommand->Add(mwxTextCommand,1,wxGROW);
    sizerCommand->Add(btnGo);
    
    sizer->Add(sizerCommand,0,wxGROW);

    wxBoxSizer *btnsSizer	= new wxBoxSizer(wxHORIZONTAL);
    
    wxButton *btnInclude		= new wxButton(this,ID_Btn_Include		,_T("include")			);
    wxButton *btnReset			= new wxButton(this,ID_Btn_Reset		,_T("reset")			);
    wxButton *btnConfig			= new wxButton(this,ID_Btn_Config		,_T("config")			);
    wxButton *btnGraphS			= new wxButton(this,ID_Btn_GraphS		,_T("graph (simple)")	);
    wxButton *btnGraphD			= new wxButton(this,ID_Btn_GraphD		,_T("graph (detailed)") );
    wxButton *btnHelp			= new wxButton(this,ID_Btn_Help			,_T("help")				);
    wxButton *btnPackageBrowser    = new wxButton(this,ID_Btn_PackageBrowser	,_T("Start Package Browser")     );
    
    btnsSizer->Add( btnInclude 		);
    btnsSizer->Add( btnReset 		);
    btnsSizer->Add( btnConfig		);
    btnsSizer->Add( btnGraphS 		);
    btnsSizer->Add( btnGraphD 		);
    btnsSizer->Add( btnHelp 		);
    btnsSizer->Add( btnPackageBrowser 	);
    
    sizer->Add(btnsSizer,0,wxTOP|wxGROW, 10 );

    SetSizer(sizer);
    
    SetAutoLayout(true);
    Layout();
  }

  WxGUICommand::~WxGUICommand()
  {
  }
    
  void WxGUICommand::OnBtnGo(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnGo"<<std::endl);
    SendCommand(wx2std(mwxTextCommand->GetValue()));
  }
  
  void WxGUICommand::OnCommandEnter(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnCommandEnter"<<std::endl);
    SendCommand(wx2std(mwxTextCommand->GetValue()));
  }
  
  void WxGUICommand::SendCommand(const std::string& command)
  {
    if (command.length()==0) return;

    mwxTextCommand->SetValue(_T(""));
    mwxTextCommand->Append(std2wx(command));
    if (mUser) mUser->WxGUICommandEnter(command);
  }


  void WxGUICommand::OnBtnInclude(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnInclude"<<std::endl);

    std::string default_doc_dir = 
      ConfigurationFile::GetInstance().Get_default_temp_dir();
    std::string stdDir = default_doc_dir+"/share/bbtk/bbs";
    wxString defaultDir(stdDir.c_str(), wxConvUTF8);

    wxFileDialog dialog(this, _T("Include file"),defaultDir, _T(""), _T("*.bbs"), wxOPEN );
    if (dialog.ShowModal() == wxID_OK)
     {
       // std::string command(_T("include "));
       // std::string pathfilename = (const char *)(dialog.GetFilename().mb_str());
       std::string command("include ");
       command = command + "\"" + wx2std(dialog.GetPath()) + "\"";
       SendCommand(command);
     }
  }

  void WxGUICommand::OnBtnReset(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnReset"<<std::endl);
    SendCommand("reset");
  }

  void WxGUICommand::OnBtnConfig(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnConfig"<<std::endl);
    SendCommand("config");
  }
  
  void WxGUICommand::OnBtnGraphS(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnGraphS"<<std::endl);
    SendCommand("graph");
  }
  
  void WxGUICommand::OnBtnGraphD(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnGraphD"<<std::endl);
    SendCommand("graph . 1");
  }

  void WxGUICommand::OnBtnHelp(wxCommandEvent& event)
  {
    bbtkDebugMessage("gui",2,"WxGUICommand::OnBtnHelp"<<std::endl);
    SendCommand("help");
  }

  void WxGUICommand::OnBtnPackageBrowser(wxCommandEvent& event)
  {
	wxBusyCursor wait;
	WxGUIPackageBrowser2Window *helpbrowser = new
	WxGUIPackageBrowser2Window(this,_T("Package Browser"), wxSize(600,600) );
	helpbrowser->Show();
  }
  
} // namespace bbtk

#endif //  _USE_WXWIDGETS_
