/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIConsole.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.18 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

#include <iostream>	
#include "bbtkWxGUIConsole.h"
#include "bbtkWxBlackBox.h"
#include "bbtkConfigurationFile.h"
#include "bbtkWxStreamRedirector.h"
 

#include "icons/cc_run.xpm"

namespace bbtk
{

    enum
    {
      ID_Menu_Quit = 1,
      ID_Menu_About,
      ID_Menu_EditConfig,
      ID_Menu_CreatePackage,
      ID_Menu_CreateBlackBox,
      ID_Menu_ShowImageGraph,
      ID_Menu_ShowHTMLDoc,
      ID_Menu_CreateIndex,
      ID_Button_Run
    };
    
  
  //================================================================
  WxGUIConsole::WxGUIConsole( wxWindow *parent, wxString title, wxSize size)
    : wxFrame((wxFrame *)parent, -1, title, wxDefaultPosition, size)
  {	
//    m_mgr = new wxAuiManager(this);
	m_mgr.SetManagedWindow(this);
   
	mInterpreter = bbtk::Interpreter::New();
    mInterpreter->SetUser(this);
    mInterpreter->SetCommandLine(true);
    mInterpreter->SetThrow(false);
    //==============
    // Menu
    wxInitAllImageHandlers();
    
    wxMenu *menuFile = new wxMenu;
    menuFile->Append( ID_Menu_Quit, _T("&Quit") );
    
    wxMenu *menuAbout = new wxMenu;
    menuAbout->Append( ID_Menu_About, _T("&About...") );

    wxMenu *menuTools = new wxMenu;
    menuTools->Append( ID_Menu_EditConfig, _T("&Edit bbtk config") );
    menuTools->Append( ID_Menu_CreatePackage, _T("Create &package") );
    menuTools->Append( ID_Menu_CreateBlackBox, _T("Create &blackbox") );
    menuTools->Append( ID_Menu_ShowImageGraph, _T("&Show last image graph") );
    menuTools->Append( ID_Menu_ShowHTMLDoc, _T("Show &HTML documentation") );
    menuTools->Append( ID_Menu_CreateIndex, _T("&Generate index") );
    
    
    wxMenuBar *menuBar = new wxMenuBar;
    menuBar->Append( menuFile, _T("&File") );
    menuBar->Append( menuTools, _T("&Tools") );
    menuBar->Append( menuAbout, _T("About") );
    
    SetMenuBar( menuBar );
    
    CreateStatusBar();
    SetStatusText( _T("Welcome to bbi !") );
    
    //==============
    // Notebook
    
    //    wxFlexGridSizer *sizer = new wxFlexGridSizer(1);
    
//EED    wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
//    mwxNotebook = new wxNotebook(this,-1,wxDefaultPosition, wxDefaultSize, 0);
    mwxNotebook = new wxAuiNotebook(this,  
                                    -1,
                                    wxPoint(0, 0),
                                    wxSize(500,500),
                                    wxAUI_NB_TAB_SPLIT | wxAUI_NB_TAB_EXTERNAL_MOVE | wxNO_BORDER);
    
    mwxPageCommand = new wxPanel(mwxNotebook,-1);        
    mwxPageHelp = new wxPanel(mwxNotebook,-1);    
    
    
    wxBoxSizer *cmdsizer = new wxBoxSizer(wxVERTICAL);
    
    mwxPageCommand->SetAutoLayout(true);    
    mwxPageCommand->SetSizer(cmdsizer);
    cmdsizer->Fit(mwxPageCommand);
    cmdsizer->SetSizeHints(mwxPageCommand);

    wxBoxSizer *helpsizer = new wxBoxSizer(wxVERTICAL);
    
    mwxPageHelp->SetAutoLayout(true);    
    mwxPageHelp->SetSizer(helpsizer);
    helpsizer->Fit(mwxPageHelp);
    helpsizer->SetSizeHints(mwxPageHelp);
   
    mWxGUIHtmlBrowser = new WxGUIHtmlBrowser(mwxPageHelp,
					     //EED				  wxSize(1200,0));
					     wxSize(200,0));

    //    mWxGUIHtmlBrowser->SetSize(wxSize(800,1000));
    helpsizer->Add (mWxGUIHtmlBrowser,1, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5  );
//    helpsizer->Add ( new wxButton(mwxPageHelp,-1,"perro"), 0,  wxEXPAND  );
    wxBitmap bmp_run(cc_run_xpm);
    mwxButtonRun = new wxBitmapButton( mwxPageHelp,ID_Button_Run,bmp_run);//_T("Run")  );
    helpsizer->Add( mwxButtonRun, 0, wxALL, 5  );

  
    //==============
    // Command page 
    mWxGUIOutputMessages = new WxGUIOutputMessages(mwxPageCommand);

    mWxGUICommand = new WxGUICommand(mwxPageCommand,this);
   
    mWxGUICommand->SetFocus();

    cmdsizer->Add (mWxGUIOutputMessages, 1, wxALL | wxGROW, 5);
    cmdsizer->Add (mWxGUICommand, 0, wxALL | wxGROW, 5);

        
    // Set the parent window of all bbtk windows as a child of this
    //    bbtk::Wx::SetTopWindowParent(this);
    bbtk::Wx::SetTopWindow(this);
    // Top Window Auto Destroys when no more black box window alive 
    // : this is the default 
    //    bbtk::Wx::SetAutoDestroyTopWindow(true);
    // Add the method OnWxSignal as a Wx::Signal observer 
    bbtkAddWxSignalObserver(WxGUIConsole::OnWxSignal);


    // Layout
//EED    SetSizer(sizer);

    mwxNotebook->AddPage( mwxPageCommand, _T("Command"));
    mwxNotebook->AddPage( mwxPageHelp, _T("Help"));
    m_mgr.AddPane(mwxNotebook, wxAuiPaneInfo().Name(wxT("notebook_content")).CenterPane().PaneBorder(false)); 
    m_mgr.Update();
	
    SetAutoLayout(true);
    Layout();
//    Refresh();
//    m_mgr.Update();
  }
  //================================================================

 //================================================================
  WxGUIConsole::~WxGUIConsole()
  {
    m_mgr.UnInit();
  }
  //================================================================

  //================================================================
  void WxGUIConsole::OnClose(wxCloseEvent& event)
  {
    bbtkDebugMessage("widget",9,"bbi::OnClose()"<<std::endl);
    //Wx::SetWindowsHaveBeenDestroyedByParent();
    //mInterpreter.reset();
    wxWindowList& list = GetChildren();
    wxWindowList::iterator iter;
    for (iter = list.begin(); iter != list.end(); ++iter)
      {
	(*iter)->Close();
      }
    this->Destroy();
  }
  //================================================================

  //================================================================
  void WxGUIConsole::OnWxSignal()
  {
    if ((!bbtk::Wx::IsSomeWindowAlive())&&(!IsShown())) 
      {
	bbtkDebugMessage("wx",2,"  --> bbtk top window destroyed and WxGUIConsole not shown => destructing"<<std::endl);
	/*
	wxWindowList& list = GetChildren();
	wxWindowList::iterator iter;
	for (iter = list.begin(); iter != list.end(); ++iter)
	  {
	    (*iter)->Close();
	  }
	*/
	Close();
      }
  }
  //================================================================

  //================================================================
  void WxGUIConsole::WxGUICommandEnter(const std::string& command)
  {
    std::string s("> ");
    s += command + "\n";
    mWxGUIOutputMessages->Print(s,wxRED);

    if (  mInterpreter->InterpretLine( command ) == 
	  Interpreter::Interpreter_QUIT )
      {
	Close(true); 
      }
  }
  //================================================================

  //================================================================
  /// Runs the interpretation of a file
  bool WxGUIConsole::InterpretFile( const std::string& filename) 
  { 
    if ( mInterpreter->InterpretFile(filename) ==
	 Interpreter::Interpreter_ERROR ) 
      {
	return false;
      }
    return true;
  }
  //================================================================
 
  //================================================================
  void WxGUIConsole::OnButtonRun(wxCommandEvent& WXUNUSED(event))
  {
//    wxString temp = mWxGUIHtmlBrowser->GetCurrentPage();
    std::string filename = mWxGUIHtmlBrowser->GetCurrentPage();//wx2std(temp);
    size_t s = filename.length();

    Interpreter::Pointer I = Interpreter::New();
    
    if ((s>3) && (filename[s-1]=='s')
	&& (filename[s-2]=='b')
	&& (filename[s-3]=='b')
	&& (filename[s-4]=='.'))
      {
        std::string tmp("Executing ");
        tmp += filename;
	SetStatusText(std2wx(tmp));
	I->InterpretFile(filename);
      }
    else
      {
	SetStatusText(_T("The current page is not a bbs file : cannot execute it"));
      }

  }
  //================================================================  

  //================================================================
  void WxGUIConsole::OnMenuQuit(wxCommandEvent& WXUNUSED(event))
  {
    Close(true);
  }
  //================================================================


  //================================================================
  void WxGUIConsole::OnMenuAbout(wxCommandEvent& WXUNUSED(event))
  {
    m_mgr.Update();
	Refresh();
    wxMessageBox(_T("  bbi\nThe Black Box Toolkit interpreter\n(c) CREATIS 2008"),
                 _T("About ..."), wxOK | wxICON_INFORMATION,
                 this);
  }
  //================================================================


  //================================================================
  void WxGUIConsole::OnMenuEditConfig(wxCommandEvent& WXUNUSED(event))
  {
	std::string commandStr;
    std::string configFile = ConfigurationFile::GetInstance().Get_config_xml_full_path();
#ifdef WIN32
	commandStr = "notepad.exe ";
#else
	commandStr = "gedit ";
#endif 
	commandStr = commandStr + configFile;
	std::cout << "system: " << commandStr << std::endl;
	system ( commandStr.c_str() );
  }
  //================================================================


  //================================================================
  void WxGUIConsole::OnMenuCreatePackage(wxCommandEvent& WXUNUSED(event))
  {
    std::string command("toolsbbtk/appli/GUICreatePackage");

    bbtkMessage("Debug",1,"Executing : '"<<command<<"'"<<std::endl);
    Interpreter::Pointer I = Interpreter::New();    
    I->InterpretFile(command);
  }
  //================================================================


  //================================================================
  void WxGUIConsole::OnMenuCreateBlackBox(wxCommandEvent& WXUNUSED(event))
  {
    std::string command("toolsbbtk/appli/GUICreateBlackBox");
    bbtkMessage("Debug",1,"Executing : '"<<command<<"'"<<std::endl);
    Interpreter::Pointer I = Interpreter::New();    
    I->InterpretFile(command);
  }
  //================================================================
  
  //================================================================
  void WxGUIConsole::OnMenuShowImageGraph(wxCommandEvent& WXUNUSED(event))
  {
    std::string default_temp_dir = ConfigurationFile::GetInstance().Get_default_temp_dir();

#if defined(WIN32)
    std::string strappli="start ";
#else
    std::string strappli="gnome-open ";
#endif
    std::string strcommand0 = "cd \"" + default_temp_dir+"/temp_dir/" +"\"";
    std::string strcommand1 = strappli + "workspace_workspacePrototype.png";
    std::string strcommand = strcommand0 + " && " + strcommand1;
	std::cout << "system: " << strcommand << std::endl;
    system ( strcommand.c_str() );

  }
  //================================================================

  //================================================================
  void WxGUIConsole::OnMenuShowHTMLDoc(wxCommandEvent& WXUNUSED(event))
  {
	std::string doc_path		= ConfigurationFile::GetInstance().Get_doc_path();

#if defined(WIN32)
    std::string strappli="start ";
#else
    std::string strappli="gnome-open ";
#endif
    std::string strcommand0 = "cd \"" + doc_path+"\"";
    std::string strcommand1 = strappli + "index.html";
    std::string strcommand = strcommand0 + " && " + strcommand1;
	std::cout << "system: " << strcommand << std::endl;
    system ( strcommand.c_str() );

  }
  //================================================================



  //================================================================
  void WxGUIConsole::OnMenuCreateIndex(wxCommandEvent& WXUNUSED(event))
  {
/*
    std::string doc_path = ConfigurationFile::GetInstance().Get_doc_path();
    std::string filepath = doc_path+"/bbdoc/make-index.bbs";
    Interpreter* I = new Interpreter;    
    I->InterpretLine( "exec freeze");
    I->InterpretLine( "include *");
    I->InterpretLine( "help packages");
    I->InterpretLine( "index "+doc_path+"/bbdoc/index-alpha.html Initials");
    I->InterpretLine( "index "+doc_path+"/bbdoc/index-package.html Packages");
    I->InterpretLine( "index "+doc_path+"/bbdoc/index-category.html Categories");
    I->InterpretLine( "index "+doc_path+"/bbdoc/index-adaptors.html Adaptors");    
    delete I;
*/

	std::string bin_path		= ConfigurationFile::GetInstance().Get_bin_path();
	std::string doc_path		= ConfigurationFile::GetInstance().Get_doc_path();
	std::string bbdoc_path		= doc_path+"/bbdoc";
    std::string make_index_path = "\"" + bbdoc_path+"/make-index.bbs\"";

	std::string strcommand0		= "cd "+bbdoc_path+" && mkdir tmp && cd tmp";

	std::string strcommand1		= "cd "+bbdoc_path+"/tmp";
    std::string strcommand2		= "\""+bin_path+"/bbi\" -N "+make_index_path;
#ifdef WIN32 
    std::string strcommand3		= "move index*.html ../.";
#else
    std::string strcommand3		= "mv index*.html ../.";
#endif

	std::string strcommand		=	strcommand1 +" && "+
									strcommand2 +" && "+
									strcommand3;

	std::cout << "system: " << strcommand0 << std::endl;
	std::cout << "system: " << strcommand << std::endl;

	system ( strcommand0.c_str() );
	system ( strcommand.c_str() );
  }
  //================================================================


  //================================================================
  void WxGUIConsole::InterpreterUserViewHtmlPage(const std::string& page)
  {
    std::string s(page);
    //  std::cout << "WxGUIConsole::ShowHtmlPage('"<<page<<"')"<<std::endl;
    if (mWxGUIHtmlBrowser->GoTo(s)) 
      {
//EED	mwxNotebook->ChangeSelection(1);
    	mwxNotebook->SetSelection(1);
      }
    else 
      {
         // std::cout << "ERROR html"<<std::endl;
      }
  } 
  //================================================================  
  
  //================================================================  
  // Overloaded Show method to handle bbtk::Wx::TopWindow auto-destruction
  // OBSOLETE !!!
  bool WxGUIConsole::Show(bool show)
  {
    //    bbtk::Wx::SetAutoDestroyTopWindow(!show);
    return wxFrame::Show(show);
  }
  //================================================================  
   
  //================================================================  
  BEGIN_EVENT_TABLE(WxGUIConsole, wxFrame)
    EVT_CLOSE(  WxGUIConsole::OnClose)
    EVT_MENU(ID_Menu_Quit			, WxGUIConsole::OnMenuQuit)
    EVT_MENU(ID_Menu_About			, WxGUIConsole::OnMenuAbout)
    EVT_MENU(ID_Menu_EditConfig		, WxGUIConsole::OnMenuEditConfig)
    EVT_MENU(ID_Menu_CreatePackage	, WxGUIConsole::OnMenuCreatePackage)
    EVT_MENU(ID_Menu_CreateBlackBox	, WxGUIConsole::OnMenuCreateBlackBox)
    EVT_MENU(ID_Menu_ShowImageGraph	, WxGUIConsole::OnMenuShowImageGraph)
    EVT_MENU(ID_Menu_ShowHTMLDoc	, WxGUIConsole::OnMenuShowHTMLDoc)
    EVT_MENU(ID_Menu_CreateIndex	, WxGUIConsole::OnMenuCreateIndex)
    EVT_BUTTON(ID_Button_Run		, WxGUIConsole::OnButtonRun )
    END_EVENT_TABLE()
  //================================================================

} // namespace bbtk


#endif //_USE_WXWIDGETS_
