/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIConsole.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.8 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

	
#ifndef __bbtkWxGUIConsole_h__
#define __bbtkWxGUIConsole_h__

#include <wx/aui/aui.h>
#include "bbtkWx.h"
#include <wx/notebook.h>
#include <wx/html/htmlwin.h>


#include "bbtkInterpreter.h"

#include "bbtkWxGUICommand.h"
#include "bbtkWxGUIOutputMessages.h"
#include "bbtkWxGUIHtmlBrowser.h"

namespace bbtk
{

  /// A console in which user can enter commands
  class BBTK_EXPORT WxGUIConsole : public wxFrame, 
				   public InterpreterUser,
				   public WxGUICommandUser
  {
  public:
    WxGUIConsole( wxWindow *parent, wxString title, wxSize size);
    ~WxGUIConsole();

    /// Returns the Interpreter used 
    /// ONLY ONE FOR THE MOMENT BUT IN THE FUTURE CAN BE DIFFERENT 
    /// (DIFFERENT WORKSPACES)
    //Interpreter::Pointer GetInterpreter() { return mInterpreter; }
    /// Returns the Interpreter used (const)
    Interpreter::Pointer GetInterpreter() const { return mInterpreter; }

    /// Sets the inputs of the workspace : 
    /// the map is passed as is to the Executer
    void SetInputs(const std::map<std::string,std::string>& m)
    { mInterpreter->SetInputs(m); }
    
    /// Puts the executer in "no exec" mode, 
    /// which creates but does not execute pipelines.
    void SetNoExecMode(bool b) { mInterpreter->SetNoExecMode(b); }

	void SetDialogMode(Interpreter::DialogModeType t) 
    { mInterpreter->SetDialogMode(t); }
    
    /// Runs the interpretation of a file
    /// Returns false on error
    bool InterpretFile( const std::string& filename);


    void OnMenuQuit(wxCommandEvent& event);
    void OnMenuAbout(wxCommandEvent& event);
    void OnMenuEditConfig(wxCommandEvent& WXUNUSED(event));
    void OnMenuCreatePackage(wxCommandEvent& WXUNUSED(event));
    void OnMenuCreateBlackBox(wxCommandEvent& WXUNUSED(event));
    void OnMenuShowImageGraph(wxCommandEvent& WXUNUSED(event));
    void OnMenuShowHTMLDoc(wxCommandEvent& WXUNUSED(event));
    void OnMenuCreateIndex(wxCommandEvent& WXUNUSED(event));
   

    void OnButtonRun(wxCommandEvent& WXUNUSED(event));

    // Interpreter callbacks
    bool InterpreterUserHasOwnHtmlPageViewer() { return true; }
    void InterpreterUserViewHtmlPage(const std::string&);

    // WxGUICommand callbacks
    void WxGUICommandEnter(const std::string&);


    // Overloaded Show method to handle bbtk::Wx::TopWindow auto-destruction
    virtual bool Show(bool show = true);

    void OnClose(wxCloseEvent& event);


  private:
    wxAuiManager m_mgr;
    Interpreter::Pointer mInterpreter;

    
//EED    wxNotebook* mwxNotebook;
    wxAuiNotebook* mwxNotebook;
    wxPanel *mwxPageCommand, *mwxPageHelp;

    WxGUICommand* mWxGUICommand;
    WxGUIOutputMessages* mWxGUIOutputMessages;
    WxGUIHtmlBrowser* mWxGUIHtmlBrowser;
    
    wxButton* mwxButtonRun;

  public:
    
    // Callback invoked by bbtk top window when something changes
    void OnWxSignal();
    DECLARE_EVENT_TABLE()
	
  };

  
} // namespace bbtk


#endif // __bbtkWxGUIConsole_h__

#endif //_USE_WXWIDGETS_
