/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIHtmlBrowser.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.15 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */

#ifdef _USE_WXWIDGETS_


#include "bbtkWxGUIHtmlBrowser.h"
//#include "bbtkWxBlackBox.h"
//#include "bbtkWxGUIConsole.h"

#include "bbtkConfigurationFile.h"
#include "bbtkUtilities.h"

namespace bbtk
{  

  //========================================================================
  enum 
    {
      bwd_id,
      fwd_id,
      home_id,
      reload_id,
      include_id,
      url_id  ,
      html_id = 10100
    };


/*
  //========================================================================
  void WxHtmlWindow::OnLinkClicked(const wxHtmlLinkInfo& e)
  {
        std::cout  << "WxHtmlWindow::OnLink"<<std::endl;
    //    std::cout  << e.GetHref()<<std::endl;
    mBrowser->OnLinkClicked2(e);
  }
*/

//EED2  BEGIN_EVENT_TABLE(WxHtmlWindow, wxPanel)
//EED2    EVT_SIZE(WxHtmlWindow::OnSize)
//EED2  END_EVENT_TABLE()

//EED2  void WxHtmlWindow::OnSize( wxSizeEvent& )
//EED2  {
//EED2		printf("EED WxHtmlWindow::OnSize  \n" );
//EED2		Scroll(10,500);
//EED2  }


  //========================================================================
  
  BEGIN_EVENT_TABLE(WxGUIHtmlBrowser, wxPanel)
    EVT_BUTTON(bwd_id, WxGUIHtmlBrowser::OnBackButton )
    EVT_BUTTON(fwd_id, WxGUIHtmlBrowser::OnForwardButton )
    EVT_BUTTON(home_id, WxGUIHtmlBrowser::OnHomeButton )
    EVT_BUTTON(reload_id, WxGUIHtmlBrowser::OnReloadButton )
  //    EVT_BUTTON(include_id, WxGUIHtmlBrowser::OnIncludeFileButton )
    EVT_TEXT_ENTER(url_id, WxGUIHtmlBrowser::OnURLEnter )
   EVT_HTML_LINK_CLICKED(html_id, WxGUIHtmlBrowser::OnLinkClicked)
    EVT_SIZE(WxGUIHtmlBrowser::OnSize)

  END_EVENT_TABLE()
  //========================================================================


  //========================================================================
    WxGUIHtmlBrowser::WxGUIHtmlBrowser ( wxWindow *parent, wxSize size,
					 WxGUIHtmlBrowserUser* user)
      : 
      wxPanel ( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL),
      mUser(user)

  {
    wxPanel* panel = this;

    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    
    
    wxBoxSizer *bsizer = new wxBoxSizer(wxHORIZONTAL);
    
    mwxBackButton = new wxButton( panel, bwd_id,_T("<"),wxDefaultPosition,
				  wxDefaultSize,wxBU_EXACTFIT);
    bsizer->Add ( mwxBackButton , 0, wxALIGN_CENTRE );
    
    mwxForwardButton = new wxButton( panel, fwd_id,_T(">"),wxDefaultPosition,
				     wxDefaultSize,wxBU_EXACTFIT);
    bsizer->Add ( mwxForwardButton  , 0, wxALIGN_CENTRE );
    
    mwxHomeButton = new wxButton( panel, home_id,_T("Home"),wxDefaultPosition,
				  wxDefaultSize,wxBU_EXACTFIT);
    bsizer->Add ( mwxHomeButton , 0, wxALIGN_CENTRE );
    
    mwxReloadButton = new wxButton( panel, reload_id,_T("Reload"),wxDefaultPosition,
				    wxDefaultSize,wxBU_EXACTFIT);
    bsizer->Add ( mwxReloadButton  , 0, wxALIGN_CENTRE );
    
    /*
    mwxIncludeFileButton = new wxButton( panel, include_id,
				       _T("RUN"),wxDefaultPosition,
				       wxDefaultSize,wxBU_EXACTFIT);
    bsizer->Add ( mwxIncludeFileButton , 0, wxALIGN_CENTRE |  wxLEFT | wxTOP | wxBOTTOM , 10 );
    */

    mwxURL = new wxTextCtrl(panel,url_id,_T(""),
			    wxDefaultPosition,
			    wxDefaultSize,
			    wxTE_PROCESS_ENTER);
    mwxURL->SetLabel(_T("URL"));
    bsizer->Add(mwxURL, 1, wxEXPAND);


//    mwxHtmlWindow = new WxHtmlWindow(this,html_id,this,size);

	  mwxHtmlWindow = new wxHtmlWindow(this,html_id,
									 wxDefaultPosition, 
									 size,
									 wxHW_SCROLLBAR_AUTO, 
									 _T("bbtk::WxGUIHtmlBrowser"));

    /*

-1, 
				     wxDefaultPosition, 
				     size,
				     wxHW_SCROLLBAR_AUTO, 
				     "bbtk::WxGUIHtmlBrowser");
    */
    mwxHtmlWindow->SetBorders(5);
    //  mwxHtmlWindow->FitInside();

	sizer->Add ( bsizer , 0, wxEXPAND );
	  
// EED: This have a problem in macOS
//    wxStaticBoxSizer* hw = 
//	    new wxStaticBoxSizer( 
//							   new wxStaticBox( this, -1, _T(""),  wxDefaultPosition,  size ), 
//							  wxVERTICAL 
//	                         );
//	  hw->Add ( mwxHtmlWindow, 1, wxEXPAND  );	  
//EED    sizer->Add ( hw, 1, wxGROW ); // | wxLEFT | wxRIGHT | wxBOTTOM, 10 );
	  
    sizer->Add ( mwxHtmlWindow, 1, wxGROW ); // | wxLEFT | wxRIGHT | wxBOTTOM, 10 );

    panel	-> SetSizer(sizer);

    panel	-> SetAutoLayout(true);
    panel	-> Layout();

//    GoHome();

   }
  //========================================================================
 

  //========================================================================
  bool WxGUIHtmlBrowser::GoTo(std::string& file)
  { 
    bool r = mwxHtmlWindow->LoadPage(std2wx(file));
    UpdateURL();
    return r;
  }
  //========================================================================
  
  //========================================================================
  void WxGUIHtmlBrowser::OnBackButton(wxCommandEvent& )
  {
    mwxHtmlWindow->HistoryBack();
    UpdateURL();
  }
  //========================================================================

  //========================================================================
  void WxGUIHtmlBrowser::OnForwardButton(wxCommandEvent& )
  {
    mwxHtmlWindow->HistoryForward();
    UpdateURL();
  }
  //========================================================================

  //========================================================================
  void WxGUIHtmlBrowser::GoHome()
  {
    std::string url = ConfigurationFile::GetInstance().Get_doc_path();
    url += "/help_contents.html";
    GoTo(url);
  }
  //========================================================================

  //========================================================================
  void WxGUIHtmlBrowser::OnHomeButton(wxCommandEvent& )
  {
    GoHome();
  }
  //========================================================================

  //========================================================================
  void WxGUIHtmlBrowser::OnReloadButton(wxCommandEvent& e)
  {
    OnURLEnter(e);
  }
  //========================================================================
  //========================================================================
  std::string WxGUIHtmlBrowser::GetCurrentPage()
  {
    return wx2std(mwxURL->GetValue());
  }
  //========================================================================

  /*
  //========================================================================
  void WxGUIHtmlBrowser::OnIncludeFileButton(wxCommandEvent& )
  {
    std::string filename = wx2std(mwxURL->GetValue());
    size_t s = filename.length();

    WxGUIConsole* C = mWxGUIConsole; //::GetInstance();
    //    MessageManager::SetMessageLevel("All",9);
    Interpreter* I = new Interpreter;
    
    if ((s>3) && (filename[s-1]=='s')
	&& (filename[s-2]=='b')
	&& (filename[s-3]=='b')
	&& (filename[s-4]=='.'))
      {
	std::cout << "stat"<<std::endl;
	if (C!=0) C->SetStatusText(_T("Executing ")+mwxURL->GetValue());
	std::cout << "int"<<std::endl;
	I->InterpretFile(filename);
	std::cout << "eoint"<<std::endl;
      }
    else
      {
	if (C!=0) C->SetStatusText(_T("The current page is not a bbs file : cannot execute it"));
      }
    
    delete I;
   }
  //========================================================================
  */


  //======================================================================== 
  void WxGUIHtmlBrowser::OnURLEnter( wxCommandEvent&)
  { 
    mwxHtmlWindow->LoadPage(mwxURL->GetValue());
  }
  //========================================================================
  
	//========================================================================
	void WxGUIHtmlBrowser::OnLinkClicked2(const wxHtmlLinkInfo& info)
	{
	  //		std::cout << "OLK2"<<std::endl;
		bool go = true;
		if (mUser) 
		{
			wxString file = info.GetHref();
			go = mUser->WxGUIHtmlBrowserUserOnLinkClicked( wx2std( file ) );
		}
		if (go) 
		{
			mwxHtmlWindow->LoadPage( info.GetHref() );
			UpdateURL();
		}
		
		
	}
		
  //========================================================================
  void WxGUIHtmlBrowser::OnLinkClicked(wxHtmlLinkEvent& e)
  { 
    //	  std::cout << "OLK"<<std::endl;
    bool go = true;
    if (mUser) 
      {
		  /*
	wxString file = wxPathOnly(mwxURL->GetValue());
	file += std2wx(ConfigurationFile::GetInstance().Get_file_separator());
	file += e.GetLinkInfo().GetHref();
	*/
		wxString file = e.GetLinkInfo().GetHref();
		go = mUser->WxGUIHtmlBrowserUserOnLinkClicked( wx2std( file ) );
      }
    if (go) 
      {
	mwxHtmlWindow->LoadPage( e.GetLinkInfo().GetHref() );
	UpdateURL();
	//	OnURLEnter(e);
	//	mwxHtmlWindow->LoadPage(mwxURL->GetValue());
     }

    //    mwxHtmlWindow->LoadPage( mwxURL->GetValue() );
   }
  //========================================================================


  //========================================================================
  void WxGUIHtmlBrowser::OnSize(wxSizeEvent& e)
  { 
	  mwxHtmlWindow->EnableScrolling(true,true);
	  if   (  mwxURL->GetValue()!=wxString(_T(""))  )
	  {
// ??????????   No funciona ....?????
//EED2		mwxHtmlWindow->LoadPage(mwxURL->GetValue());
//		printf("EED WxGUIHtmlBrowser::OnSize %s \n", mwxURL->GetValue().c_str() );
//EED2		mwxHtmlWindow->Scroll( 10,  500);
	  } else {
//		GoHome();
	  }
	  e.Skip(true);
  }

  /*
  void WxGUIHtmlBrowser::OnCell(wxHtmlCellEvent& )
  {
    std::cout  << "OnCell"<<std::endl;
  }
  */

  //========================================================================
  void WxGUIHtmlBrowser::UpdateURL()
  {
    wxString s = mwxHtmlWindow->GetOpenedPage();
    if (!mwxHtmlWindow->GetOpenedAnchor().IsEmpty())
    {
	    s += _T("#") + mwxHtmlWindow->GetOpenedAnchor();
    }
    mwxURL->Clear();
    mwxURL->AppendText(s);
  }
  //========================================================================

  //========================================================================
  void WxGUIHtmlBrowser::SetSize( wxSize s)
  {
    //    wxPanel::SetSize(s);
    mwxHtmlWindow->SetSize(s);
    Fit();
  }
  //========================================================================
}

#endif
