/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIHtmlBrowser.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.8 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */

#ifdef _USE_WXWIDGETS_


#ifndef __bbtkWxGUIHtmlBrowser_h_INCLUDED__
#define __bbtkWxGUIHtmlBrowser_h_INCLUDED__

#include "bbtkWx.h"
#include <wx/html/htmlwin.h>

namespace bbtk
{

  class WxGUIHtmlBrowser;


  class WxHtmlWindow : public virtual wxHtmlWindow
  {
  public:
    WxHtmlWindow( wxWindow *parent, int id, WxGUIHtmlBrowser* browser, wxSize size) 
      : wxHtmlWindow(parent, id, 
		     wxDefaultPosition, 
		     size,
		     wxHW_SCROLLBAR_AUTO, 
    		  _T("bbtk::WxGUIHtmlBrowser")),
	      mBrowser(browser)
    {
		std::cout << "ctor"<<std::endl;
     SetBorders(30);
    };
    //    wxHtmlOpeningStatus OnOpeningURL(wxHtmlURLType type,const wxString& url, wxString *redirect);
//   virtual void OnLinkClicked(const wxHtmlLinkInfo& link);

//EED2  void OnSize( wxSizeEvent&);


  private: 
    WxGUIHtmlBrowser* mBrowser;

   // any class wishing to process wxWidgets events must use this macro
//EED2    DECLARE_EVENT_TABLE()  

  };

//	typedef wxHtmlWindow WxHtmlWindow;
  
	
#define THE_HTML_WINDOW_CLASS wxHtmlWindow
	
  /// Abstract class which defines the callbacks invoked by WxGUIHtmlBrowser
  class WxGUIHtmlBrowserUser 
  {
  public :
    WxGUIHtmlBrowserUser() {}
    virtual ~WxGUIHtmlBrowserUser() {}
    
    virtual bool WxGUIHtmlBrowserUserOnLinkClicked(const std::string& target) 
    { return true; }
  };
  
 

  // class WxGUIConsole;

  
  class BBTK_EXPORT WxGUIHtmlBrowser : public wxPanel
  {
  public:
    WxGUIHtmlBrowser ( wxWindow *parent, wxSize size, 
    		       WxGUIHtmlBrowserUser* = 0 );
 
    bool GoTo(std::string&);
    void GoHome();

    void OnBackButton(wxCommandEvent& );
    void OnForwardButton(wxCommandEvent& );
    void OnHomeButton(wxCommandEvent& );
    void OnReloadButton(wxCommandEvent& );
    //   void OnRunButton(wxCommandEvent& );
    void OnLinkClicked(wxHtmlLinkEvent& );
	void OnLinkClicked2(const wxHtmlLinkInfo& );
    void OnURLEnter( wxCommandEvent&);
    void OnSize( wxSizeEvent&);

    void UpdateURL();
    //  void OnCell(wxHtmlCellEvent& );

    void SetSize( wxSize );

    std::string GetCurrentPage();

  private:
    THE_HTML_WINDOW_CLASS * mwxHtmlWindow;
    wxTextCtrl* mwxURL;
    wxButton* mwxBackButton;
    wxButton* mwxForwardButton;
    wxButton* mwxHomeButton;
    wxButton* mwxReloadButton;
    //    wxButton* mwxRunButton;
    
    WxGUIHtmlBrowserUser* mUser;
    
   // any class wishing to process wxWidgets events must use this macro
    DECLARE_EVENT_TABLE()  
  };

}
#endif

#endif
