/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIOutputMessages.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.5 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

#include "bbtkWxGUIOutputMessages.h"
#include "bbtkMessageManager.h"
#include "bbtkConfigurationFile.h"
#include "bbtkWxStreamRedirector.h"

namespace bbtk
{


  WxGUIOutputMessages::WxGUIOutputMessages(wxWindow *parent, WxGUIOutputMessagesUser* user)
    : wxPanel(parent,-1),
      mUser(user)
  {
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    mwxOutputText = 
      new wxTextCtrl(this,
                     -1, //ID_OutputText,
                     _T(""),wxDefaultPosition,
                     wxDefaultSize,
                     wxTE_READONLY |
                     wxTE_MULTILINE );
 
    mFixedFont = new wxFont(10,
                                   wxFONTFAMILY_MODERN,
                                   wxFONTSTYLE_NORMAL,
                                   wxFONTWEIGHT_NORMAL,
                                   false);

   mwxOutputTextAttr = new wxTextAttr;
   mwxOutputTextAttr->SetFont(*mFixedFont);
   sizer->Add ( mwxOutputText, 1, wxGROW);
   
   // Redirection of std::cout to mwxTextHistory and printf
    mRedirect_cout = 
      new WxStreamRedirector(std::cout,mwxOutputText,*wxBLACK,true);
    mRedirect_cerr = 
      new WxStreamRedirector(std::cerr,mwxOutputText,*wxGREEN,true); 

    SetSizer(sizer);
    SetAutoLayout(true);
    Layout();
  }

  WxGUIOutputMessages::~WxGUIOutputMessages()
  {
    delete mRedirect_cout;
    delete mRedirect_cerr;
   delete mwxOutputTextAttr;
   delete mFixedFont;
  } 

  void WxGUIOutputMessages::Print(const std::string& message, 
				  const wxColor* col)
  {
    if (col != 0)
      {
	mwxOutputTextAttr->SetTextColour(*col);
	mwxOutputText->SetDefaultStyle(*mwxOutputTextAttr);
      }
    mwxOutputText->AppendText(std2wx(message));
    if (col != 0)
      {
	mwxOutputTextAttr->SetTextColour(*wxBLACK);
	mwxOutputText->SetDefaultStyle(*mwxOutputTextAttr);
      }
  }


}

#endif
