/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIOutputMessages.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.5 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

	
#ifndef __bbtkWxGUIOutputMessages_h__
#define __bbtkWxGUIOutputMessages_h__

#include "bbtkWx.h"
 

namespace bbtk
{
  
   /// Abstract class which defines the callbacks invoked by WxGUIOutputMessages
  class BBTK_EXPORT WxGUIOutputMessagesUser
  {
  public:
    WxGUIOutputMessagesUser() {}
    virtual ~WxGUIOutputMessagesUser() {}
    /// Callback invoked when a command is entered in the WxGUIOutputMessages
    virtual void WxGUIOutputMessagesEnter(const std::string& command) {}
  };
  

  // Forward decl
  class WxStreamRedirector;

  /// GUI Component which provides a command input zone 
  class BBTK_EXPORT WxGUIOutputMessages : public wxPanel
  {
  public:
    WxGUIOutputMessages(wxWindow *parent, WxGUIOutputMessagesUser* user = 0);
    ~WxGUIOutputMessages();
    
    void Print(const std::string& message, const wxColor* col = 0);

  private :
    WxGUIOutputMessagesUser* mUser;
    wxTextCtrl* mwxOutputText;
    wxTextAttr* mwxOutputTextAttr;
	wxFont* mFixedFont;
    WxStreamRedirector* mRedirect_cout;
    WxStreamRedirector* mRedirect_cerr;
    /*
  public:
    enum
      {
	ID_Text_Command,
	ID_Btn_Go,
	ID_Btn_Include,
	ID_Btn_Reset,
	ID_Btn_Config,
	ID_Btn_GraphS,
	ID_Btn_GraphD,
	ID_Btn_Help
      };
    
    DECLARE_EVENT_TABLE()
    */
  };
  
  
} // namespace bbtk


#endif // __bbtkWxGUIOutputMessages_h__

#endif //_USE_WXWIDGETS_
