/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIPackageBrowser.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.8 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */

/*
#ifdef _USE_WXWIDGETS_

#define CHECKBOXVIEW 1

#include "bbtkWxGUIPackageBrowser.h"
#include "ThirdParty/wx/treemultictrl/wxTreeMultiCtrl.h"
#include "bbtkInterpreter.h"
#include "bbtkBlackBoxInputDescriptor.h"
#include "bbtkBlackBoxOutputDescriptor.h"
#include "bbtkWxBlackBox.h"
#include "wx/grid.h"
#include <wx/statline.h>


namespace bbtk
{
  //================================================================
  WxGUIPackageBrowserBlackBox::
  WxGUIPackageBrowserBlackBox(wxWindow* parent,
			      WxGUIPackageBrowser* browser,
			      BlackBoxDescriptor::Pointer descr) :
    wxPanel(parent, -1),
    mBrowser(browser),
    mDescriptor(descr)
  {
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    
    wxStaticText* s = new wxStaticText(this,-1,
				       std2wx(descr->GetDescription()));
    sizer->Add(s,0,wxGROW);
    s = new wxStaticText(this,-1,
			 std2wx(descr->GetAuthor()));
    sizer->Add(s,0,wxGROW);
    s = new wxStaticText(this,-1,
			 std2wx(descr->GetCategory()));
    sizer->Add(s,0,wxGROW);

    std::vector<std::vector<std::string> > user_defined;
    std::vector<std::vector<std::string> > ubb_defined;
    std::vector<std::vector<std::string> > wxbb_defined;
    
    std::string titlecol("#BBBBFF");
    std::string usercol("#FFFFFF");
    std::string ubbcol("#DDFFFF");
    std::string wxbbcol("#EEFFFF");

   const BlackBoxDescriptor::InputDescriptorMapType& imap = 
      descr->GetInputDescriptorMap();
    BlackBoxDescriptor::InputDescriptorMapType::const_iterator in;
    for ( in = imap.begin();  in != imap.end(); ++in ) 
    {
      // Skips system-defined inputs
      std::string col(usercol);
      int iotype = 0;
      if (in->second->GetCreatorTypeInfo() == 
	  typeid(AtomicBlackBoxDescriptor))
	{
	  col = ubbcol; 
	  iotype = 1;
	}
      else if (in->second->GetCreatorTypeInfo() == 
	       typeid(WxBlackBoxDescriptor))
	{
	  col = wxbbcol; 
	  iotype = 2;
	}

      std::string name(in->second->GetName());
      //Utilities::html_format(name);
      
      std::string type("<");
      type += in->second->GetTypeName();    
      type += ">";
      //Utilities::html_format(type);
      
      std::string descr(in->second->GetDescription());
      //Utilities::html_format(descr);
      
      std::vector<std::string> out;
      out.push_back(name);
      out.push_back(type);
      out.push_back(descr);

      if (iotype==0) user_defined.push_back(out);
      else if (iotype==1) ubb_defined.push_back(out);
      else if (iotype==2) wxbb_defined.push_back(out);
      
    }

 
    wxBoxSizer *inputs = 
      new wxStaticBoxSizer
      ( new wxStaticBox(this, wxID_ANY, _T("Inputs")), wxVERTICAL );    
    wxFlexGridSizer* grid = new wxFlexGridSizer(3);

    wxTextAttr ionameattr(*wxRED,*wxBLACK);
    wxTextAttr iotypeattr(*wxBLACK,*wxRED);

    int n = 0;
    std::vector<std::vector<std::string> >::iterator hi;
    for (hi=user_defined.begin();hi!=user_defined.end();++hi) 
      {
	
	grid->Add( new wxStaticText(this,-1,std2wx((*hi)[0])));
	grid->Add( new wxStaticText(this,-1,std2wx((*hi)[1])));
	grid->Add( new wxStaticText(this,-1,std2wx((*hi)[2])));
	//	grid->SetCellValue( n, 0, std2wx((*hi)[0]) );
	//	grid->SetReadOnly( n, 0 );
     }
    // grid->Add( new wxStaticLine(this,-1));
   for (hi=wxbb_defined.begin();hi!=wxbb_defined.end();++hi) 
      {
	grid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[0])));
	grid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[1])));
	grid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[2])));
      }
    for (hi=ubb_defined.begin();hi!=ubb_defined.end();++hi) 
      {
	grid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[0])));
	grid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[1])));
	grid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[2])));
      }

    inputs->Add(grid,0,wxGROW);
    sizer->Add(inputs,0,wxGROW);

    // Outputs
    user_defined.clear();
    ubb_defined.clear();
    wxbb_defined.clear();
    const BlackBoxDescriptor::OutputDescriptorMapType& omap = 
      descr->GetOutputDescriptorMap();
    BlackBoxDescriptor::OutputDescriptorMapType::const_iterator out;
    for ( out = omap.begin();  out != omap.end(); ++out ) 
    {
      // Skips system-defined inputs
      std::string col(usercol);
      int iotype = 0;
      if (out->second->GetCreatorTypeInfo() == 
	  typeid(AtomicBlackBoxDescriptor))
	{
	  col = ubbcol; 
	  iotype = 1;
	}
      else if (out->second->GetCreatorTypeInfo() == 
	       typeid(WxBlackBoxDescriptor))
	{
	  col = wxbbcol; 
	  iotype = 2;
	}

      std::string name(out->second->GetName());
      //Utilities::html_format(name);
      
      std::string type("<");
      type += out->second->GetTypeName();    
      type += ">";
      //Utilities::html_format(type);
      
      std::string descr(out->second->GetDescription());
      //Utilities::html_format(descr);
      
      std::vector<std::string> out;
      out.push_back(name);
      out.push_back(type);
      out.push_back(descr);

      if (iotype==0) user_defined.push_back(out);
      else if (iotype==1) ubb_defined.push_back(out);
      else if (iotype==2) wxbb_defined.push_back(out);
      
    }

    wxBoxSizer *outputs = 
      new wxStaticBoxSizer
      ( new wxStaticBox(this, wxID_ANY, _T("Outputs")), wxVERTICAL );    
    wxFlexGridSizer* ogrid = new wxFlexGridSizer(3);


    n = 0;
    for (hi=user_defined.begin();hi!=user_defined.end();++hi) 
      {
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[0])));
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[1])));
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[2])));
	//	grid->SetCellValue( n, 0, std2wx((*hi)[0]) );
	//	grid->SetReadOnly( n, 0 );
     }
    for (hi=wxbb_defined.begin();hi!=wxbb_defined.end();++hi) 
      {
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[0])));
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[1])));
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[2])));
      }
    for (hi=ubb_defined.begin();hi!=ubb_defined.end();++hi) 
      {
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[0])));
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[1])));
	ogrid->Add( new wxStaticText(this,-1,
				    std2wx((*hi)[2])));
      }

    outputs->Add(ogrid,0,wxGROW);
    sizer->Add(outputs,0,wxGROW);

  
    SetSizer(sizer);
    SetAutoLayout(true);
    Layout();
  }
  //================================================================


  //================================================================
  WxGUIPackageBrowserBlackBox::~WxGUIPackageBrowserBlackBox()
  {
  }
  //================================================================


  //================================================================
  WxGUIPackageBrowser::WxGUIPackageBrowser( wxWindow *parent,
				    WxGUIPackageBrowserUser* user )
    : wxPanel(parent, -1),
      mUser(user),
      mInterpreter()
  {

    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    mTree = new wxTreeMultiCtrl(this, -1);
    
    mTree->SetBackgroundColour(*wxWHITE);
    sizer->Add(mTree,1,wxGROW);

#ifndef LINUX
    wxTreeMultiWindowInfo wndinfo(wxTMC_BG_ADJUST_CNT, 8, 0);
#else
    wxTreeMultiWindowInfo wndinfo(wxTMC_BG_ADJUST_ALL, 8, 0);
#endif
    
    // make it a bit bigger
    wxFont somefont;
    somefont = mTree->GetCaptionFont();
    somefont.SetFamily(wxMODERN);
    somefont.SetWeight(wxBOLD);
    somefont.SetPointSize(somefont.GetPointSize()+1);
    mTree->SetCaptionFont(somefont);

    mTree->SetSpacingY(1);
    // mTree->SetCheckboxView(true);

    SetSizer(sizer);
    SetAutoLayout(true);
    Layout();
    
  }
  //================================================================

  //================================================================
  WxGUIPackageBrowser::~WxGUIPackageBrowser()
  {
    // std::cout << "del interpreter" << std::endl;
    //   if (mInterpreter) delete mInterpreter;
    //    std::cout << "ok" << std::endl;
  }
  //================================================================

  //================================================================
  void WxGUIPackageBrowser::IncludeAll()
  {
    if (!mInterpreter) mInterpreter = bbtk::Interpreter::New();
    mInterpreter->SetCommandLine(true);
    mInterpreter->InterpretLine("include *");

    Factory::Pointer F = mInterpreter->GetExecuter()->GetFactory();
    BuildFromFactory(F);
  }
  //================================================================
  //================================================================
  
  void WxGUIPackageBrowser::BuildFromFactory(Factory::Pointer F)
  {
#ifndef LINUX
    wxTreeMultiWindowInfo wndinfo(wxTMC_BG_ADJUST_CNT, 8, 0);
#else
    wxTreeMultiWindowInfo wndinfo(wxTMC_BG_ADJUST_ALL, 8, 0);
#endif
    mTree->DeleteAllItems();    
    const Factory::PackageMapType& M = F->GetPackageMap();
    Factory::PackageMapType::const_iterator i;
    for (i=M.begin();i!=M.end();++i)
      {
	Package::Pointer P = i->second;
	wxString packname = std2wx(P->GetName());
	if (packname==_T("user")) continue;
	wxTreeMultiItem pack = mTree->AddRoot(packname,packname);

	wxString packinfo = std2wx(P->GetDescription());
	packinfo += _T(" - by ")+ std2wx(P->GetAuthor());
	packinfo += _T(" - v. ")+ std2wx(P->GetVersion());
	mTree->AppendWindow(pack, 
			    new wxStaticText(mTree,
					     -1,packinfo));
	Package::BlackBoxMapType::iterator j;
	for (j=P->GetBlackBoxMap().begin();
	     j!=P->GetBlackBoxMap().end();
	     ++j)
	  {
	    wxString boxname = std2wx(j->second->GetTypeName());
	    wxTreeMultiItem box = mTree->AppendNode(pack,boxname,boxname);
	    WxGUIPackageBrowserBlackBox* boxdescr 
	      = new WxGUIPackageBrowserBlackBox(mTree,this,j->second);
	    mTree->AppendWindow(box, boxdescr, _T(""), 
				wndinfo, wxTMC_SPAN_WIDTH);

	  }
      }
    mTree->CollapseNodes(true);

    // Test exclude 
    wxTreeMultiItem item = mTree->FindItem(_T("Add"));
    if(item.IsOk()) mTree->Exclude(item);
  }
  //================================================================

  //================================================================
  WxGUIPackageBrowserWindow::WxGUIPackageBrowserWindow( wxWindow *parent, 
						    wxString title, 
						    wxSize size)
    : wxFrame((wxFrame *)parent, -1, title, wxDefaultPosition, size)
  {	
    
    
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

    mBrowser = new WxGUIPackageBrowser(this);
    mBrowser->IncludeAll();
    sizer->Add(mBrowser,1,wxGROW);
    
    //    WxGUICommand* com = new WxGUICommand(this,this);
    //    sizer->Add(com);
    
    SetSizer(sizer); 


    // Creates the parent window of all bbtk windows as a child of this
    Wx::CreateTopWindow(this);
    //    bbtkAddWxObserver(WxGUIConsole::OnWxSignal);


    SetAutoLayout(true);
    Layout();
  }
  //================================================================

  //================================================================
  WxGUIPackageBrowserWindow::~WxGUIPackageBrowserWindow()
  {
  }
  //================================================================

} // namespace bbtk


#endif //_USE_WXWIDGETS_
*/
