/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIPackageBrowser2.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.27 $
=========================================================================*/



/* \brief Short description in one line
 *
 * Long description which
 * can span multiple lines
 */

/**
 * \file
 * \brief
 */
/**
 * \class bbtk::
 * \brief
 */


#ifdef _USE_WXWIDGETS_

#define CHECKBOXVIEW 1

#include "bbtkWxGUIPackageBrowser2.h"
//#include "ThirdParty/wx/treemultictrl/wxTreeMultiCtrl.h"
#include "bbtkInterpreter.h"
#include "bbtkBlackBoxInputDescriptor.h"
#include "bbtkBlackBoxOutputDescriptor.h"
#include "bbtkWxBlackBox.h"
//#include "wx/grid.h"
//#include <wx/statline.h>

#include "creaWx.h"

#define LIST_CTRL 1000


namespace bbtk
{

  BEGIN_EVENT_TABLE(WxGUIBlackBoxList, wxListCtrl)
    EVT_LIST_BEGIN_DRAG(LIST_CTRL, WxGUIBlackBoxList::OnBeginDrag)
    EVT_LIST_BEGIN_RDRAG(LIST_CTRL, WxGUIBlackBoxList::OnBeginRDrag)
    EVT_LIST_BEGIN_LABEL_EDIT(LIST_CTRL, WxGUIBlackBoxList::OnBeginLabelEdit)
    EVT_LIST_END_LABEL_EDIT(LIST_CTRL, WxGUIBlackBoxList::OnEndLabelEdit)
    EVT_LIST_DELETE_ITEM(LIST_CTRL, WxGUIBlackBoxList::OnDeleteItem)
    EVT_LIST_DELETE_ALL_ITEMS(LIST_CTRL, WxGUIBlackBoxList::OnDeleteAllItems)
#if WXWIN_COMPATIBILITY_2_4
    EVT_LIST_GET_INFO(LIST_CTRL, WxGUIBlackBoxList::OnGetInfo)
    EVT_LIST_SET_INFO(LIST_CTRL, WxGUIBlackBoxList::OnSetInfo)
#endif
    EVT_LIST_ITEM_SELECTED(LIST_CTRL, WxGUIBlackBoxList::OnSelected)
    EVT_LIST_ITEM_DESELECTED(LIST_CTRL, WxGUIBlackBoxList::OnDeselected)
    EVT_LIST_KEY_DOWN(LIST_CTRL, WxGUIBlackBoxList::OnListKeyDown)
    EVT_LIST_ITEM_ACTIVATED(LIST_CTRL, WxGUIBlackBoxList::OnActivated)
    EVT_LIST_ITEM_FOCUSED(LIST_CTRL, WxGUIBlackBoxList::OnFocused)

    EVT_LIST_COL_CLICK(LIST_CTRL, WxGUIBlackBoxList::OnColClick)
    EVT_LIST_COL_RIGHT_CLICK(LIST_CTRL, WxGUIBlackBoxList::OnColRightClick)
    EVT_LIST_COL_BEGIN_DRAG(LIST_CTRL, WxGUIBlackBoxList::OnColBeginDrag)
    EVT_LIST_COL_DRAGGING(LIST_CTRL, WxGUIBlackBoxList::OnColDragging)
    EVT_LIST_COL_END_DRAG(LIST_CTRL, WxGUIBlackBoxList::OnColEndDrag)

    EVT_LIST_CACHE_HINT(LIST_CTRL, WxGUIBlackBoxList::OnCacheHint)

#if USE_CONTEXT_MENU
    EVT_CONTEXT_MENU(WxGUIBlackBoxList::OnContextMenu)
#endif
    EVT_CHAR(WxGUIBlackBoxList::OnChar)

    EVT_RIGHT_DOWN(WxGUIBlackBoxList::OnRightClick)
    END_EVENT_TABLE()

  int wxCALLBACK MyCompareFunction(long item1, long item2, long WXUNUSED(sortData))
  {
    // inverse the order
    if (item1 < item2)
      return -1;
    if (item1 > item2)
      return 1;

    return 0;
  }

  // WxGUIBlackBoxList
  WxGUIBlackBoxList::WxGUIBlackBoxList(wxWindow *parent,
				 const wxWindowID id,
				 const wxPoint& pos,
				 const wxSize& size,
				 long style)
    : wxListCtrl(parent, id, pos, size, style),
      mUser(0),
      m_attr(*wxBLUE, *wxLIGHT_GREY, wxNullFont)
  {
#ifdef __POCKETPC__
    EnableContextMenu();
#endif
  }

  void WxGUIBlackBoxList::Insert(BlackBoxDescriptor::Pointer d)
  {
    if (GetColumnCount()!=3)
      {
	InsertColumn( 0, _("Package"),
		      wxLIST_FORMAT_LEFT, 90  );
	InsertColumn( 1, _("Box"),
		      wxLIST_FORMAT_LEFT, 150 );
	InsertColumn( 2, _("Description"),
		      wxLIST_FORMAT_LEFT, 500  );
      }

    wxListItem kNewItem;
    kNewItem.SetAlign(wxLIST_FORMAT_LEFT);

    int nID = this->GetItemCount();
    kNewItem.SetId(nID);
    kNewItem.SetMask(wxLIST_MASK_DATA);
    // TO DO : STORE SMART POINTER ?
    kNewItem.SetData(d.get());
    //    BlackBoxDescriptor::Pointer* d2 = (BlackBoxDescriptor::Pointer*)kNewItem.GetData();
    //    std::cout << "Descr = "<<d<<" = "<<d2<<std::endl;
    this->InsertItem(kNewItem);
    this->SetItem(nID, 0, std2wx(d->GetPackage()->GetName()) );
    this->SetItem(nID, 1, std2wx(d->GetTypeName()) );
    this->SetItem(nID, 2, std2wx(d->GetDescription()) );

    /*
      if (nID % 2)
      {
      kNewItem.SetBackgroundColour(wxColour(192,192,192));
      this->SetItem(kNewItem);
      }
    */
  }


  void WxGUIBlackBoxList::OnCacheHint(wxListEvent& event)
  {
    //wxLogMessage( wxT("OnCacheHint: cache items %ld..%ld"),
    //                  event.GetCacheFrom(), event.GetCacheTo() );
  }

  void WxGUIBlackBoxList::SetColumnImage(int col, int image)
  {
    /*
      wxListItem item;
      item.SetMask(wxLIST_MASK_IMAGE);
      item.SetImage(image);
      SetColumn(col, item);
    */
  }

  void WxGUIBlackBoxList::OnColClick(wxListEvent& event)
  {
    int col = event.GetColumn();

    // set or unset image
    static bool x = false;
    x = !x;
    SetColumnImage(col, x ? 0 : -1);

    //    wxLogMessage( wxT("OnColumnClick at %d."), col );
  }

  void WxGUIBlackBoxList::OnColRightClick(wxListEvent& event)
  {
    int col = event.GetColumn();
    if ( col != -1 )
      {
        SetColumnImage(col, -1);
      }

    // Show popupmenu at position
    wxMenu menu(wxT("Test"));
    menu.Append(-1, _T("&About"));
    PopupMenu(&menu, event.GetPoint());

    //wxLogMessage( wxT("OnColumnRightClick at %d."), event.GetColumn() );
  }

  void WxGUIBlackBoxList::LogColEvent(const wxListEvent& event, const wxChar *name)
  {
    //    const int col = event.GetColumn();

    /*
      wxLogMessage(wxT("%s: column %d (width = %d or %d)."),
      name,
      col,
      event.GetItem().GetWidth(),
      GetColumnWidth(col));
    */
  }

  void WxGUIBlackBoxList::OnColBeginDrag(wxListEvent& event)
  {
    LogColEvent( event, wxT("OnColBeginDrag") );
    /*
      if ( event.GetColumn() == 0 )
      {
      //wxLogMessage(_T("Resizing this column shouldn't work."));

      event.Veto();
      }
    */
  }

  void WxGUIBlackBoxList::OnColDragging(wxListEvent& event)
  {
    LogColEvent( event, wxT("OnColDragging") );
  }

  void WxGUIBlackBoxList::OnColEndDrag(wxListEvent& event)
  {
    LogColEvent( event, wxT("OnColEndDrag") );
  }

  void WxGUIBlackBoxList::OnBeginDrag(wxListEvent& event)
  {
	  std::cout<<"RaC DRAG TABLE"<<std::endl;

	  wxString text(this->GetItemText(event.GetIndex()));
	  wxListItem info;
	  info.m_itemId = event.m_itemIndex;
	  info.m_col = 0;
	  info.m_mask = wxLIST_MASK_DATA;
	  wxString sendtext(_T(""));
	  if ( GetItem(info) )
	  {
		  // TO DO : STORE SMART PTR ?
		  BlackBoxDescriptor* d = (BlackBoxDescriptor*)(info.GetData());
		  if (d!=0)
		  {
		      //DFGO -> To identify it is a box
		      sendtext += crea::std2wx("box:");
		      sendtext += crea::std2wx(d->GetFullTypeName());
		  }
	  }
	  else
	  {
		  wxFAIL_MSG(wxT("wxListCtrl::GetItem() failed"));
	  }

	  wxTextDataObject tdo(sendtext);
	  wxDropSource tds(tdo, this);
	  tds.DoDragDrop();

    //    const wxPoint& pt = event.m_pointDrag;

    //wxLogMessage( wxT("OnBeginDrag at (%d, %d), item %ld."),
    //          pt.x, pt.y, HitTest(pt, flags) );
  }

  void WxGUIBlackBoxList::OnBeginRDrag(wxListEvent& event)
  {
    //wxLogMessage( wxT("OnBeginRDrag at %d,%d."),
    //        event.m_pointDrag.x, event.m_pointDrag.y );
  }

  void WxGUIBlackBoxList::OnBeginLabelEdit(wxListEvent& event)
  {
    //wxLogMessage( wxT("OnBeginLabelEdit: %s"), event.m_item.m_text.c_str());
  }

  void WxGUIBlackBoxList::OnEndLabelEdit(wxListEvent& event)
  {
    //wxLogMessage( wxT("OnEndLabelEdit: %s"),
    //        event.IsEditCancelled() ? _T("[cancelled]")
    //                                      : event.m_item.m_text.c_str());
  }

  void WxGUIBlackBoxList::OnDeleteItem(wxListEvent& event)
  {
    LogEvent(event, _T("OnDeleteItem"));
    std::cout << "cannot del"<<std::endl;
    event.Veto();
    //wxLogMessage( wxT("Number of items when delete event is sent: %d"), GetItemCount() );
  }

  void WxGUIBlackBoxList::OnDeleteAllItems(wxListEvent& event)
  {
    LogEvent(event, _T("OnDeleteAllItems"));
    event.Veto();
  }

#if WXWIN_COMPATIBILITY_2_4
  void WxGUIBlackBoxList::OnGetInfo(wxListEvent& event)
  {
    wxString msg;

    msg << _T("OnGetInfo (") << event.m_item.m_itemId << _T(", ") << event.m_item.m_col << _T(")");
    if ( event.m_item.m_mask & wxLIST_MASK_STATE )
      msg << _T(" wxLIST_MASK_STATE");
    if ( event.m_item.m_mask & wxLIST_MASK_TEXT )
      msg << _T(" wxLIST_MASK_TEXT");
    if ( event.m_item.m_mask & wxLIST_MASK_IMAGE )
      msg << _T(" wxLIST_MASK_IMAGE");
    if ( event.m_item.m_mask & wxLIST_MASK_DATA )
      msg << _T(" wxLIST_MASK_DATA");
    if ( event.m_item.m_mask & wxLIST_SET_ITEM )
      msg << _T(" wxLIST_SET_ITEM");
    if ( event.m_item.m_mask & wxLIST_MASK_WIDTH )
      msg << _T(" wxLIST_MASK_WIDTH");
    if ( event.m_item.m_mask & wxLIST_MASK_FORMAT )
      msg << _T(" wxLIST_MASK_WIDTH");

    if ( event.m_item.m_mask & wxLIST_MASK_TEXT )
      {
        event.m_item.m_text = _T("My callback text");
      }

    //wxLogMessage(msg);
  }

  void WxGUIBlackBoxList::OnSetInfo(wxListEvent& event)
  {
    LogEvent(event, _T("OnSetInfo"));
  }
#endif

  void WxGUIBlackBoxList::OnSelected(wxListEvent& event)
  {
    if (mUser==0) return;

    wxListItem info;
    info.m_itemId = event.m_itemIndex;
    info.m_col = 0;
    info.m_mask = wxLIST_MASK_DATA;
    if ( GetItem(info) )
      {
	// TO DO : STORE SMART PTR ?
	BlackBoxDescriptor* d = (BlackBoxDescriptor*)(info.GetData());
	if (d!=0) mUser->WxGUIBlackBoxListUserOnSelected(d);
      }
    else
      {
	wxFAIL_MSG(wxT("wxListCtrl::GetItem() failed"));
      }
  }

  void WxGUIBlackBoxList::OnDeselected(wxListEvent& event)
  {
    LogEvent(event, _T("OnDeselected"));
  }

  void WxGUIBlackBoxList::OnActivated(wxListEvent& event)
  {
    LogEvent(event, _T("OnActivated"));
  }

  void WxGUIBlackBoxList::OnFocused(wxListEvent& event)
  {
    LogEvent(event, _T("OnFocused"));

    event.Skip();
  }

  void WxGUIBlackBoxList::OnListKeyDown(wxListEvent& event)
  {
    long item;

    switch ( event.GetKeyCode() )
      {
      case 'c': // colorize
      case 'C':
	{
	  wxListItem info;
	  info.m_itemId = event.GetIndex();
	  if ( info.m_itemId == -1 )
	    {
	      // no item
	      break;
	    }

	  GetItem(info);

	  wxListItemAttr *attr = info.GetAttributes();
	  if ( !attr || !attr->HasTextColour() )
	    {
	      info.SetTextColour(*wxCYAN);

	      SetItem(info);

	      RefreshItem(info.m_itemId);
	    }
	}
	break;

      case 'n': // next
      case 'N':
	item = GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_FOCUSED);
	if ( item++ == GetItemCount() - 1 )
	  {
	    item = 0;
	  }

	//wxLogMessage(_T("Focusing item %ld"), item);

	SetItemState(item, wxLIST_STATE_FOCUSED, wxLIST_STATE_FOCUSED);
	EnsureVisible(item);
	break;

      case 'r': // show bounding Rect
      case 'R':
	{
	  item = event.GetIndex();
	  wxRect r;
	  if ( !GetItemRect(item, r) )
	    {
	      //wxLogError(_T("Failed to retrieve rect of item %ld"), item);
	      break;
	    }

	  //wxLogMessage(_T("Bounding rect of item %ld is (%d, %d)-(%d, %d)"),
	  //   item, r.x, r.y, r.x + r.width, r.y + r.height);
	}
	break;

      case WXK_DELETE:
	item = GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	/*
	  while ( item != -1 )
	  {
	  DeleteItem(item);

	  //wxLogMessage(_T("Item %ld deleted"), item);

	  // -1 because the indices were shifted by DeleteItem()
	  item = GetNextItem(item - 1,
	  wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	  }
	*/
	break;

      case WXK_INSERT:
	if ( GetWindowStyle() & wxLC_REPORT )
	  {
	    if ( GetWindowStyle() & wxLC_VIRTUAL )
	      {
		SetItemCount(GetItemCount() + 1);
	      }
	    else // !virtual
	      {
		//InsertItemInReportView(event.GetIndex());
	      }
	  }
	//else: fall through

      default:
	LogEvent(event, _T("OnListKeyDown"));

	event.Skip();
      }
  }

  void WxGUIBlackBoxList::OnChar(wxKeyEvent& event)
  {
    //wxLogMessage(_T("Got char event."));

    switch ( event.GetKeyCode() )
      {
      case 'n':
      case 'N':
      case 'c':
      case 'C':
	// these are the keys we process ourselves
	break;

      default:
	event.Skip();
      }
  }

  void WxGUIBlackBoxList::OnRightClick(wxMouseEvent& event)
  {
    if ( !event.ControlDown() )
      {
        event.Skip();
        return;
      }

    int flags;
    long subitem;
    //    long item =
    HitTest(event.GetPosition(), flags, &subitem);

    wxString where;
    switch ( flags )
      {
      case wxLIST_HITTEST_ABOVE:       where = _T("above");           break;
      case wxLIST_HITTEST_BELOW:       where = _T("below");           break;
      case wxLIST_HITTEST_NOWHERE:     where = _T("nowhere near");    break;
      case wxLIST_HITTEST_ONITEMICON:  where = _T("on icon of");      break;
      case wxLIST_HITTEST_ONITEMLABEL: where = _T("on label of");     break;
      case wxLIST_HITTEST_ONITEMRIGHT: where = _T("right on");        break;
      case wxLIST_HITTEST_TOLEFT:      where = _T("to the left of");  break;
      case wxLIST_HITTEST_TORIGHT:     where = _T("to the right of"); break;
      default: where = _T("not clear exactly where on");              break;
      }

    //wxLogMessage(_T("Right double click %s item %ld, subitem %ld"),
    //             where.c_str(), item, subitem);
  }

  void WxGUIBlackBoxList::LogEvent(const wxListEvent& event, const wxChar *eventName)
  {
    //wxLogMessage(_T("Item %ld: %s (item text = %s, data = %ld)"),
    //            event.GetIndex(), eventName,
    //              event.GetText().c_str(), event.GetData());
  }

  wxString WxGUIBlackBoxList::OnGetItemText(long item, long column) const
  {
    /*
      if ( GetItemCount() == WXSIZEOF(SMALL_VIRTUAL_VIEW_ITEMS) )
      {
      return SMALL_VIRTUAL_VIEW_ITEMS[item][column];
      }
      else
      {
    */
    return wxString::Format(_T("Column %ld of item %ld"), column, item);
    //  }
  }

  int WxGUIBlackBoxList::OnGetItemColumnImage(long item, long column) const
  {
    if (!column)
      return 0;

    if (!(item %3) && column == 1)
      return 0;

    return -1;
  }

  wxListItemAttr *WxGUIBlackBoxList::OnGetItemAttr(long item) const
  {
    return item % 2 ? NULL : (wxListItemAttr *)&m_attr;
  }


#if USE_CONTEXT_MENU
  void WxGUIBlackBoxList::OnContextMenu(wxContextMenuEvent& event)
  {
    wxPoint point = event.GetPosition();
    // If from keyboard
    if (point.x == -1 && point.y == -1) {
      wxSize size = GetSize();
      point.x = size.x / 2;
      point.y = size.y / 2;
    } else {
      point = ScreenToClient(point);
    }
    ShowContextMenu(point);
  }
#endif

  void WxGUIBlackBoxList::ShowContextMenu(const wxPoint& pos)
  {
    wxMenu menu;

    menu.Append(wxID_ABOUT, _T("&About"));
    menu.AppendSeparator();
    menu.Append(wxID_EXIT, _T("E&xit"));

    PopupMenu(&menu, pos.x, pos.y);
  }
  //================================================================



  //================================================================
  WxGUIBlackBoxInfo::WxGUIBlackBoxInfo(wxWindow* parent)
    :
    wxPanel(parent, -1),
    mDescriptor()
  {
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

    //    mName = new wxStaticText(this,-1,_T(""));
    //    sizer->Add(mName,0,wxGROW);
    mDescription = new wxStaticText(this,-1,_T(""));
    sizer->Add(mDescription,0,wxGROW);
    mAuthor = new wxStaticText(this,-1,_T(""));
    sizer->Add(mAuthor,0,wxGROW);
    mCategory = new wxStaticText(this,-1,_T(""));
    sizer->Add(mCategory,0,wxGROW);

    wxBoxSizer *inputs =
      new wxStaticBoxSizer
      ( new wxStaticBox(this, wxID_ANY, _T("Inputs")), wxVERTICAL );
    mInputList = new wxListCtrl(this, -1,
				wxDefaultPosition,
				wxDefaultSize,
				wxLC_REPORT //wxLC_LIST
				| wxSUNKEN_BORDER);

    inputs->Add(mInputList,1,wxGROW);
    sizer->Add(inputs,1,wxGROW);

    wxBoxSizer *outputs =
      new wxStaticBoxSizer
      ( new wxStaticBox(this, wxID_ANY, _T("Outputs")), wxVERTICAL );
    mOutputList = new wxListCtrl(this, -1,
				 wxDefaultPosition,
				 wxDefaultSize,
				 wxLC_REPORT //wxLC_LIST
				 | wxSUNKEN_BORDER);

    outputs->Add(mOutputList,1,wxGROW);
    sizer->Add(outputs,1,wxGROW);

    SetSizer(sizer);
    SetAutoLayout(true);
    Layout();
  }
  //================================================================


  //================================================================
  void WxGUIBlackBoxInfo::UpdateInfo(BlackBoxDescriptor* descr)
  {

    //    mName->SetLabel(std2wx(descr->GetTypeName()));
    mDescription->SetLabel(std2wx(descr->GetDescription()));
    mAuthor->SetLabel(std2wx(descr->GetAuthor()));
    mCategory->SetLabel(std2wx(descr->GetCategory()));

    mInputList->ClearAll();
    mInputList->InsertColumn( 0, _("Name"),
			       wxLIST_FORMAT_LEFT, 80  );
    mInputList->InsertColumn( 1, _("Type"),
			       wxLIST_FORMAT_LEFT, 100 );
    mInputList->InsertColumn( 2, _("Nature"),
			       wxLIST_FORMAT_LEFT, 100  );
    mInputList->InsertColumn( 3, _("Description"),
			       wxLIST_FORMAT_LEFT, 500  );

    mOutputList->ClearAll();
    mOutputList->InsertColumn( 0, _("Name"),
			       wxLIST_FORMAT_LEFT, 80  );
    mOutputList->InsertColumn( 1, _("Type"),
			       wxLIST_FORMAT_LEFT, 100 );
    mOutputList->InsertColumn( 2, _("Nature"),
			       wxLIST_FORMAT_LEFT, 100  );
    mOutputList->InsertColumn( 3, _("Description"),
			       wxLIST_FORMAT_LEFT, 500  );


    std::vector<BlackBoxInputOutputDescriptor*> user_defined;
    std::vector<BlackBoxInputOutputDescriptor*> ubb_defined;
    std::vector<BlackBoxInputOutputDescriptor*> wxbb_defined;

    const BlackBoxDescriptor::InputDescriptorMapType& imap =
      descr->GetInputDescriptorMap();
    BlackBoxDescriptor::InputDescriptorMapType::const_iterator in;
    for ( in = imap.begin();  in != imap.end(); ++in )
      {
	int iotype = 0;
	if (in->second->GetCreatorTypeInfo() ==
	    typeid(AtomicBlackBoxDescriptor))
	  {
	    iotype = 1;
	  }
	else if (in->second->GetCreatorTypeInfo() ==
		 typeid(WxBlackBoxDescriptor))
	  {
	    iotype = 2;
	  }
	if (iotype==0) user_defined.push_back(in->second);
	else if (iotype==1) ubb_defined.push_back(in->second);
	else if (iotype==2) wxbb_defined.push_back(in->second);

      }

    std::vector<BlackBoxInputOutputDescriptor*>::iterator hi;
    for (hi=user_defined.begin();hi!=user_defined.end();++hi)
      {
	InsertInputOutput(mInputList,*hi);
      }
    for (hi=wxbb_defined.begin();hi!=wxbb_defined.end();++hi)
      {
	InsertInputOutput(mInputList,*hi);
      }
    for (hi=ubb_defined.begin();hi!=ubb_defined.end();++hi)
      {
	InsertInputOutput(mInputList,*hi);
      }

    // Outputs
    user_defined.clear();
    ubb_defined.clear();
    wxbb_defined.clear();
    const BlackBoxDescriptor::OutputDescriptorMapType& omap =
      descr->GetOutputDescriptorMap();
    BlackBoxDescriptor::OutputDescriptorMapType::const_iterator out;
    for ( out = omap.begin();  out != omap.end(); ++out )
      {
	int iotype = 0;
	if (out->second->GetCreatorTypeInfo() ==
	    typeid(AtomicBlackBoxDescriptor))
	  {
	    iotype = 1;
	  }
	else if (out->second->GetCreatorTypeInfo() ==
		 typeid(WxBlackBoxDescriptor))
	  {
	    iotype = 2;
	  }

	if (iotype==0) user_defined.push_back(out->second);
	else if (iotype==1) ubb_defined.push_back(out->second);
	else if (iotype==2) wxbb_defined.push_back(out->second);

      }
    for (hi=user_defined.begin();hi!=user_defined.end();++hi)
      {
	InsertInputOutput(mOutputList,*hi);
      }
    for (hi=wxbb_defined.begin();hi!=wxbb_defined.end();++hi)
      {
	InsertInputOutput(mOutputList,*hi);
      }
    for (hi=ubb_defined.begin();hi!=ubb_defined.end();++hi)
      {
	InsertInputOutput(mOutputList,*hi);
      }
  }
  //================================================================


  //================================================================
  void WxGUIBlackBoxInfo::InsertInputOutput(wxListCtrl* l,
					    BlackBoxInputOutputDescriptor* d)
  {
    wxListItem kNewItem;
    kNewItem.SetAlign(wxLIST_FORMAT_LEFT);
    int nID = l->GetItemCount();
    //    std::cout << nID << std::endl;
    kNewItem.SetId(nID);
    //    kNewItem.SetMask(wxLIST_MASK_DATA);
    //    kNewItem.SetData(d);
    l->InsertItem(kNewItem);
    l->SetItem(nID, 0, std2wx(d->GetName()) );
    l->SetItem(nID, 1, std2wx(d->GetTypeName()) );
    l->SetItem(nID, 2, std2wx(d->GetNature()) );
    l->SetItem(nID, 3, std2wx(d->GetDescription()) );
  }
  //================================================================

  //================================================================
  WxGUIBlackBoxInfo::~WxGUIBlackBoxInfo()
  {
  }
  //================================================================


 enum
    {
      id_f1,
      id_f2,
      id_f3,
      id_f4,
      id_f5,
      id_f6,
      id_f7,
      id_f8,
      id_fc1,
      id_fc2,
      id_fc3
    };

  //================================================================
  WxGUIPackageBrowser2::WxGUIPackageBrowser2( wxWindow *parent,
					      WxGUIPackageBrowser2User* user )
    : wxPanel(parent, -1),
      mUser(user),
      mInterpreter()
  {
    _actualSelected=NULL;
    m_mgr.SetManagedWindow(this);

    //    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    mBoxList = new WxGUIBlackBoxList(this, LIST_CTRL,
				     wxDefaultPosition,
				     wxDefaultSize,
				     wxLC_REPORT //wxLC_LIST
				     | wxSUNKEN_BORDER);
    mBoxList->SetUser(this);
    mBoxList->SetBackgroundColour(*wxWHITE);


// JGRR & CM DISABLED CLOSE BUTTON
    m_mgr.AddPane(mBoxList,
		  wxAuiPaneInfo().Name(wxT("BoxList"))
		  .Caption(wxT("Black Boxes"))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Center()
		  .MinSize(wxSize(100,100))
		  .CloseButton(false)
		  );
    //    sizer->Add(mBoxList,5,wxGROW);

    mBoxInfo = new WxGUIBlackBoxInfo(this);
    //    sizer->Add(mBoxInfo,3,wxGROW);

// JGRR & CM DISABLED CLOSE BUTTON
    m_mgr.AddPane(mBoxInfo,
		  wxAuiPaneInfo().Name(wxT("Box"))
		  .Caption(wxT(""))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Bottom()
		  .MinSize(wxSize(100,200))
		  .CloseButton(false)
		  );

    wxPanel* filters = new wxPanel(this,-1);
    wxBoxSizer *fsizer = new wxBoxSizer(wxVERTICAL );
    wxBoxSizer *fpack =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Package")), wxHORIZONTAL );
    mPackageFilter = new wxTextCtrl(filters,id_f1,_T(""),
				    wxDefaultPosition,
				    wxDefaultSize,
				    wxTE_PROCESS_ENTER);
    fpack->Add(mPackageFilter,1,wxGROW);
    fsizer->Add(fpack,0,wxGROW);
    wxBoxSizer *fname =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Name")), wxHORIZONTAL );
    mNameFilter = new wxTextCtrl(filters,id_f2,_T(""),
				    wxDefaultPosition,
				    wxDefaultSize,
				    wxTE_PROCESS_ENTER);
    fname->Add(mNameFilter,1,wxGROW);
    fsizer->Add(fname,0,wxGROW);
    wxBoxSizer *fdescr =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Description")), wxHORIZONTAL );
    mDescriptionFilter = new wxTextCtrl(filters,id_f3,_T(""),
				    wxDefaultPosition,
				    wxDefaultSize,
				    wxTE_PROCESS_ENTER);
    fdescr->Add(mDescriptionFilter,1,wxGROW);
    fsizer->Add(fdescr,0,wxGROW);
    wxBoxSizer *fcat =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Category")), wxHORIZONTAL );
    mCategoryFilter = new wxTextCtrl(filters,id_f4,_T(""),
				    wxDefaultPosition,
				    wxDefaultSize,
				    wxTE_PROCESS_ENTER);
    fcat->Add(mCategoryFilter,1,wxGROW);
    fsizer->Add(fcat,0,wxGROW);
    wxBoxSizer *fintype =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Input type")), wxHORIZONTAL );
    mInputTypeFilter = new wxTextCtrl(filters,id_f5,_T(""),
				    wxDefaultPosition,
				    wxDefaultSize,
				    wxTE_PROCESS_ENTER);
    fintype->Add(mInputTypeFilter,1,wxGROW);
    fsizer->Add(fintype,0,wxGROW);
    wxBoxSizer *fouttype =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Output type")), wxHORIZONTAL );
    mOutputTypeFilter = new wxTextCtrl(filters,id_f6,_T(""),
				    wxDefaultPosition,
				    wxDefaultSize,
				    wxTE_PROCESS_ENTER);
    fouttype->Add(mOutputTypeFilter,1,wxGROW);
    fsizer->Add(fouttype,0,wxGROW);
    wxBoxSizer *finnat =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY, _T("Input nature")),wxHORIZONTAL );
    mInputNatureFilter = new wxTextCtrl(filters,id_f7,_T(""),
					wxDefaultPosition,
					wxDefaultSize,
					wxTE_PROCESS_ENTER);
    finnat->Add(mInputNatureFilter,1,wxGROW);
    fsizer->Add(finnat,0,wxGROW);
    wxBoxSizer *foutnat =
      new wxStaticBoxSizer
      ( new wxStaticBox(filters, wxID_ANY,_T("Output nature")),wxHORIZONTAL );
    mOutputNatureFilter = new wxTextCtrl(filters,id_f8,_T(""),
					wxDefaultPosition,
					wxDefaultSize,
					wxTE_PROCESS_ENTER);
    foutnat->Add(mOutputNatureFilter,1,wxGROW);
    fsizer->Add(foutnat,0,wxGROW);

    mShowWidgetsFilter = new wxCheckBox(filters,id_fc1,_T("Show widgets"));
    mShowWidgetsFilter->SetValue(true);
    fsizer->Add(mShowWidgetsFilter,0,wxGROW);

    mShowAdaptorsFilter = new wxCheckBox(filters,id_fc2,_T("Show adaptors"));
    mShowAdaptorsFilter->SetValue(false);
    fsizer->Add(mShowAdaptorsFilter,0,wxGROW);

    mShowGUIsFilter = new wxCheckBox(filters,id_fc3,_T("Show GUIs"));
    mShowGUIsFilter->SetValue(false);
    fsizer->Add(mShowGUIsFilter,0,wxGROW);

    filters->SetSizer(fsizer);

// JGRR & CM DISABLED CLOSE BUTTON
    m_mgr.AddPane(filters,
		  wxAuiPaneInfo().Name(wxT("Filter"))
		  .Caption(wxT("Filter"))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Left()
		  .MinSize(wxSize(100,100)) 
		  .CloseButton(false)
);

    //    sizer->Add(fsizer,1,wxGROW);
    m_mgr.Update();

    //    SetSizer(sizer);
    SetAutoLayout(true);
    Layout();

  }
  //================================================================

	Factory::Pointer WxGUIPackageBrowser2::GetFactory()
  {
    return mFactory;
  }

  //================================================================


  //================================================================
  void WxGUIPackageBrowser2::OnFilter(wxCommandEvent&)
  {
    RebuildList();
  }
  //================================================================

  //================================================================
  // User callback when a box is selected in the list
  void WxGUIPackageBrowser2::WxGUIBlackBoxListUserOnSelected
  ( BlackBoxDescriptor* d)
  {
	//RaC
	_actualSelected=d;

    mBoxInfo->UpdateInfo(d);
    std::string title = d->GetPackage()->GetName()+"::"+d->GetTypeName();
    m_mgr.GetPane(mBoxInfo).Caption(std2wx(title));
    m_mgr.Update();
  }

  //================================================================

  //================================================================
  BlackBoxDescriptor* WxGUIPackageBrowser2::GetActualSelected()
  {
	  return _actualSelected;
  }

  //================================================================

  //================================================================
  WxGUIPackageBrowser2::~WxGUIPackageBrowser2()
  {
    mFactory.reset();
    mInterpreter.reset();
    //    Object::PrintObjectListInfo("");
    m_mgr.UnInit();
  }
  //================================================================

  //================================================================
  void WxGUIPackageBrowser2::IncludeAll()
  {
    if (!mInterpreter) mInterpreter =bbtk::Interpreter::New();
    mInterpreter->SetCommandLine(true);
    std::stringstream* buf = new std::stringstream;
    *buf << "exec freeze_no_error" << std::endl;
    *buf << "message max 0" << std::endl;
    *buf << "include *" << std::endl;
    mInterpreter->InterpretBuffer(buf);

    Factory::Pointer F = mInterpreter->GetExecuter()->GetFactory();
    BuildFromFactory(F);
  }
  //================================================================

  //================================================================
  void WxGUIPackageBrowser2::BuildFromFactory(Factory::Pointer F)
  {
    mFactory = F;
    RebuildList();
  }

  //================================================================

  //================================================================
  void WxGUIPackageBrowser2::RebuildList()
  {
    mBoxList->Hide();
    mBoxList->ClearAll();

    const Factory::PackageMapType& M = mFactory->GetPackageMap();
    Factory::PackageMapType::const_iterator i;
    for (i=M.begin();i!=M.end();++i)
    {
        Package::Pointer P = i->second;
        if (P->GetName() == "user") continue;

        Package::DescriptorMapType::iterator j;
        for (j=P->GetDescriptorMap().begin();
             j!=P->GetDescriptorMap().end();
             ++j)
        {
            //	    std::cout << "Insert "<<j->second->GetTypeName()<<std::endl;
            if (IsVisible(j->second))
              mBoxList->Insert(j->second);
        }// for Descriptor
    }// for package
    mBoxList->Show();
  }
  //================================================================

 bool WxGUIPackageBrowser2::findnpos(const std::string &strA, const std::string &strB )
 {
    if ((strB=="") || (strA=="") )
    {
        return false;
    }

    bool ok=false;
    int i,size;
    std::string strAA=strA;
    std::string strBB=strB;


    size=strAA.length();
    for (i=0;i<size;i++)
    {
        if ((strAA[i]>='A')&&(strAA[i]<='Z'))
        {
            strAA[i]=strAA[i]+32;
        }
    }

    size=strBB.length();
    for (i=0;i<size;i++)
    {
        if ((strBB[i]>='A')&&(strBB[i]<='Z'))
        {
            strBB[i]=strBB[i]+32;
        }
    }


     if ( strAA.find(strBB) == std::string::npos )
     {
         ok=true;
     }

     return ok;
 }

  //================================================================
  bool WxGUIPackageBrowser2::IsVisible(BlackBoxDescriptor::Pointer d)
  {
    //    std::cout << "   '" << wx2std(mPackageFilter->GetValue())<<"'"<<std::endl;
    //    std::cout << "vs '" << d->GetPackage()->GetName() << "'"<<std::endl;
    if ((!mShowAdaptorsFilter->IsChecked())&&
	((d->GetKind()==BlackBoxDescriptor::ADAPTOR)||
	 (d->GetKind()==BlackBoxDescriptor::DEFAULT_ADAPTOR)))
    {
        return false;
    }

    if ((!mShowGUIsFilter->IsChecked())&&
	((d->GetKind()==BlackBoxDescriptor::GUI)||
	 (d->GetKind()==BlackBoxDescriptor::DEFAULT_GUI)))
    {
        return false;
    }

//EED    if (d->GetPackage()->GetName().find( wx2std(mPackageFilter->GetValue()) ) == std::string::npos )
    if ( findnpos(d->GetPackage()->GetName(),wx2std(mPackageFilter->GetValue())) == true )
    {
        return false;
    }

//EED    if (d->GetTypeName().find( wx2std(mNameFilter->GetValue()) ) == std::string::npos )
    if ( findnpos(d->GetTypeName(),wx2std(mNameFilter->GetValue())) == true )
    {
        return false;
    }

//EED    if (d->GetDescription().find( wx2std(mDescriptionFilter->GetValue()) ) == std::string::npos )
    if ( findnpos(d->GetDescription(),wx2std(mDescriptionFilter->GetValue())) == true )
    {
        return false;
    }

//EED    if (d->GetCategory().find( wx2std(mCategoryFilter->GetValue()) ) == std::string::npos )
    if ( findnpos(d->GetCategory(),wx2std(mCategoryFilter->GetValue())) == true )
    {
        return false;
    }

    if (!mShowWidgetsFilter->IsChecked())
    {
        bool found = false;
        const BlackBoxDescriptor::OutputDescriptorMapType& imap = d->GetOutputDescriptorMap();
        BlackBoxDescriptor::OutputDescriptorMapType::const_iterator in;
        for ( in = imap.begin();  in != imap.end(); ++in )
        {
            if (in->second->GetName() == "Widget" )
            {
                found = true;
                break;
            }
        }
        if (found)
        {
            return false;
        }
    }

    if (mInputTypeFilter->GetValue().size()>0)
    {
        std::string s = wx2std(mInputTypeFilter->GetValue());
        bool found = false;
        const BlackBoxDescriptor::InputDescriptorMapType& imap = d->GetInputDescriptorMap();
        BlackBoxDescriptor::InputDescriptorMapType::const_iterator in;
        for ( in = imap.begin();  in != imap.end(); ++in )
        {
//EED           if (in->second->GetTypeName().find(s)!=std::string::npos)
                if ( findnpos( in->second->GetTypeName() , s ) == true )
            {
                found = true;
                break;
            }
        }
        if (!found)
        {
            return false;
        }
     }

    if (mOutputTypeFilter->GetValue().size()>0)
    {
        std::string s = wx2std(mOutputTypeFilter->GetValue());
        bool found = false;
        const BlackBoxDescriptor::OutputDescriptorMapType& imap = d->GetOutputDescriptorMap();
        BlackBoxDescriptor::OutputDescriptorMapType::const_iterator in;
        for ( in = imap.begin();  in != imap.end(); ++in )
        {
 //EED      if (in->second->GetTypeName().find(s)!=std::string::npos)
            if ( findnpos( in->second->GetTypeName() , s ) == true )
            {
                found = true;
                break;
            }
        }
        if (!found)
        {
            return false;
        }
     }

    if (mInputNatureFilter->GetValue().size()>0)
    {
        std::string s = wx2std(mInputNatureFilter->GetValue());
        bool found = false;
        const BlackBoxDescriptor::InputDescriptorMapType& imap = d->GetInputDescriptorMap();
        BlackBoxDescriptor::InputDescriptorMapType::const_iterator in;
        for ( in = imap.begin();  in != imap.end(); ++in )
        {
//EED            if (in->second->GetNature().find(s)!=std::string::npos)
            if ( findnpos( in->second->GetNature() , s ) == true )
            {
                found = true;
                break;
            }
        }
        if (!found)
        {
            return false;
        }
     }

    if (mOutputNatureFilter->GetValue().size()>0)
    {
        std::string s = wx2std(mOutputNatureFilter->GetValue());
        bool found = false;
        const BlackBoxDescriptor::OutputDescriptorMapType& imap = d->GetOutputDescriptorMap();
        BlackBoxDescriptor::OutputDescriptorMapType::const_iterator in;
        for ( in = imap.begin();  in != imap.end(); ++in )
        {
//EED            if (in->second->GetNature().find(s)!=std::string::npos)
            if ( findnpos( in->second->GetNature() , s ) == true )
            {
                found = true;
                break;
            }
        }
        if (!found)
        {
            return false;
        }
     }

    return true;

  }
  //========================================================================

  //========================================================================
  BEGIN_EVENT_TABLE(WxGUIPackageBrowser2, wxPanel)
//EED    EVT_TEXT_ENTER(id_f1, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f2, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f3, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f4, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f5, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f6, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f7, WxGUIPackageBrowser2::OnFilter )
//EED    EVT_TEXT_ENTER(id_f8, WxGUIPackageBrowser2::OnFilter )

    EVT_TEXT(id_f1, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f2, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f3, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f4, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f5, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f6, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f7, WxGUIPackageBrowser2::OnFilter )
    EVT_TEXT(id_f8, WxGUIPackageBrowser2::OnFilter )

    EVT_CHECKBOX( id_fc1, WxGUIPackageBrowser2::OnFilter )
    EVT_CHECKBOX( id_fc2, WxGUIPackageBrowser2::OnFilter )
    EVT_CHECKBOX( id_fc3, WxGUIPackageBrowser2::OnFilter )
    END_EVENT_TABLE()
  //========================================================================



  //================================================================
  WxGUIPackageBrowser2Window::WxGUIPackageBrowser2Window( wxWindow *parent,
							  wxString title,
							  wxSize size)
      : wxFrame((wxFrame *)parent, -1, title, wxDefaultPosition, size)
  {
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

    mBrowser = new WxGUIPackageBrowser2(this);
    mBrowser->IncludeAll();
    sizer->Add(mBrowser,1,wxGROW);

    //    WxGUICommand* com = new WxGUICommand(this,this);
    //    sizer->Add(com);

    SetSizer(sizer);

     // Creates the parent window of all bbtk windows as a child of this
//    Wx::CreateTopWindow(this);
    // Add the method OnWxSignal as a Wx::Signal observer
    //bbtkAddWxSignalObserver(WxGUIPackageBrowser2Window::OnWxSignal);

    SetAutoLayout(true);
    Layout();
  }
  //================================================================

  //================================================================
  WxGUIPackageBrowser2Window::~WxGUIPackageBrowser2Window()
  {
  }
  //================================================================

} // namespace bbtk


#endif //_USE_WXWIDGETS_
