/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUIScriptingInterface.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.49 $
=========================================================================*/


   

/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

#include <iostream>	
#include "bbtkWxGUIScriptingInterface.h"
#include "bbtkWxBlackBox.h"
#include "bbtkConfigurationFile.h"
#include "bbtkWxStreamRedirector.h"
#include "bbtkUtilities.h"

#include "creaWx.h"

#include <wx/tipwin.h>
#include <wx/splash.h>


//#include "icons/cc_run.xpm"

namespace bbtk
{

    enum
    {
      ID_Menu_Quit = 1,
      ID_Menu_About,
      ID_Menu_EditConfig,
      ID_Menu_CreatePackage,
      ID_Menu_CreateBlackBox,
      ID_Menu_ShowImageGraph,
      ID_Menu_RegeneratePackageDoc,
      ID_Menu_RegenerateBoxesLists,
      ID_Menu_RegenerateAll,
      ID_Menu_PlugPackage,
      ID_Menu_Windows_Files,
      ID_Menu_Windows_Help,
      ID_Menu_Windows_Messages,
      ID_Menu_Windows_Command,
      ID_Menu_Windows_Save,
      ID_Menu_Windows_PackageBrowser
      //      ID_Button_Run
    };
    
  
  //================================================================
  WxGUIScriptingInterface::WxGUIScriptingInterface( wxWindow *parent )
    : wxFrame((wxFrame *)parent, -1, _T("bbStudio"), 
	      wxDefaultPosition, wxSize(1200,800) )
  {	
    m_mgr.SetManagedWindow(this);
    
    mInterpreter = bbtk::Interpreter::New();
    mInterpreter->SetUser(this);
	mInterpreter->SetCommandLine(true);
    mInterpreter->SetThrow(true);
    //    mInterpreter->AddBreakObserver
    //boost::bind( &WxGUIScriptingInterface::InterpreterUserOnBreak, this ));
    //==============
    // Menu
    wxInitAllImageHandlers();
    
    wxMenu *menuFile = new wxMenu;
    menuFile->Append( ID_Menu_EditConfig, _T("Open bbtk &Config file") );
    menuFile->Append( ID_Menu_Quit, _T("&Quit") );
    
    wxMenu *menuAbout = new wxMenu;
    menuAbout->Append( ID_Menu_About, _T("&About...") );

    wxMenu *menuTools = new wxMenu;
    menuTools->Append( ID_Menu_CreatePackage,  _T("Create &package") );
    menuTools->Append( ID_Menu_CreateBlackBox, _T("Create &black box") );
    menuTools->Append( ID_Menu_PlugPackage,    _T("&Plug package") );
    menuTools->AppendSeparator();
    menuTools->Append( ID_Menu_RegeneratePackageDoc,_T("Regenerate package &doc") );
    menuTools->Append( ID_Menu_RegenerateBoxesLists,_T("Regenerate boxes &lists") );
    menuTools->Append( ID_Menu_RegenerateAll,       _T("Regenerate &all") );
    menuTools->AppendSeparator();
    menuTools->Append( ID_Menu_ShowImageGraph, _T("&Show last graph") );

    wxMenu *menuWindows = new wxMenu;
    menuWindows->AppendCheckItem(ID_Menu_Windows_Files,
				 _T("Show 'files' panel") )->Check();
    menuWindows->AppendCheckItem(ID_Menu_Windows_Help,
				 _T("Show 'help' panel") )->Check();
    menuWindows->AppendCheckItem(ID_Menu_Windows_Messages,
				 _T("Show 'messages' panel") )->Check();
    menuWindows->AppendCheckItem(ID_Menu_Windows_Command,
				 _T("Show 'command' panel") )->Check();
    menuWindows->AppendSeparator();
    menuWindows->Append( ID_Menu_Windows_PackageBrowser, _T("Start Package &Browser") );
    
    //    menuWindows->AppendSeparator();
    //    menuWindows->Append ( ID_Menu_Windows_Save, _T("Save interface configuration"));

    wxMenu *menuOptions = new wxMenu;
    mwxMenuItemReset = menuOptions->AppendCheckItem(-1,
						    _T("Reset before running") );
    mwxMenuItemReset->Check();

    wxMenuBar *menuBar = new wxMenuBar;
    menuBar->Append( menuFile, _T("&File") );
    menuBar->Append( menuTools, _T("&Tools") );
    menuBar->Append( menuOptions, _T("&Options") );
    menuBar->Append( menuWindows, _T("&Windows") );
    menuBar->Append( menuAbout, _T("About") );
    
    SetMenuBar( menuBar );
    
    //=== 
    // Status bar
    CreateStatusBar();
    SetStatusText( _T("Welcome to bbStudio !") );
    
    //===
    // Panes (Files, Messages, Help, Command)
    mWxGUITextEditor = new WxGUITextEditor(this,this);
    mWxGUITextEditor->SetFileNameFilter("*.bbs");
	
    mWxGUIHtmlBrowser = new WxGUIHtmlBrowser(this,wxSize(200,0),this);

    mWxGUIOutputMessages = new WxGUIOutputMessages(this);

    mWxGUICommand = new WxGUICommand(this,this);
   
    mWxGUICommand->SetFocus();

 
#if NOTEBOOK

    mwxNotebook = new wxAuiNotebook(this,  
				    -1,
				    wxPoint(0, 0),
				    wxSize(500,500),
				    wxAUI_NB_TAB_SPLIT 
				    | wxAUI_NB_TAB_MOVE
				    | wxAUI_NB_TAB_EXTERNAL_MOVE
				    //| wxAUI_NB_WINDOWLIST_BUTTON
				    //|wxAUI_NB_SCROLL_BUTTONS
				    // | wxAUI_NB_CLOSE_BUTTON 
				    //| wxAUI_NB_CLOSE_ON_ACTIVE_TAB
				    //| wxAUI_NB_CLOSE_ON_ALL_TABS
				    | wxNO_BORDER);
  

    mwxNotebook->AddPage(mWxGUITextEditor,_T("Files"),true);
    mwxNotebook->AddPage(mWxGUIHtmlBrowser,_T("Help"),true);

    mwxNotebook->AddPage(mWxGUIOutputMessages,_T("Messages"),true);

    mwxNotebook->AddPage(mWxGUICommand,_T("Command"),true);


    m_mgr.AddPane(mwxNotebook,
		  wxAuiPaneInfo().Name(wxT("nb"))
		  .CaptionVisible(false)
		  .MinimizeButton(false)
		  .MaximizeButton(false)
		  .Center()
		  //		  .MinSize(wxSize(100,100))
		  );   
#else 

    //
    m_mgr.AddPane(mWxGUITextEditor,
		  wxAuiPaneInfo().Name(wxT("editor_content"))
		  .Caption(wxT("Files"))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Center()
		  .MinSize(wxSize(100,100))
		  );   
  
    m_mgr.AddPane(mWxGUIHtmlBrowser,
		  wxAuiPaneInfo().Name(wxT("browser_content"))
		  .Caption(wxT("Help"))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Right()
		  .Layer(2)
		  .MinSize(wxSize(400,100))
		  );

    m_mgr.AddPane(mWxGUIOutputMessages,
		  wxAuiPaneInfo().Name(wxT("messages_content"))
		  .Caption(wxT("Messages"))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Bottom()
		  .MinSize(wxSize(100,100))
		  );
	  
    m_mgr.AddPane(mWxGUICommand,
		  wxAuiPaneInfo().Name(wxT("command_content"))
		  .Caption(wxT("Command"))
		  .MinimizeButton(true)
		  .MaximizeButton(true)
		  .Bottom()
		  .Layer(1)
		  .MinSize(wxSize(100,100))
		  );     
#endif

    // parent window of all bbtk windows will be a child of this
    //    Wx::SetTopWindowParent(this);
    Wx::SetTopWindow(this);
    // Wx::SetAutoDestroyTopWindow(false);
  // Add the method OnWxSignal as a Wx::Signal observer 
    //bbtkAddWxSignalObserver(WxGUIPackageBrowser2Window::OnWxSignal);

    //.PaneBorder(false)); 
    // Load the interface appearance saved on last closing
    LoadPerspective();

    // Done in LoadPerspective
    //    m_mgr.Update();
	
    SetAutoLayout(true);
    Layout();
    //    mwxNotebook->SetSelection(1);
    mWxGUIHtmlBrowser->GoHome();
//    Refresh();
    m_mgr.Update();
    //   LoadPerspective();

    mBreaked = false;	

    wxBitmap bitmap;   
    wxSplashScreen* splash;
    long style = wxSPLASH_CENTRE_ON_SCREEN | wxSPLASH_TIMEOUT;
    if (ConfigurationFile::GetInstance().DotBbtkIsNew())
      style = wxSPLASH_CENTRE_ON_SCREEN | wxSPLASH_NO_TIMEOUT;
    std::string splash_file = ConfigurationFile::GetInstance().Get_data_path();
    splash_file += "/kernel/icons/bbStudioSplashScreen.png";

    if (bitmap.LoadFile(std2wx(splash_file),wxBITMAP_TYPE_PNG))
      splash = 
	new wxSplashScreen(bitmap,
			   style,
			   1000, 0, -1, wxDefaultPosition, wxDefaultSize,
			   wxSIMPLE_BORDER|wxSTAY_ON_TOP);

    if (ConfigurationFile::GetInstance().DotBbtkIsNew())
      {

	DoRegeneratePackageDoc("-a");	
	DoRegenerateBoxesLists();

	/*
	wxTipWindow* tip = new wxTipWindow(this,
					   _T("\n                  Welcome to bbStudio !\n\n   To run a demo or example:\n     1. click on the 'Demos' or 'Examples' link\n     2. select a demo or example\n     3. click on the '[source]' link : the source file is loaded in bbStudio\n     4. click on the 'Run' button (the arrow at the bottom right of the source file)   \n"),1000);
	tip->CenterOnParent();
	tip->Show();
	*/
	if (splash) splash->Destroy();
      }

  }
  //================================================================

 //================================================================
  WxGUIScriptingInterface::~WxGUIScriptingInterface()
  {
  bbtkDebugMessage("widget",9,"bbStudio::~bbStudio()"<<std::endl);
    SavePerspective();
    m_mgr.UnInit();
  }
  //================================================================

  //================================================================
  void WxGUIScriptingInterface::OnClose(wxCloseEvent& event)
  {
    bbtkDebugMessage("widget",9,"bbStudio::OnClose()"<<std::endl);
    //Wx::SetWindowsHaveBeenDestroyedByParent();
    //mInterpreter.reset();
    wxWindowList& list = GetChildren();
    wxWindowList::iterator iter;
    for (iter = list.begin(); iter != list.end(); ++iter)
      {
	(*iter)->Close();
      }
    this->Destroy();
  }
  //================================================================


  //================================================================
  void WxGUIScriptingInterface::Open(const std::string& filename)
  {
    mWxGUITextEditor->Open(filename);
  }
  //================================================================
  /*
  catch (BreakException e)						\
    {									\
      std::cout << "* BREAK"<<std::endl;				\
      if (e.IsInScriptFile())						\
	std::cout << "* FILE   : '"<<e.GetScriptFile()<<"'"<<std::endl; \
      std::cout << "* LINE   : "<<e.GetScriptLine()<<std::endl;		\
    }									\
  catch (QuitException e)						\
    {									\
      std::cout << "* QUIT"<<std::endl;					\
      if (e.IsInScriptFile())						\
	std::cout << "* FILE   : '"<<e.GetScriptFile()<<"'"<<std::endl; \
      std::cout << "* LINE   : "<<e.GetScriptLine()<<std::endl;		\
    }									\
*/
  
#define CATCH_MACRO							\
  catch (InterpreterException e)					\
    {									\
      if (e.GetErrorMessage()=="quit")					\
	{								\
	  std::cerr << "* QUIT ENCOUNTERED"<<std::endl;			\
	  if (e.IsInScriptFile())					\
	    std::cerr << "* FILE   : '"<<e.GetScriptFile()<<"'"<<std::endl; \
	  std::cerr << "* LINE   : "<<e.GetScriptLine()<<std::endl;	\
	}								\
      else if (e.GetErrorMessage()=="break")				\
	{								\
	  mBreaked = true;						\
	  std::cerr << "* BREAK"<<std::endl;				\
	  if (e.IsInScriptFile())					\
	    std::cerr << "* FILE   : '"<<e.GetScriptFile()<<"'"<<std::endl; \
	  std::cerr << "* LINE   : "<<e.GetScriptLine()<<std::endl;	\
	}								\
      else								\
	{								\
	  std::cerr << "* ERROR : "<<e.GetErrorMessage()<<std::endl;	\
	  if (e.IsInScriptFile())					\
	    std::cerr << "* FILE   : '"<<e.GetScriptFile()<<"'"<<std::endl; \
	  std::cerr << "* LINE   : "<<e.GetScriptLine()<<std::endl;	\
	  int lev = bbtk::MessageManager::GetMessageLevel("Error");	\
	  if (lev > 0) {						\
	    std::cerr << "* Exception thrown : "<<std::endl;		\
	    std::cerr << "*  OBJECT : " <<e.GetObject()<<std::endl;	\
	    std::cerr << "*  FILE   : " <<e.GetSourceFile()<<std::endl;	\
	  }								\
	}								\
    }
  
  //================================================================
  void WxGUIScriptingInterface::WxGUICommandEnter(const std::string& command)
  {
    std::string s("> ");
    s += command + "\n";
    mWxGUIOutputMessages->Print(s,wxRED);
    
    try
      {
	mInterpreter->InterpretLine( command );
      }
    CATCH_MACRO;
  }
  //================================================================
  
  //================================================================
  /// Runs the interpretation of a file
  bool WxGUIScriptingInterface::InterpretFile( const std::string& filename) 
  { 
    try
      {
	mInterpreter->InterpretFile(filename);
      }
    CATCH_MACRO;
    return true;
  }
  //================================================================
 
	
  //================================================================
	void WxGUIScriptingInterface::WxGUITextEditorGraphSimple()
	{
		WxGUICommandEnter("exec freeze_no_error");
		WxGUITextEditorRun();
		WxGUICommandEnter("exec unfreeze");
		WxGUICommandEnter("graph");
	}
  //================================================================
	
	//================================================================
	void WxGUIScriptingInterface::WxGUITextEditorGraphDetail()
	{
		WxGUICommandEnter("exec freeze_no_error");
		WxGUITextEditorRun();
		WxGUICommandEnter("exec unfreeze");
		WxGUICommandEnter("graph . 1");
	}
	//================================================================

	
	//================================================================
	void WxGUIScriptingInterface::WxGUITextEditorRunBBI()
	{
	  std::string separator = ConfigurationFile::GetInstance().Get_file_separator ();
	  std::string dir = ConfigurationFile::GetInstance().Get_default_temp_dir();
	  std::string filename = dir + separator + "tmp_bbtk.bbs";
	  mWxGUITextEditor->GetCurrentPage()->SaveFile(filename);
	
	std::string command = "\"";

#ifdef WIN32
	command += "\"";
#endif

 	  command += ConfigurationFile::GetInstance().Get_bin_path();
#ifdef MACOSX
	  command += separator + "bbi.app/Contents/MacOS/bbi\" ";
#else 
	  command += separator + "bbi\" ";
#endif
	  command += "\""+filename + "\"";

#ifdef WIN32
	command += "\"";
#endif

	  command += " & ";
	  
  	  printf ("EED WxGUIScriptingInterface::WxGUITextEditorRunBBI %s \n" , command.c_str() );
   	  system( command.c_str() );
	}
	//================================================================
	
	
  //================================================================
  void WxGUIScriptingInterface::WxGUITextEditorRun()
  {
    //    wxString temp = mWxGUIHtmlBrowser->GetCurrentPage();
    std::stringstream* buf = new std::stringstream;
    (*buf) << mWxGUITextEditor->GetCurrentPage()->GetText();
    try 
      {
	if (!mBreaked)
	  {
	    if (mwxMenuItemReset->IsChecked()) WxGUICommandEnter("reset");
	    mInterpreter->InterpretBuffer(buf);
	  }
	else 
	  {
	    mBreaked = false;
	    mInterpreter->InterpretCurrentStreams();
	  }
	//	std::cout << "EO RUN"<<std::endl;
      }
    CATCH_MACRO;
    //    std::cout << "EO RUN 3"<<std::endl;
  }
  //================================================================  

  //================================================================
  void WxGUIScriptingInterface::OnMenuQuit(wxCommandEvent& WXUNUSED(event))
  {
    if (!mWxGUITextEditor->CloseAllPages()) return;
    Close(true);
  }
  //================================================================


  //================================================================
  void WxGUIScriptingInterface::OnMenuAbout(wxCommandEvent& WXUNUSED(event))
  {
    m_mgr.Update();
    Refresh();
    wxMessageBox(_T("  bbStudio\nThe Black Box Toolkit Development Studio\n(c) CREATIS 2008\n\n http://www.creatis.insa-lyon.fr/site/en/CreaTools_home"),
                 _T("About ..."), wxOK | wxICON_INFORMATION,
                 this);
  }
  //================================================================


  //================================================================
  void WxGUIScriptingInterface::OnMenuEditConfig(wxCommandEvent& WXUNUSED(event))
  {

    std::string configFile = 
      ConfigurationFile::GetInstance().Get_config_xml_full_path();
    Open(configFile);
	wxMessageDialog ww(NULL,_T("If you change the bbtk_config.xml, you have to restart this appliaction..."), _T("Alert !"), wxOK);
	ww.ShowModal();
  }
  //================================================================

  //================================================================
  void WxGUIScriptingInterface::OnMenuWindowsPackageBrowser(wxCommandEvent& WXUNUSED(event))
  {
    wxBusyCursor wait;
    WxGUIPackageBrowser2Window *helpbrowser = new
      WxGUIPackageBrowser2Window(this,_T("Package Browser"), wxSize(600,600) );
    helpbrowser->Show();
    
    /*
    wxBusyCursor wait;
    WxGUIPackageBrowser2 *browser = new WxGUIPackageBrowser2(this);
    browser->IncludeAll();
    */
#if NOTEBOOK
    //     mwxNotebook->AddPage(browser,_T("Package Browser"),true);
#else
     /*
     m_mgr.AddPane(browser,
		   wxAuiPaneInfo().Name(wxT("package_brower"))
		   .Caption(wxT("Package browser"))
		   .MinimizeButton(true)
		   .MaximizeButton(true)
		   .Bottom()
		   .Position(1)
		   .MinSize(wxSize(100,100))
		   );     
     */
#endif
  }
  //================================================================



  //================================================================
  void WxGUIScriptingInterface::OnMenuCreatePackage(wxCommandEvent& WXUNUSED(event))
  {
/*
    std::string command("toolsbbtk/appli/GUICreatePackage");
    bbtkMessage("Debug",1,"Executing : '"<<command<<"'"<<std::endl);
  
	Interpreter::Pointer I = Interpreter::New();    
    I->InterpretFile(command);
*/
    std::string command("reset");
	mWxGUICommand->SendCommand(command);
    command = "include toolsbbtk/appli/GUICreatePackage";
    bbtkMessage("Debug",1,"Executing : '"<<command<<"'"<<std::endl);
	mWxGUICommand->SendCommand(command);
  }
  //================================================================


  //================================================================
  void WxGUIScriptingInterface::OnMenuCreateBlackBox(wxCommandEvent& WXUNUSED(event))
  {
	  /*
    std::string command("toolsbbtk/appli/GUICreateBlackBox");
    bbtkMessage("Debug",1,"Executing : '"<<command<<"'"<<std::endl);
    
    Interpreter::Pointer I = Interpreter::New();    
    I->InterpretFile(command);
*/
    std::string command("reset");
	mWxGUICommand->SendCommand(command);
    command = "include toolsbbtk/appli/GUICreateBlackBox";
    bbtkMessage("Debug",1,"Executing : '"<<command<<"'"<<std::endl);
	mWxGUICommand->SendCommand(command);
  }
  //================================================================
  
  //================================================================
  void WxGUIScriptingInterface::OnMenuShowImageGraph(wxCommandEvent& WXUNUSED(event))
  {

      std::string doc_path = bbtk::ConfigurationFile::GetInstance().Get_doc_path();
      doc_path += bbtk::ConfigurationFile::GetInstance().Get_file_separator();
      doc_path += "bbdoc";
      doc_path += bbtk::ConfigurationFile::GetInstance().Get_file_separator();
	  
	  std::string pack_name("User");
	  std::string pack_path = doc_path + pack_name;	  
	  
#if defined(WIN32)
    std::string strappli="start ";
#else
  #if defined(MACOSX)
      std::string strappli="open ";
  #else
      std::string strappli="gnome-open ";	  
  #endif
#endif	  
	  std::string strcommand = strappli +pack_path+"/workspace_workspacePrototype.png";
    //	std::cout << "system: " << strcommand << std::endl;
    system ( strcommand.c_str() );

  }
  //================================================================

  void WxGUIScriptingInterface::DoRegeneratePackageDoc( const std::string& pack )
  {
    std::string mess("Regenerating doc for package '");
    if (pack!="-a") 
      mess += pack + "'";
    else 
      mess = "Regenerating doc for all packages";
    mess += " ... please wait";

    SetStatusText( std2wx(mess) );

    BBTK_BUSY_CURSOR;

    std::string command;
#if defined(WIN32)
    command = "\"";
#endif
    command += ConfigurationFile::GetInstance().Get_bin_path();
    command += ConfigurationFile::GetInstance().Get_file_separator();
    command += "bbRegeneratePackageDoc";
#if defined(WIN32)
	command += "\"";
#endif
	command += " " + pack + " -q";
    bbtkMessage("debug",1,"Executing system command '"<<command<<"'"<<std::endl);


    if ( ! system ( command.c_str() ) )
      {
	SetStatusText( _T("Done !"));
	/*
	wxMessageBox(_T("Done !"),_T("Regenerate package '")
		     +std2wx(pack)+_T("' doc"),
		     wxOK | wxICON_INFORMATION);
	*/
      }
    else 
      {
	SetStatusText( _T("Done !"));
	wxString err(_T("An error occured while running '"));
	err +=  bbtk::std2wx(command) + _T("'");
	wxMessageBox(err,_T("Regenerate package doc"),wxOK | wxICON_ERROR);      
      }
  }


  //================================================================
  void WxGUIScriptingInterface::OnMenuRegeneratePackageDoc(wxCommandEvent& WXUNUSED(event))
  {
    wxString name = wxGetTextFromUser(_T("Enter package name (-a for all)"),
				      _T("Regenerate package doc"),
				      _T(""));
    if (name.IsEmpty()) return;
    std::string pack = bbtk::wx2std(name);
    
	DoRegeneratePackageDoc(pack);
  }
  //================================================================


  //================================================================
  void WxGUIScriptingInterface::DoRegenerateBoxesLists()
  {
    SetStatusText( _T("Regenerating boxes lists ... please wait") );
    BBTK_BUSY_CURSOR ;

    std::string command;
#if defined(WIN32)
	command = "\"";
#endif
    command += ConfigurationFile::GetInstance().Get_bin_path();
    command += ConfigurationFile::GetInstance().Get_file_separator();
    command += "bbRegenerateBoxesLists";
#if defined(WIN32)
	command += "\"";
#endif
	command += " -q";
	bbtkMessage("debug",1,"Executing system command '"<<command<<"'"<<std::endl);

std::cout << "==========================================================================================================" << command.c_str() << std::endl;
    if ( ! system ( command.c_str() ) )
      {
	SetStatusText( _T("Done !"));
	/*
	wxMessageBox(_T("Done !"),_T("Regenerate boxes lists"),
		     wxOK | wxICON_INFORMATION);
	*/
      }
    else 
      {
	SetStatusText( _T("Done !"));
	wxString err(_T("An error occured while running '"));
	err +=  bbtk::std2wx(command) + _T("'");
	wxMessageBox(err,_T("Regenerate boxes lists"),wxOK | wxICON_ERROR);      
      }
  }
  //================================================================


  //================================================================
  void WxGUIScriptingInterface::OnMenuRegenerateBoxesLists(wxCommandEvent& WXUNUSED(event))
  {
	DoRegenerateBoxesLists();
  }
  //================================================================

  //================================================================
  void WxGUIScriptingInterface::OnMenuRegenerateAll(wxCommandEvent& WXUNUSED(event))
  {
	
    DoRegeneratePackageDoc("-a");	
	DoRegenerateBoxesLists();
  }
  //================================================================

 
  //================================================================
  /**
   * Event Handler for the plug package menu.
   * This method prompts the user for the directory where the bbtkPackage file is
   * located and associates the related package with the configuration file.
   * @param event event not used.
   */

  //DFGO - 8/10/2012
  void WxGUIScriptingInterface::OnMenuPlugPackage(wxCommandEvent& WXUNUSED(event))
  {
    long style = wxDD_DEFAULT_STYLE | wxDD_DIR_MUST_EXIST;
    wxDirDialog* FD =
      new wxDirDialog( 0,
		       _T("Select package directory"),
		       _T(""),
		       style);
    long userResponse;
    do
    {
    	userResponse = FD->ShowModal();
    	if(userResponse==wxID_OK)
    	{
			std::string path = wx2std (FD->GetPath()) ;
			std::string fname = path + "/bbtkPackage";
			std::cout << "Path chosen = \"" << FD->GetPath() << "\"" << std::endl;
			if ( Utilities::FileExists( fname ) )
			{
				std::ifstream f;
				f.open(fname.c_str());
				std::string pname;
				f >> pname;
				f.close();

				bbtk::ConfigurationFile::GetInstance().AddPackagePathsAndWrite( path );

				DoRegeneratePackageDoc(pname);
				DoRegenerateBoxesLists();

				wxMessageBox(_T("Package successfully plugged"),_T("Plug package"),wxOK | wxICON_INFORMATION);

				userResponse = wxID_CANCEL;
			}
			else
			{
				std::string err = "The directory \"" + path + "\" does not contain a 'bbtkPackage' file.";
				#ifndef WIN32
					#ifndef MACOSX
						err += "\nNote: If you are on Linux please select the folder and click \"Open\", don't enter in it.";
					#endif
				#endif


				wxMessageBox(crea::std2wx(err),_T("Plug package"),wxOK | wxICON_ERROR);
			}
    	}
    }while(userResponse != wxID_CANCEL);
  }
  //================================================================

  //================================================================
  void WxGUIScriptingInterface::InterpreterUserViewHtmlPage(const std::string& page)
  {
    std::string s(page);
    //  std::cout << "WxGUIScriptingInterface::ShowHtmlPage('"<<page<<"')"<<std::endl;
    if (mWxGUIHtmlBrowser->GoTo(s)) 
      {
//EED	mwxNotebook->ChangeSelection(1);
//    	mwxNotebook->SetSelection(1);
      }
    else 
      {
         // std::cout << "ERROR html"<<std::endl;
      }
  } 
  //================================================================  
  
  /*
  //================================================================
  void WxGUIScriptingInterface::InterpreterUserOnBreak()
  {
    //    std::cout << "Break" << std::endl;
    
  }
  //================================================================
  */

  //================================================================  
  bool WxGUIScriptingInterface::WxGUIHtmlBrowserUserOnLinkClicked(const std::string& target)
  {
    size_t s = target.length();
    if ((s>3) && (target[s-1]=='s')
              && (target[s-2]=='b')
              && (target[s-3]=='b')
              && (target[s-4]=='.'))
	{
			mWxGUITextEditor->Open(target);
			#if NOTEBOOK
				mwxNotebook->SetSelection(0);
			#endif
			mWxGUITextEditor->SetFocus();
			return false;
	}

	if ((s>3) && (target[s-1]=='f')
		  && (target[s-2]=='d')
		  && (target[s-3]=='p')
		  && (target[s-4]=='.'))
	{

		// Open pdf in linux
		  // gnome-open target

		// Open pdf in macOS

		// Open pdf in windows
			int size=target.size();
			int pos=target.rfind("\\");
			std::string commandStart("start ");
			std::string commandPath("/D \""+target.substr(0,pos) +"\"");
			std::string commandPDF( target.substr(pos+1,size-pos+1) );

			printf("EED WxGUIScriptingInterface::WxGUIHtmlBrowserUserOnLinkClicked cc %s \n",commandPath.c_str() );
			// cleanning path
			while ((int)commandPath.rfind("\\\\")!=-1 )
			{
				commandPath.erase( commandPath.rfind("\\\\") , 1 );
			printf("EED WxGUIScriptingInterface::WxGUIHtmlBrowserUserOnLinkClicked cc %s \n",commandPath.c_str() );
			}

			std::string command = commandStart+commandPath+" "+commandPDF;
			printf("EED WxGUIScriptingInterface::WxGUIHtmlBrowserUserOnLinkClicked BB %s \n",command.c_str() );
			system( command.c_str() );
			return false;
     }
    return true;
  }
  //================================================================  

  void WxGUIScriptingInterface::OnMenuWindowsCheck( wxCommandEvent& event, 
						    wxWindow* w)
  {
    bool checked = event.IsChecked();
    bool shown = m_mgr.GetPane(w).IsShown();
    //    std::cout << "checked = "<<checked<<" - shown = "<<shown<<std::endl;
    if (checked ^ shown) 
      {
	m_mgr.GetPane(w).Show(checked);
	m_mgr.Update();
      }
  }

  //================================================================  
  void WxGUIScriptingInterface::OnMenuWindowsFiles(wxCommandEvent& event)
  {
    OnMenuWindowsCheck(event,mWxGUITextEditor);
  }
  //================================================================  

  //================================================================  
  void  WxGUIScriptingInterface::OnMenuWindowsHelp(wxCommandEvent& event)
  {
    OnMenuWindowsCheck(event,mWxGUIHtmlBrowser);
  }
  //================================================================  

  //================================================================  
  void  WxGUIScriptingInterface::OnMenuWindowsMessages(wxCommandEvent& event)
  {
    OnMenuWindowsCheck(event,mWxGUIOutputMessages);
  }
  //================================================================  

  //================================================================  
  void  WxGUIScriptingInterface::OnMenuWindowsCommand(wxCommandEvent& event)
  {
    OnMenuWindowsCheck(event,mWxGUICommand);
  }
  //================================================================  

  //================================================================  
  void WxGUIScriptingInterface::OnMenuWindowsSave( wxCommandEvent& WXUNUSED(event))
  {
    SavePerspective();
  }
  //================================================================  

  //================================================================  
  void WxGUIScriptingInterface::SavePerspective()
  {
    //    std::cout  << "Saving configuration..."<<std::endl;
    std::string conf = wx2std(m_mgr.SavePerspective());
    std::string fname = Utilities::MakeUserSettingsFullFileName("bbStudio.aui");
    std::ofstream f;
    f.open(fname.c_str(), std::ios::out );
    f << conf << std::endl;

    //    int x,y;
    //    GetPosition(&x,&y);
    //    f << x << "  " << y << std::endl;


    int w,h;
    GetSize(&w,&h);

    f << w << " " << h << std::endl;

    f.close();
  }
  //================================================================  

  //================================================================  
  void WxGUIScriptingInterface::LoadPerspective()
  {
    std::string fname = 
      Utilities::MakeUserSettingsFullFileName("bbStudio.aui");
    if ( Utilities::FileExists( fname ))
      {
	//	std::cout  << "Loading configuration..."<<std::endl;

	std::ifstream f;
	f.open(fname.c_str());
	std::string conf;
	f >> conf;

	//	int x,y;
	//	f >> x >> y ;

	int w,h;
	f >> w >> h ;

	f.close();
	
	//	std::cout << conf << std::endl;

	//	Move(x,y);
	SetSize(w,h);
	m_mgr.LoadPerspective(std2wx(conf));
      }
    else 
      {
	m_mgr.Update();
      }
  }
  //================================================================  

  //================================================================  
  void WxGUIScriptingInterface::OnPaneClose(wxAuiManagerEvent& evt)
  {
    std::cout  << "Closing panel '"<<evt.pane->name<<"'"<<std::endl;
    // TO DO : Uncheck 
    //    OnMenuWindowsCheck( wxCommandEvent& event, wxWindow* w);
  }
  //================================================================  

  
  //================================================================  
  BEGIN_EVENT_TABLE(WxGUIScriptingInterface, wxFrame)
    EVT_CLOSE(  WxGUIScriptingInterface::OnClose)
    EVT_MENU(ID_Menu_Quit, WxGUIScriptingInterface::OnMenuQuit)
    EVT_MENU(ID_Menu_About, WxGUIScriptingInterface::OnMenuAbout)
    EVT_MENU(ID_Menu_EditConfig, WxGUIScriptingInterface::OnMenuEditConfig)
    EVT_MENU(ID_Menu_CreatePackage, WxGUIScriptingInterface::OnMenuCreatePackage)
    EVT_MENU(ID_Menu_CreateBlackBox, WxGUIScriptingInterface::OnMenuCreateBlackBox)
    EVT_MENU(ID_Menu_ShowImageGraph, WxGUIScriptingInterface::OnMenuShowImageGraph)
    EVT_MENU(ID_Menu_RegeneratePackageDoc, WxGUIScriptingInterface::OnMenuRegeneratePackageDoc)
    EVT_MENU(ID_Menu_RegenerateBoxesLists, WxGUIScriptingInterface::OnMenuRegenerateBoxesLists)
    EVT_MENU(ID_Menu_RegenerateAll, WxGUIScriptingInterface::OnMenuRegenerateAll)
    EVT_MENU(ID_Menu_PlugPackage, WxGUIScriptingInterface::OnMenuPlugPackage)
    EVT_MENU(ID_Menu_Windows_Files, WxGUIScriptingInterface::OnMenuWindowsFiles)
    EVT_MENU(ID_Menu_Windows_Help, WxGUIScriptingInterface::OnMenuWindowsHelp)
    EVT_MENU(ID_Menu_Windows_Messages, WxGUIScriptingInterface::OnMenuWindowsMessages)
    EVT_MENU(ID_Menu_Windows_Command, WxGUIScriptingInterface::OnMenuWindowsCommand)
    EVT_MENU(ID_Menu_Windows_Save, WxGUIScriptingInterface::OnMenuWindowsSave)
    EVT_MENU(ID_Menu_Windows_PackageBrowser, WxGUIScriptingInterface::OnMenuWindowsPackageBrowser)
    EVT_AUI_PANE_CLOSE(WxGUIScriptingInterface::OnPaneClose)
  //    EVT_BUTTON(ID_Button_Run, WxGUIScriptingInterface::OnButtonRun )
    END_EVENT_TABLE()
  //================================================================

} // namespace bbtk


#endif //_USE_WXWIDGETS_
