/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkWxGUITextEditor.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.22 $
=========================================================================*/




/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief 
 */
/**
 * \class bbtk::
 * \brief 
 */


#ifdef _USE_WXWIDGETS_

#include <iostream>	
#include "bbtkWxGUITextEditor.h"
#include "bbtkWxBlackBox.h"
#include "bbtkConfigurationFile.h"
#include "bbtkUtilities.h"

//#include "icons/cc_new.xpm"
//#include "icons/cc_open.xpm"
//#include "icons/cc_stop.xpm"
//#include "icons/cc_save.xpm"
//#include "icons/cc_save_as.xpm"
//#include "icons/cc_run.xpm"
//#include "icons/cc_exit.xpm"

#include "../data/icons/wxart_new.xpm"
#include "../data/icons/wxart_fileopen.xpm"
#include "../data/icons/wxart_filesave.xpm"
#include "../data/icons/wxart_filesaveas.xpm"
//#include "../data/icons/wxart_exefile.xpm"
//#include "../data/icons/wxart_delete.xpm"
//#include "../data/icons/wxart_down.xpm"
#include "../data/icons/wxart_run.xpm"
#include "../data/icons/wxart_runbbi.xpm"
#include "../data/icons/wxart_graphsimple.xpm"
#include "../data/icons/wxart_graphdetail.xpm"
#include "../data/icons/wxart_eldel.xpm"

namespace bbtk
{


  //================================================================
  class WxTextCtrlGettingKeyEvents : public wxTextCtrl
  {
  public:
    WxTextCtrlGettingKeyEvents(wxWindow *parent, wxWindowID id, const wxString &value,
			       const wxPoint &pos, const wxSize &size, int style = 0)
      : wxTextCtrl(parent, id, value, pos, size, style)
    {
    }
    
    void SetWxGUITextEditor(WxGUITextEditor* e) 
    { mWxGUITextEditor = e; }
    
    void OnKeyDown(wxKeyEvent& event);
    void OnKeyUp(wxKeyEvent& event);
    void OnChar(wxKeyEvent& event);
  private :
    WxGUITextEditor* mWxGUITextEditor;
    
    DECLARE_EVENT_TABLE()
      };
  
  BEGIN_EVENT_TABLE(WxTextCtrlGettingKeyEvents, wxTextCtrl)
    EVT_KEY_DOWN(WxTextCtrlGettingKeyEvents::OnKeyDown)
    EVT_KEY_UP(WxTextCtrlGettingKeyEvents::OnKeyUp)
    EVT_CHAR(WxTextCtrlGettingKeyEvents::OnChar)
    END_EVENT_TABLE()
    
    
    void WxTextCtrlGettingKeyEvents::OnChar(wxKeyEvent& event)
  {
    event.Skip();
  }
  
  void WxTextCtrlGettingKeyEvents::OnKeyUp(wxKeyEvent& event)
  {
    mWxGUITextEditor->OnKeyUp(event);
    event.Skip();
  }
  
  void WxTextCtrlGettingKeyEvents::OnKeyDown(wxKeyEvent& event)
  {
    mWxGUITextEditor->OnKeyDown(event);
    event.Skip();
  }
  //================================================================
  
  
  //================================================================  
  /*  BEGIN_EVENT_TABLE(WxGUITextEditorPage, wxPanel)
    EVT_CLOSE(WxGUITextEditorPage::OnClose)
    END_EVENT_TABLE()
  */
 
  //================================================================
  WxGUITextEditorPage::WxGUITextEditorPage(wxWindow* parent,
					       WxGUITextEditor* editor)
    : wxPanel(parent,-1),
      mEditor(editor),
      mName(""),
      mAskFilename(true)
  {  

	  //	  std::cout << "WxGUITextEditorPage::WxGUITextEditorPage("<<mName<<")"<<std::endl;

    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
 
    mwxInputText = 
		
      new WxTextCtrlGettingKeyEvents(this,
				     -1, //ID_InputText,
				     _T(""),
				     wxDefaultPosition,
				     wxDefaultSize,
				     wxTE_MULTILINE 
				     //    |wxTE_PROCESS_ENTER
				     //| wxTE_PROCESS_TAB 
				     //		    | wxWANTS_CHARS 
				    // |  wxTAB_TRAVERSAL
				     );
    mwxInputText->SetWxGUITextEditor(mEditor);
    /*
	new wxTextCtrl(this,-1,_T(""),
		wxDefaultPosition,
					     wxDefaultSize,
					     wxTE_MULTILINE 
					     //    |wxTE_PROCESS_ENTER
					//	 | wxTE_PROCESS_TAB 
				//		    | wxWANTS_CHARS 
				 //    |  wxTAB_TRAVERSAL
				     );
					 */
    mFixedFont = new wxFont(10,
                                   wxFONTFAMILY_MODERN,
                                   wxFONTSTYLE_NORMAL,
                                   wxFONTWEIGHT_NORMAL,
                                   false);
    
    mwxInputTextAttr = new wxTextAttr;
    mwxInputTextAttr->SetFont(*mFixedFont);
   
    sizer->Add(mwxInputText,1,wxGROW);
    SetSizer(sizer);
    SetAutoLayout(true);
    Layout();
  }
  //================================================================

  //================================================================
  WxGUITextEditorPage::~WxGUITextEditorPage()
  {
	  delete mwxInputTextAttr;
	  delete mFixedFont;
  }
  //================================================================

  bool WxGUITextEditorPage::IsModified()
   { return mwxInputText->IsModified(); }

  std::string WxGUITextEditorPage::GetText()
  {
    return wx2std(GetTextCtrl()->GetValue());
  }

  //================================================================
  void WxGUITextEditorPage::Load(const std::string& filename)
  {
    //    std::cout << "-------------- LOAD ---------------"<<std::endl;
    //    std::cout << "'" << filename << "'"<<std::endl;
    //std::string oldFilename = mFilename;
    mName = filename;
    mAskFilename = false;
    mwxInputText->LoadFile(std2wx(mName));
  }
  //================================================================

  //================================================================
  void WxGUITextEditorPage::Save(const std::string& filter)
  {
    //    std::cout << "-------------- SAVE ---------------"<<std::endl;
    if (mAskFilename)
      {
	wxFileDialog* fd = new wxFileDialog(this,_T("Save file"),_T(""),
					    _T(""),std2wx(filter),
					    wxSAVE | wxOVERWRITE_PROMPT );
	int result_fd = fd->ShowModal();
    
	// This line is need it by windows // EED
	fd->SetReturnCode( result_fd );

	if (fd->GetReturnCode()==wxID_OK)
	  {
	    mName = wx2std(fd->GetPath());
	    mAskFilename = false;
	  }
	else 
	  {
	    //	    std::cout << "-------------- CANCELLED ---------------"
	    //		      <<std::endl;
	    return;
	  } 
      }
    //    std::cout << "file [" << mName << "]" <<std::endl;
//    mwxInputText->SaveFile(std2wx(mName));
	SaveFile(mName);
    mwxInputText->SetModified(false);
  }
  //================================================================
  

	//================================================================
	void WxGUITextEditorPage::SaveFile(const std::string& filename)
	{
		mwxInputText->SaveFile( std2wx(filename) );
	}
	//================================================================
	
	










  //================================================================
  // WxGUITextEditor
  //================================================================


  //================================================================
  WxGUITextEditor::WxGUITextEditor( wxWindow *parent,
				    WxGUITextEditorUser* user )
    : wxPanel(parent, -1),
      mUser(user),
      mFileNameFilter("*.*")
  {
  //  m_mgr.SetManagedWindow(this);
		    //    wxInitAllImageHandlers();
     
	//  std::cout << "WxGUITextEditor::WxGUITextEditor"<<std::endl;

      wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

    mwxNotebook = new wxNotebook(this,-1,
		wxDefaultPosition, wxDefaultSize, 
		wxNB_TOP 

		
		);
		
   sizer->Add(mwxNotebook,1,wxGROW);

		
		/*
   mwxNotebook = 		new wxAuiNotebook(this,  
				    -1,
				    wxPoint(0, 0),
				    wxSize(500,500),
				    wxAUI_NB_TAB_SPLIT 
				    | wxAUI_NB_TAB_MOVE
				    | wxAUI_NB_TAB_EXTERNAL_MOVE
				    | wxAUI_NB_WINDOWLIST_BUTTON
				    |wxAUI_NB_SCROLL_BUTTONS
				    // | wxAUI_NB_CLOSE_BUTTON 
				    | wxAUI_NB_CLOSE_ON_ACTIVE_TAB
				    //| wxAUI_NB_CLOSE_ON_ALL_TABS
				    | wxNO_BORDER);
    
    m_mgr.AddPane(mwxNotebook,
		  wxAuiPaneInfo().Name(wxT("notebook"))
		  .Caption(wxT(""))
		  .CaptionVisible(false)
		  .MinimizeButton(false)
		  .MaximizeButton(false)
		  .CloseButton(false)
		  //		  .Dockable(false).Float()
		  .Center()
		  .MinSize(wxSize(100,50))
		  );   
*/
 
    /*   
    wxBitmap bmp_new(cc_new_xpm);
    wxBitmap bmp_open(cc_open_xpm);
    wxBitmap bmp_close(cc_stop_xpm);
    wxBitmap bmp_save(cc_save_xpm);
    wxBitmap bmp_saveas(cc_save_as_xpm);
    wxBitmap bmp_run(cc_run_xpm);
    */
    wxBitmap bmp_new(new_xpm);
    wxBitmap bmp_open(fileopen_xpm);
    wxBitmap bmp_close(eldel_xpm);
    wxBitmap bmp_save(filesave_xpm);
    wxBitmap bmp_saveas(filesaveas_xpm);
    wxBitmap bmp_run(wxart_run_xpm);
    wxBitmap bmp_runbbi(wxart_runbbi_xpm);
    wxBitmap bmp_graphsimple(wxart_graphsimple_xpm);
	wxBitmap bmp_graphdetail(wxart_graphdetail_xpm);

    mwxToolBar = new wxToolBar(this, wxID_ANY, 
			       wxDefaultPosition, wxDefaultSize,
			       wxTB_FLAT | wxTB_NODIVIDER);
    
    mwxToolBar->AddTool(ID_ButtonNew, _T("New"),
                     bmp_new, wxNullBitmap, wxITEM_NORMAL,
                     _T("New file"), _T("Create a new file"));
    mwxToolBar->AddTool(ID_ButtonOpen, _T("Open"),
                     bmp_open, wxNullBitmap, wxITEM_NORMAL,
                     _T("Open file"), _T("This is help for new file tool"));
    mwxToolBar->AddTool(ID_ButtonClose, _T("Close"),
                     bmp_close, wxNullBitmap, wxITEM_NORMAL,
                     _T("Close file"), _T("Close current file"));
    mwxToolBar->AddTool(ID_ButtonSave, _T("New"),
                     bmp_save, wxNullBitmap, wxITEM_NORMAL,
                     _T("Save file"), _T("Save current file"));
    mwxToolBar->AddTool(ID_ButtonSaveAs, _T("New"),
                     bmp_saveas, wxNullBitmap, wxITEM_NORMAL,
                     _T("Save file as"), _T("Save current file as"));
    mwxToolBar->AddTool(ID_ButtonRun, _T("Run"),
                     bmp_run, wxNullBitmap, wxITEM_NORMAL,
                     _T("Run file"), _T("Run current file"));

	  
	mwxToolBar->AddTool(ID_ButtonGraphSimple, _T("Graph (simple)"),
						  bmp_graphsimple, wxNullBitmap, wxITEM_NORMAL,
						  _T("Graph simple"), _T("Simple graph of actual script"));

	mwxToolBar->AddTool(ID_ButtonGraphDetail, _T("Graph (detail)"),
						  bmp_graphdetail, wxNullBitmap, wxITEM_NORMAL,
						  _T("Graph (detail)"), _T("Detail graph of actual script"));
	  
	mwxToolBar->AddTool(ID_ButtonRunBBI, _T("Run external bbi "),
						  bmp_runbbi, wxNullBitmap, wxITEM_NORMAL,
						  _T("Run external bbi"), _T("Run external bbi"));
	  
	  
	  
    mwxToolBar->AddSeparator();
    mwxPosition = new wxStaticText ( mwxToolBar, -1, _T(""));
    mwxToolBar->AddControl(mwxPosition);
    mwxToolBar->Realize();

	  sizer->Add(mwxToolBar,0,wxGROW);

	/*
    m_mgr.AddPane(mwxToolBar, 
		  wxAuiPaneInfo().Name(wxT("toolBar"))
		  .Caption(wxT(""))
		  .ToolbarPane()
		  .Bottom()
		  .MinSize(wxSize(100,50))
		  .LeftDockable(false).RightDockable(false)
		  );   
*/
  SetSizer(sizer);
  
    
//    m_mgr.Update();
    SetAutoLayout(true);
    Layout();

    NewPage("");
    UpdateInfo();

  }
  //================================================================
  
  //================================================================
  WxGUITextEditor::~WxGUITextEditor()
  {
  //  m_mgr.UnInit();

    //    delete mInterpreter;
  }
  //================================================================

  //================================================================
  void WxGUITextEditor::NewPage(const std::string& filename)
  {
   WxGUITextEditorPage* page = 
      new WxGUITextEditorPage(mwxNotebook,this);
    std::string name("untitled");
    if (filename.size()!=0) 
      {
	name = filename;
	page->Load(name);
      }
    page->SetPageName(name);
    std::string fname = Utilities::get_file_name(name);
    mwxNotebook->AddPage(page,std2wx(fname),true);
    FocusOnCurrentPage();
  }
  //================================================================

  //================================================================
  WxGUITextEditorPage* WxGUITextEditor::GetCurrentPage()
  {
    return (WxGUITextEditorPage*)
      mwxNotebook->GetPage(mwxNotebook->GetSelection());
  }
  //================================================================

  //================================================================
  void WxGUITextEditor::FocusOnCurrentPage()
  {
    if (mwxNotebook->GetPageCount()==0) return;
    GetCurrentPage()->SetFocus();    
  }
  //================================================================

  //================================================================  
  void WxGUITextEditor::OnToolLeftClick(wxCommandEvent& event)
  {
    switch (event.GetId())
      {
      case ID_ButtonNew :
	New(); 
	FocusOnCurrentPage();
	break;
      case ID_ButtonOpen :
	Open(); 
	FocusOnCurrentPage();
	break;
      case ID_ButtonClose :
	CloseCurrentPage();
	break;
      case ID_ButtonSave :
	SaveCurrentPage();
	break;
      case ID_ButtonSaveAs :
	if (mwxNotebook->GetPageCount()==0) break;  
	GetCurrentPage()->SetAskFilename(true);
	SaveCurrentPage();
	break;
      case ID_ButtonRun :
  	if ((mUser!=0) && (mwxNotebook->GetPageCount()>0)) 
	  mUser->WxGUITextEditorRun();
	FocusOnCurrentPage();
	break;
			  
		  case ID_ButtonGraphSimple :
			  if ((mUser!=0) && (mwxNotebook->GetPageCount()>0)) 
				  mUser->WxGUITextEditorGraphSimple();
			  FocusOnCurrentPage();
			  break;

		  case ID_ButtonGraphDetail :
			  if ((mUser!=0) && (mwxNotebook->GetPageCount()>0)) 
				  mUser->WxGUITextEditorGraphDetail();
			  FocusOnCurrentPage();
			  break;
			  
		  case ID_ButtonRunBBI :
			  if ((mUser!=0) && (mwxNotebook->GetPageCount()>0)) 
				  mUser->WxGUITextEditorRunBBI();
			  FocusOnCurrentPage();
			  break;
			  
      }
  }
  //================================================================  

  //================================================================  
  void WxGUITextEditor::OnToolRightClick(wxCommandEvent& event)
  {
  }
  //================================================================  

  //================================================================  
  void WxGUITextEditor::New()
  {
    NewPage("");
    UpdateInfo();
  }
  //================================================================

  //================================================================  
  void WxGUITextEditor::Open()
  {
    //    std::cout << "-------------- OPEN ---------------"<<std::endl;

    wxFileDialog* fd = new wxFileDialog(this,_T("Open file"),_T(""),
					_T(""),std2wx(mFileNameFilter),
					wxOPEN | wxFILE_MUST_EXIST );
    int result_fd = fd->ShowModal();

	// This line is need it by windows //EED
	fd->SetReturnCode( result_fd );

    if (fd->GetReturnCode()==wxID_OK)
      {
	std::string filename = wx2std(fd->GetPath());
	std::cout << "file [" << filename << "]" <<std::endl;
	Open(filename);
      }
    else 
      {
	//	std::cout << "-------------- CANCELLED ---------------"<<std::endl;
      }
  }
  //================================================================  
  
  //================================================================  
  void WxGUITextEditor::Open(const std::string& filename)
  {
    NewPage(filename);
    UpdateInfo();
  }
  //================================================================  


  //================================================================  
  bool WxGUITextEditor::CloseCurrentPage()
  {
    if (mwxNotebook->GetPageCount()==0) return true;

    if (GetCurrentPage()->IsModified()) 
      {
	wxString mess = std2wx(GetCurrentPage()->GetPageName());
	mess += _T(" modified. Save it ?");
	wxMessageDialog* d = 
	  new wxMessageDialog(this,
			      mess, 
			      _T("Save buffer"), 
			      wxYES_NO | wxCANCEL | wxICON_QUESTION);
	switch (d->ShowModal())
	  {
	  case wxID_CANCEL : 
	    return false;
	    break;
	  case wxID_YES : 
	    GetCurrentPage()->Save(mFileNameFilter); 
	    break;
	  case wxID_NO : ;
	  }       
      } 
    mwxNotebook->DeletePage(mwxNotebook->GetSelection());
    FocusOnCurrentPage();
    return true;
  }
  //================================================================  

  //================================================================  
  bool WxGUITextEditor::CloseAllPages()
  {
    bool ok = true;
    while (mwxNotebook->GetPageCount()!=0)
      {
	if (!CloseCurrentPage()) 
	  {
	    ok = false;
	    break;
	  }
      }
    return ok;
  }
  //================================================================  

  //================================================================  
  void WxGUITextEditor::SaveCurrentPage()
  {
    if (mwxNotebook->GetPageCount()==0) return;  
    GetCurrentPage()->Save(mFileNameFilter);
    mwxNotebook->SetPageText(mwxNotebook->GetSelection(),
			     std2wx(GetCurrentPage()->GetPageName()));
  }
  //================================================================  


  //================================================================  
  void WxGUITextEditor::OnPageClose(wxAuiNotebookEvent& evt)
  {
    if (!CloseCurrentPage()) evt.Veto();
  }
  //================================================================



  /*
  //================================================================  
  void WxGUITextEditor::OnButtonQuit(wxCommandEvent& event) 
  { 
    Quit(); 
    FocusOnCurrentPage();
  }
  void WxGUITextEditor::Quit()
  {
    std::cout << "-------------- QUIT ---------------"<<std::endl;
    if (AskSave()) GetParent()->Close();
  }
  //================================================================  
  */

  //================================================================  

  /*
  void WxGUITextEditor::Run()
  {
    std::cout << "-------------- RUN ---------------"<<std::endl;

    if (!mwxSplit->IsSplit()) 
      {
	int size = -100;
	int minsize = - (int)(mwxInputText->GetSize().GetHeight() / 2.);
	if (size<minsize) size = minsize;
	mwxSplit->SplitHorizontally( mwxInputText, mwxOutputText, size);
      }

    std::stringstream* buffer = new std::stringstream(bbtk::wx2std(mwxInputText->GetValue()));
    mInterpreter->InterpretLine("reset");
    try 
      {
	mInterpreter->InterpretBuffer(buffer);
      }
    catch (...)
      {
      }
  } 
  //================================================================  
*/
  
 
  
  //================================================================
  

  //================================================================
  void WxGUITextEditor::UpdateInfo()
  {
    if (mwxNotebook->GetPageCount()==0) return;
    WxTextCtrlGettingKeyEvents* text = GetCurrentPage()->GetTextCtrl();
    
    long line, column, pos;
    pos = text->GetInsertionPoint();
    text->PositionToXY(pos, &column, &line);
    
    
    //                wxLogMessage(_T("Current position: %ld\nCurrent line, column: (%ld, %ld)\nNumber of lines: %ld\nCurrent line length: %ld\nTotal text length: %u (%ld)"),
    
    
    char mess[200];
    sprintf(mess,"%ld:%ld/%ld:%ld",
	    line+1,column+1,
	    (long)text->GetNumberOfLines(),
	    (long)text->GetLineLength(line)+1);
    //	     pos+1,
    //	     (long)mwxInputText->GetValue().length())+1;
    
   // mwxPosition->SetLabel(wxString(mess));
    mwxPosition->SetLabel(std2wx(mess));    
    mwxPosition->Show();
    
    if (text->IsModified()) 
      {
	std::string title("*");
	title += GetCurrentPage()->GetPageName();
	mwxNotebook->SetPageText(mwxNotebook->GetSelection(),std2wx(title));
      }
  }
  //================================================================
  //================================================================
  void WxGUITextEditor::OnKeyUp(wxKeyEvent& event)
  {
  //    std::cout << "U" << std::endl;
    UpdateInfo();
  }
  //================================================================

  //================================================================
  void WxGUITextEditor::OnKeyDown(wxKeyEvent& event)
  {
     //   std::cout << "D" << std::endl;
    // std::cout << "Key="<<event.GetKeyCode()<<std::endl;
    if ( event.ControlDown() )
      {
	switch (event.GetKeyCode())
	  {
	  case 'n': case 'N' : New(); break;
	  case 's': case 'S' : SaveCurrentPage(); break;
	  case 'o': case 'O' : Open(); break;
	    //	  case 'r': case 'R' : Run(); break;
	    //	  case 'q': case 'Q' : Quit(); break;
	  }
      }
  }
  //================================================================
  
  //================================================================  
  BEGIN_EVENT_TABLE(WxGUITextEditor, wxPanel)
    EVT_MENU(wxID_ANY,  WxGUITextEditor::OnToolLeftClick)
    EVT_TOOL_RCLICKED(wxID_ANY,  WxGUITextEditor::OnToolRightClick)
    EVT_AUINOTEBOOK_PAGE_CLOSE(wxID_ANY, WxGUITextEditor::OnPageClose)
    END_EVENT_TABLE()
  //================================================================
    



  
  //================================================================
  WxGUITextEditorWindow::WxGUITextEditorWindow( wxWindow *parent, 
						    wxString title, 
						    wxSize size)
    : wxFrame((wxFrame *)parent, -1, title, wxDefaultPosition, size)
  {	
    
    
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

    mEditor = new WxGUITextEditor(this);
    sizer->Add(mEditor,1,wxGROW);
    
    //    WxGUICommand* com = new WxGUICommand(this,this);
    //    sizer->Add(com);
    
    SetSizer(sizer);

    // parent window of all bbtk windows will be a child of this
    //    Wx::SetTopWindowParent(this);
    Wx::SetTopWindow(this);
    // Add the method OnWxSignal as a Wx::Signal observer 
    //bbtkAddWxSignalObserver(WxGUITextEditorWindow::OnWxSignal);
    
   
    SetAutoLayout(true);
    Layout();
  }
  //================================================================

  //================================================================
  WxGUITextEditorWindow::~WxGUITextEditorWindow()
  {
  }
  //================================================================


} // namespace bbtk


#endif //_USE_WXWIDGETS_
