/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifdef USE_KWWIDGETS

#include "vtkKWBlackBoxDialog.h"
#include "bbtkKW.h"
#include "vtkObjectFactory.h"

  //=========================================================================
  // vtkKWBlackBoxWindow
  //=========================================================================


/*
  //=========================================================================
  vtkKWBlackBoxWindow::vtkKWBlackBoxWindow()
    : mShown(false)
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxWindow::vtkKWBlackBoxWindow()"
		     <<std::endl);
    bbtk::KW::IncNbWindowsAlive();
  }
  //=========================================================================



  //=========================================================================
  vtkKWBlackBoxWindow::~vtkKWBlackBoxWindow()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxWindow::~vtkKWBlackBoxWindow() "
		     <<this<<std::endl);
    bbHide();
    bbtk::KW::DecNbWindowsAlive();
    if (!mBox.expired())
      {
	mBox.lock()->bbSetWindow(0);
      }
  }
  //========================================================================= 


  //=========================================================================
  void vtkKWBlackBoxWindow::bbShow()
  {
    if (bbIsShown()) return;
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxWindow::bbShow()"<<std::endl);
    bbtk::KW::IncNbWindowsShown();
    mShown = true;
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxWindow::bbHide()
  {
    if (!bbIsShown()) return;
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxWindow::bbHide()"<<std::endl);
    bbtk::KW::DecNbWindowsShown();
    mShown = false;
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxWindow::bbClose()
  {
  }
  //=========================================================================

*/
  //=========================================================================
  // vtkKWBlackBoxDialog
  //=========================================================================
  
  //-------------------------------------------------------------------------
  vtkStandardNewMacro( vtkKWBlackBoxDialog );
  vtkCxxRevisionMacro( vtkKWBlackBoxDialog, "$Revision: 1.4 $");
  //-------------------------------------------------------------------------

  //=========================================================================
vtkKWBlackBoxDialog::vtkKWBlackBoxDialog() 
  : mShown(false)
{
  bbtkDebugMessage("kw",9,"vtkKWBlackBoxDialog::vtkKWBlackBoxDialog()"
		   <<std::endl);
  bbtk::KW::IncNbWindowsAlive();
  this->mFrame = vtkKWFrame::New();
}
//=========================================================================
  //=========================================================================
  vtkKWBlackBoxDialog::~vtkKWBlackBoxDialog()
  {
    bbtkDebugMessage("kw",9,"~vtkKWBlackBoxDialog()"<<std::endl);
    this->mFrame->Delete();
    bbHide();
    bbtk::KW::DecNbWindowsAlive();
    if (!mBox.expired())
      {
	mBox.lock()->bbSetWindow(0);
      }
  }
  //=========================================================================

//=========================================================================
void vtkKWBlackBoxDialog::CreateWidget()
{
  bbtkDebugMessage("kw",5,"vtkKWBlackBoxDialog::CreateWidget() ["
		   <<bbGetBlackBox()->bbGetFullName()<<"]"<<std::endl);
  if (this->IsCreated())
    {
      vtkErrorMacro("vtkKWBlackBoxDialog already created");
      return;
    }
  
  this->Superclass::CreateWidget();
  
  this->SetTitle((bbGetBlackBox()->bbGetInputWinTitle()+"            - bbtk (c) CREATIS").c_str());

  this->mFrame->SetParent(this);
  this->mFrame->Create();
  this->mFrame->SetWidth ( bbGetBlackBox()->bbGetInputWinWidth() );
  this->mFrame->SetHeight ( bbGetBlackBox()->bbGetInputWinHeight() );

  this->Script("pack %s -side top -expand true",
               this->mFrame->GetWidgetName());
}
//=========================================================================

/*
//=========================================================================
void vtkKWBlackBoxDialog::Pack()
{
  this->Script("pack %s -side top -expand true",
               this->mFrame->GetWidgetName());
}
//=========================================================================
*/
 //=========================================================================
  void vtkKWBlackBoxDialog::Cancel()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxDialog::Cancel()"<<std::endl);
    //    this->Delete();

    //    this->Withdraw();
    bbHide();
    this->Done = vtkKWDialog::StatusCanceled;
    //    std::cout << "REFS= "<<this->GetReferenceCount()<<std::endl;
    //    std::cout << "WINS= "<<this->GetApplication()->GetNumberOfWindows ()<<std::endl;
    //    this->Delete();
    
  }
  //=========================================================================
  
 
//=========================================================================
  void vtkKWBlackBoxDialog::bbShow()
  { 
    if (bbIsShown()) return;
    bbtkDebugMessage("kw",5,"vtkKWBlackBoxDialog::bbShow() ["
		     <<bbGetBlackBox()->bbGetFullName()<<"]"<<std::endl);
    bbtk::KW::IncNbWindowsShown();
    mShown = true;
    //    vtkKWBlackBoxWindow::bbShow();
    //SetReturnCode( kwDialog::ShowModal() ); 
    this->Display();
    this->Invoke();
    //    bbClose();
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxDialog::bbHide()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxDialog::bbHide()"<<std::endl);
    // vtkKWBlackBoxWindow::bbHide();
    bbtk::KW::DecNbWindowsShown();
    mShown = false;
    //    Hide();
    this->Withdraw(); 
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxDialog::bbClose()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxDialog::bbClose()"<<std::endl);
    this->Done = vtkKWDialog::StatusCanceled;
    // this->Withdraw();  //   this->Delete();
  }
  //=========================================================================



/*


  //=========================================================================
  // vtkKWBlackBoxFrame
  //=========================================================================

  //-------------------------------------------------------------------------
  vtkStandardNewMacro( vtkKWBlackBoxFrame );
  vtkCxxRevisionMacro(vtkKWBlackBoxFrame, "$Revision: 1.4 $");
  //-------------------------------------------------------------------------
  //=========================================================================
  vtkKWBlackBoxFrame::vtkKWBlackBoxFrame()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxFrame::vtkKWBlackBoxFrame()"<<std::endl);
  }
  //=========================================================================
  
  //=========================================================================
  vtkKWBlackBoxFrame::~vtkKWBlackBoxFrame()
  {
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxFrame::bbShow() 
  { 
    if (bbIsShown()) return;
    bbtkDebugMessage("kw",5,"vtkKWBlackBoxFrame::bbShow("
		     <<bbGetBlackBox()->bbGetFullName()<<")"<<std::endl);
    vtkKWBlackBoxWindow::bbShow();
    // vtkKWFrame::Show();
    this->Display();
    // This Update is ** MANDATORY ** 
    // to synchronize kwvtkRenderWindowInteractor objects
    // (force kw objects creation **NOW**)
 
    if (bbGetBlackBox()) bbGetBlackBox()->bbUserOnShow();
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxFrame::bbHide()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxFrame::bbHide()"<<std::endl);
    vtkKWBlackBoxWindow::bbHide();
    //  vtkKWFrame::Hide();
    this->Withdraw();
    if (bbGetBlackBox()) bbGetBlackBox()->bbUserOnHide();
  }
  //=========================================================================

  //=========================================================================
  void vtkKWBlackBoxFrame::bbClose()
  {
    bbtkDebugMessage("kw",9,"vtkKWBlackBoxFrame::bbClose()"<<std::endl);
    //    vtkKWFrame::Close();
    this->Delete();
  }
  //=========================================================================
  */
#endif
