/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbgdcmvtkGetInfoGdcmReader.h"
#include "bbgdcmvtkPackage.h"

#if defined USE_GDCM
	#include "gdcmFile.h"
	#include "gdcmFileHelper.h"
	#include "vtkImageData.h"
	#include "vtkGdcmReader.h"
#endif
#if defined USE_GDCM2
	#include <gdcmReader.h>
//	#include "vtkImageData.h"	
	#include <gdcmImageHelper.h>
	#include <vtkGDCMImageReader.h>
#endif
#include <vtkIndent.h>

namespace bbgdcmvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(gdcmvtk,GetInfoGdcmReader)
BBTK_BLACK_BOX_IMPLEMENTATION(GetInfoGdcmReader,bbtk::AtomicBlackBox);

#if defined USE_GDCM
void GetInfoGdcmReader::Process()
{
	// Reset de reader, f
	bbUserFinalizeProcessing();
	
   f = GDCM_NAME_SPACE::File::New();
   f->SetFileName( bbGetInputIn() );
   bool res = f->Load();  
   if ( !res )
   {
      f->Delete();
      bbSetOutputOut(0);
      return;
   }
 // Get info from THE image file (only *one* as input)
   int i;
   std::vector<double> v_iop;
   float iop[6];
   f->GetImageOrientationPatient(iop);
   
   for(i=0; i< 6; i++)
      v_iop.push_back(iop[i]);
   bbSetOutputIOP(v_iop );
 
   std::vector<double> v_ipp;
   float ipp[3];
   f->GetImagePositionPatient(ipp);
   
   for(i=0; i< 3; i++)
      v_ipp.push_back(ipp[i]);
   bbSetOutputIPP(v_ipp );

   std::vector<double> v_pixelspacing;
   v_pixelspacing.push_back(f->GetXSpacing());
   v_pixelspacing.push_back(f->GetYSpacing());
   
   if (f->GetZSize() != 1) 
   {
      v_pixelspacing.push_back(f->GetZSpacing());
   }
   bbSetOutputPixelSpacing(v_pixelspacing);
   
   //double interslice;
    bbSetOutputInterSlice(f->GetZSpacing());
   
   reader = vtkGdcmReader::New();
   reader->SetFileName( bbGetInputIn().c_str() );
   reader->Update();
   reader->GetOutput();

   vtkIndent indent ;
   reader->GetOutput()->PrintSelf(std::cout, indent);
   bbSetOutputOut( reader->GetOutput() );
}
#endif

#if defined USE_GDCM2
void GetInfoGdcmReader::Process()
{
	// Reset de reader, f
	bbUserFinalizeProcessing();
	gdcm::Reader *read = new gdcm::Reader();
	read->SetFileName( bbGetInputIn().c_str());
  
	bool res = read->Read();  
   if ( !res )
   {
      delete read;
      bbSetOutputOut(0);
      return;
   }
   
 // Get info from THE image file (only *one* as input)
   const gdcm::File &f = read->GetFile();
   
   // Image Orientation (Patient)
   int i;
   std::vector<double> v_iop;
   const gdcm::DataElement &deIop = f.GetDataSet().GetDataElement(gdcm::Tag(0x0020, 0x0037));
   std::stringstream ss;
   deIop.GetValue().Print(ss);
   gdcm::Element<gdcm::VR::DS,gdcm::VM::VM6> iop;
   iop.Read( ss );
   for(i=0; i< 6; i++)
      v_iop.push_back((float)(iop[i]));
   bbSetOutputIOP(v_iop );
 
   // Image Position (Patient)
   std::vector<double> v_ipp;
   const gdcm::DataElement &deIpp = f.GetDataSet().GetDataElement(gdcm::Tag((0x0020,0x0032)));
   deIpp.GetValue().Print(ss);
   gdcm::Element<gdcm::VR::DS,gdcm::VM::VM3> ipp;
   ipp.Read( ss );
	  for(i=0; i< 3; i++)
		v_ipp.push_back((float)(ipp[i]));
   bbSetOutputIPP(v_ipp );

   std::vector<double> v_pixelspacing = gdcm::ImageHelper::GetSpacingValue(f);
   bbSetOutputPixelSpacing(v_pixelspacing);
   
   //double interslice; ?? ==1 NO?
    bbSetOutputInterSlice(v_pixelspacing[2]);
   
   reader = vtkGDCMImageReader::New();
   reader->SetFileName( bbGetInputIn().c_str() );
   reader->Update();
   reader->GetOutput();
   vtkIndent indent ;
   reader->GetOutput()->PrintSelf(std::cout, indent);
   bbSetOutputOut( reader->GetOutput() );
}
#endif


void GetInfoGdcmReader::bbUserSetDefaultValues()
{
#if defined USE_GDCM2
   reader=NULL;
#endif   
#if defined USE_GDCM
   reader=NULL;
   f=NULL;
#endif
   bbSetInputIn("");  
}


void GetInfoGdcmReader::bbUserInitializeProcessing()
{
}


void GetInfoGdcmReader::bbUserFinalizeProcessing()
{
#if defined USE_GDCM2
   if( reader )
   {
      reader->Delete();
      reader=NULL;
   }
#endif

#if defined USE_GDCM	
   if( reader )
   {
      reader->Delete();
      reader=NULL;
   }   

   if(f)
   {
      f->Delete();
      f=NULL;
   }	
#endif
}
}

// EO namespace bbgdcmvtk


