/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "bbgdcmvtkGetXCoherentInfoGdcmReader.h"
#include "bbgdcmvtkPackage.h"

#include "gdcmFile.h"
#include "vtkImageData.h"
#include <vtkIndent.h>

#if defined USE_GDCM
	#include "gdcmFileHelper.h"
#endif

#if defined USE_GDCM2
	#include <gdcmReader.h>
	#include <gdcmImageHelper.h>
	#include <gdcmIPPSorter.h>
	#include <vtkGDCMImageReader.h>
	#include "vtkStringArray.h"
#endif

namespace bbgdcmvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(gdcmvtk,GetXCoherentInfoGdcmReader)
BBTK_BLACK_BOX_IMPLEMENTATION(GetXCoherentInfoGdcmReader,bbtk::AtomicBlackBox);
#if defined USE_GDCM
void GetXCoherentInfoGdcmReader::Process()
{
 // Read the *first* image file (a SET of file names is given as input) 
   f = GDCM_NAME_SPACE::File::New();
   f->SetFileName( bbGetInputIn()[0] );
   bool res = f->Load();  
   if ( !res )
   {
      f->Delete();
      bbSetOutputOut(0);
      return;
   }
 // Get info from the first image file
   int i;
   std::vector<double> v_iop;
   float iop[6];
   f->GetImageOrientationPatient(iop);
   
   for(i=0; i< 6; i++)
      v_iop.push_back(iop[i]);
   bbSetOutputIOP(v_iop );
 
   std::vector<double> v_ipp;
   float ipp[3];
   f->GetImagePositionPatient(ipp);
   
   for(i=0; i< 3; i++)
      v_ipp.push_back(ipp[i]);
   bbSetOutputIPP(v_ipp );

// Add *all the files* to the SerieHelper
   sh = GDCM_NAME_SPACE::SerieHelper::New();
   std::vector<std::string> gii = bbGetInputIn();
   
   for(std::vector<std::string>::iterator it = gii.begin();
                                          it != gii.end();
                                        ++it)
   {
      sh->AddFileName(*it);
   }

   GDCM_NAME_SPACE::FileList::const_iterator it;
   GDCM_NAME_SPACE::FileList *l;

   // Should only contain one!
   l = sh->GetFirstSingleSerieUIDFileSet();

   int nbFiles;
   double zspacing = 0.;
   nbFiles = l->size() ;
   sh->OrderFileList(l); // this one should compute the *actual* Z Spacing!
   zspacing = sh->GetZSpacing();
   std::vector<double> v_pixelspacing;
   v_pixelspacing.push_back( f->GetXSpacing() );
   v_pixelspacing.push_back( f->GetYSpacing() );
   v_pixelspacing.push_back( zspacing );
//   if (f->GetZSize() != 1) {
//      v_pixelspacing.push_back(f->GetZSpacing());
//   }
   bbSetOutputPixelSpacing(v_pixelspacing);

   if (reader!=NULL)
   { 
      reader->Delete();
      reader=NULL;
   }
   reader = vtkGdcmReader::New();
	
	//EED 21 mars 2012  FLIP probleme  ..PLOP..
	reader->SetFlipY(false);

	
   //reader->SetFileName( bbGetInputIn().c_str() );
   reader->SetCoherentFileList(l);
   reader->Update();
   reader->GetOutput();

   bbSetOutputOut( reader->GetOutput() );
}
#endif
// endif USE_GDCM

#if defined USE_GDCM2
void GetXCoherentInfoGdcmReader::Process()
{
 // Read the *first* image file (a SET of file names is given as input) 
	gdcm::Reader *read = new gdcm::Reader();
	reader->SetFileName( bbGetInputIn()[0].c_str());
  
	bool res = read->Read();  
   if ( !res )
   {
      delete read;
      bbSetOutputOut(0);
      return;
   }
    
 // Get info from the first image file
   const gdcm::File &f = read->GetFile();
   int i;
   std::vector<double> v_iop;
   const gdcm::DataElement &deIop = f.GetDataSet().GetDataElement(gdcm::Tag(0x0020, 0x0037));
   std::stringstream ss;
   deIop.GetValue().Print(ss);
   gdcm::Element<gdcm::VR::DS,gdcm::VM::VM6> iop;
   iop.Read( ss );
   for(i=0; i< 6; i++)
      v_iop.push_back((float)(iop[i]));
   bbSetOutputIOP(v_iop );
 
  std::vector<double> v_ipp;
   const gdcm::DataElement &deIpp = f.GetDataSet().GetDataElement(gdcm::Tag((0x0020,0x0032)));
   deIpp.GetValue().Print(ss);
   gdcm::Element<gdcm::VR::DS,gdcm::VM::VM3> ipp;
   ipp.Read( ss );
	  for(i=0; i< 3; i++)
		v_ipp.push_back((float)(ipp[i]));
   bbSetOutputIPP(v_ipp );

// Add *all the files* to the IPPsorter
     gdcm::IPPSorter s;
	 s.SetComputeZSpacing( true );
     s.SetZSpacingTolerance( 1e-3 );
     std::vector<std::string> gii = bbGetInputIn();
     s.Sort(gii);

	 //l = sh->GetFirstSingleSerieUIDFileSet();
	 // no Test if we have multiple series
	 //s.GetFilenames();
  	 //int nbFiles;

	double zspacing = 0.;
	zspacing = s.GetZSpacing();
	std::vector<double> v_pixelspacing = gdcm::ImageHelper::GetSpacingValue(f);
	v_pixelspacing.push_back( v_pixelspacing[0] );
	v_pixelspacing.push_back( v_pixelspacing[1] );
	v_pixelspacing.push_back( zspacing );
	bbSetOutputPixelSpacing(v_pixelspacing);

   if (reader!=NULL)
   { 
      reader->Delete();
      reader=NULL;
   }
   reader = vtkGDCMImageReader::New();
   vtkStringArray *files = vtkStringArray::New();
   std::vector< std::string >::const_iterator it = s.GetFilenames().begin();
   for( ; it != s.GetFilenames().end(); ++it)
   {
	  const std::string &f = *it;
      files->InsertNextValue( f.c_str() );
   }
   reader->SetFileNames(files);
   reader->Update();
   reader->GetOutput();
   bbSetOutputOut( reader->GetOutput() );
}
#endif
// endif USE_GDCM2

void GetXCoherentInfoGdcmReader::bbUserSetDefaultValues()
{
   std::vector<std::string> init;
   init.push_back("");
   bbSetInputIn(init);  
   //reader=NULL;   /// \TODO fixme JPR
}

void GetXCoherentInfoGdcmReader::bbUserInitializeProcessing()
{
	
}

#if defined USE_GDCM
void GetXCoherentInfoGdcmReader::bbUserFinalizeProcessing()
{
   if(reader)
      reader->Delete();
   if(f)
      f->Delete();
   if(sh)
      sh->Delete();      
}
#endif

#if defined USE_GDCM2
void GetXCoherentInfoGdcmReader::bbUserFinalizeProcessing()
{
   if(reader)
      reader->Delete();
}
#endif

}
// EO namespace bbgdcmvtk
