/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkAnyImageToTypedImage.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.5 $
=========================================================================*/




#ifdef _USE_ITK_
#include "bbitkAnyImageToTypedImage.h"
#include "bbitkPackage.h"

namespace bbitk
{
  //====================================================================
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(AnyImageToTypedImage,
					      bbtk::AtomicBlackBox);
  BBTK_BLACK_BOX_TEMPLATE2_IMPLEMENTATION(AnyImageToConstTypedImage,
					       bbtk::AtomicBlackBox);
  //====================================================================
  

#ifdef BBTK_ITK_IMAGE_DIM_2
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int8_t_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int16_t_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int32_t_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint8_t_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint16_t_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint32_t_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_float_2_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_double_2_ptr);
#  endif
#endif



#ifdef BBTK_ITK_IMAGE_DIM_3
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int8_t_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int16_t_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int32_t_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint8_t_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint16_t_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint32_t_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_float_3_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_double_3_ptr);
#  endif
#endif




#ifdef BBTK_ITK_IMAGE_DIM_4
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int8_t_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int16_t_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_int32_t_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint8_t_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint16_t_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_uint32_t_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_float_4_ptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(itk,AnyImageToTypedImage,Image_double_4_ptr);
#  endif
#endif


#ifdef BBTK_ITK_IMAGE_DIM_2
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int8_t_2_ptr,Image_int8_t_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int16_t_2_ptr,Image_int16_t_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int32_t_2_ptr,Image_int32_t_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint8_t_2_ptr,Image_uint8_t_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint16_t_2_ptr,Image_uint16_t_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint32_t_2_ptr,Image_uint32_t_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_float_2_ptr,Image_float_2_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_double_2_ptr,Image_double_2_cptr);
#  endif
#endif

#ifdef BBTK_ITK_IMAGE_DIM_3
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int8_t_3_ptr,Image_int8_t_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int16_t_3_ptr,Image_int16_t_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int32_t_3_ptr,Image_int32_t_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint8_t_3_ptr,Image_uint8_t_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint16_t_3_ptr,Image_uint16_t_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint32_t_3_ptr,Image_uint32_t_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_float_3_ptr,Image_float_3_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_double_3_ptr,Image_double_3_cptr);
#  endif
#endif

#ifdef BBTK_ITK_IMAGE_DIM_4
#  ifdef BBTK_ITK_IMAGE_TYPE_int8_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int8_t_4_ptr,Image_int8_t_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int16_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int16_t_4_ptr,Image_int16_t_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_int32_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_int32_t_4_ptr,Image_int32_t_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint8_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint8_t_4_ptr,Image_uint8_t_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint16_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint16_t_4_ptr,Image_uint16_t_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_uint32_t 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_uint32_t_4_ptr,Image_uint32_t_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_float
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_float_4_ptr,Image_float_4_cptr);
#  endif
#  ifdef BBTK_ITK_IMAGE_TYPE_double
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(itk,AnyImageToConstTypedImage,Image_double_4_ptr,Image_double_4_cptr);
#  endif
#endif


}
#endif
