/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkBinaryThresholdImageFilter.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.14 $
=========================================================================*/

/* ---------------------------------------------------------------------

* Copyright (c) CREATIS-LRMN (Centre de Recherche en Imagerie Medicale)
* Authors : Eduardo Davila, Laurent Guigues, Jean-Pierre Roux
*
*  This software is governed by the CeCILL-B license under French law and 
*  abiding by the rules of distribution of free software. You can  use, 
*  modify and/ or redistribute the software under the terms of the CeCILL-B 
*  license as circulated by CEA, CNRS and INRIA at the following URL 
*  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
*  or in the file LICENSE.txt.
*
*  As a counterpart to the access to the source code and  rights to copy,
*  modify and redistribute granted by the license, users are provided only
*  with a limited warranty  and the software's author,  the holder of the
*  economic rights,  and the successive licensors  have only  limited
*  liability. 
*
*  The fact that you are presently reading this means that you have had
*  knowledge of the CeCILL-B license and that you accept its terms.
* ------------------------------------------------------------------------ */                                                                         


#ifdef _USE_ITK_

#include "bbtkAtomicBlackBox.h"
#include "itkBinaryThresholdImageFilter.h"
#include "bbtkItkBlackBoxMacros.h"
#include "bbitkImage.h"

namespace bbitk
{

  //===================================================
  template <class T>
  class /*BBTK_EXPORT*/ BinaryThresholdImageFilter
    : 
    public bbtk::AtomicBlackBox,
    public itk::BinaryThresholdImageFilter<T,T>
  {
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(BinaryThresholdImageFilter,
				      bbtk::AtomicBlackBox,T);
    typedef itk::BinaryThresholdImageFilter<T,T> itkParent;
    BBTK_DECLARE_ITK_INPUT(In,const T*);
    BBTK_DECLARE_ITK_PARAM(LowerThreshold,typename T::PixelType);
    BBTK_DECLARE_ITK_PARAM(UpperThreshold,typename T::PixelType);
    BBTK_DECLARE_ITK_PARAM(InsideValue,typename T::PixelType);
    BBTK_DECLARE_ITK_PARAM(OutsideValue,typename T::PixelType);
    BBTK_DECLARE_ITK_OUTPUT(Out,T*);
    BBTK_ITK_PROCESS();
    BBTK_ITK_DELETE();

  };
  //===================================================
  
  //===================================================
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(BinaryThresholdImageFilter,
				      bbtk::AtomicBlackBox);
  BBTK_NAME("BinaryThresholdImageFilter<"+bbtk::TypeName<T>()+">");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Binarizes an image by thresholding (bbification of itk::BinaryThresholdImageFilter)");
  BBTK_TEMPLATE_INPUT(BinaryThresholdImageFilter,In,"Input image",const T*);
  BBTK_TEMPLATE_INPUT(BinaryThresholdImageFilter,LowerThreshold,
		      "Lower threshold",typename T::PixelType);
  BBTK_TEMPLATE_INPUT(BinaryThresholdImageFilter,UpperThreshold,
		      "Upper threshold",typename T::PixelType);
  BBTK_TEMPLATE_INPUT(BinaryThresholdImageFilter,InsideValue,
		      "Output value for pixels inside thresholds",
		      typename T::PixelType);
  BBTK_TEMPLATE_INPUT(BinaryThresholdImageFilter,OutsideValue,
		      "Output value for pixels outside thresholds",
		      typename T::PixelType);
  BBTK_TEMPLATE_OUTPUT(BinaryThresholdImageFilter,Out,"Output image",T*);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(BinaryThresholdImageFilter);
  //===================================================


  //===================================================
  //--
  template <class T>
  void BinaryThresholdImageFilter<T>::bbUserSetDefaultValues()
  {
    bbSetInputLowerThreshold(0);
    bbSetInputUpperThreshold(100);
    bbSetInputInsideValue(255);
    bbSetInputOutsideValue(0);
  }
  template <class T>
  void BinaryThresholdImageFilter<T>::bbUserInitializeProcessing()
  {
  }	
  template <class T>
  void BinaryThresholdImageFilter<T>::bbUserFinalizeProcessing()
  {
  }
  
  //===================================================










  
  //===================================================
  // Generic "untemplatized" filter
  //===================================================
  class /*BBTK_EXPORT*/ BinaryThresholdImageFilterGeneric
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(BinaryThresholdImageFilterGeneric,
				  bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,anyImagePointer);
    BBTK_DECLARE_INPUT(LowerThreshold,double);
    BBTK_DECLARE_INPUT(UpperThreshold,double);
    BBTK_DECLARE_INPUT(InsideValue,double);
    BBTK_DECLARE_INPUT(OutsideValue,double);
    BBTK_DECLARE_OUTPUT(Out,anyImagePointer);
    BBTK_PROCESS(ProcessSwitch);
  private :
    inline void ProcessSwitch();
    template <class T> void Process();
  };
  //===================================================

  
  //===================================================

  BBTK_BEGIN_DESCRIBE_BLACK_BOX(BinaryThresholdImageFilterGeneric,
				bbtk::AtomicBlackBox);
  BBTK_NAME("BinaryThresholdImageFilter");
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_CATEGORY("filter;image");
  BBTK_DESCRIPTION("Binarizes an image by thresholding (generic bbification of itk::BinaryThresholdImageFilter)");
  BBTK_INPUT(BinaryThresholdImageFilterGeneric,In,
	     "Input image. Can be any itk::Image<T,D>*",anyImagePointer,"");
  BBTK_INPUT(BinaryThresholdImageFilterGeneric,LowerThreshold,
	     "Lower threshold",double,"");
  BBTK_INPUT(BinaryThresholdImageFilterGeneric,UpperThreshold,
	     "Upper threshold",double,"");
  BBTK_INPUT(BinaryThresholdImageFilterGeneric,InsideValue,
	     "Output value for pixels inside thresholds",double,"");
  BBTK_INPUT(BinaryThresholdImageFilterGeneric,OutsideValue,
	     "Output value for pixels outside thresholds",double,"");
  BBTK_OUTPUT(BinaryThresholdImageFilterGeneric,Out,
	      "Output image. Of the same type and dimension than the input image",
	      anyImagePointer,"");
  BBTK_END_DESCRIBE_BLACK_BOX(BinaryThresholdImageFilterGeneric);
  //===================================================




  //===================================================

  void BinaryThresholdImageFilterGeneric::ProcessSwitch()
  {
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(bbGetInputIn().type(), this->Process);
  }
  //===================================================


  //===================================================

  template <class T> 
  void BinaryThresholdImageFilterGeneric::Process()
  {
printf("EED BinaryThresholdImageFilterGeneric::Process Start\n");
    bbtkDebugMessageInc("Core",9,
			"bbitk::BinaryThresholdImageFilterGeneric::Process<"
			<<bbtk::TypeName<T>()<<">()"<<std::endl);
 
    typedef BinaryThresholdImageFilter<T> FilterType;
    typename FilterType::Pointer f = FilterType::New("Temp");
	  typedef T* TPointer; 
	  f->bbSetInputIn( this->bbGetInputIn().get < TPointer > () );
    f->bbSetInputLowerThreshold ( (typename T::PixelType)
				  this->bbGetInputLowerThreshold() );
    f->bbSetInputUpperThreshold ( (typename T::PixelType)
				  this->bbGetInputUpperThreshold() );
    f->bbSetInputInsideValue ( (typename T::PixelType)
			       this->bbGetInputInsideValue() );
    f->bbSetInputOutsideValue ( (typename T::PixelType)
				this->bbGetInputOutsideValue() );
    f->bbExecute();
    f->bbGetOutputOut()->Register();
    this->bbSetOutputOut( f->bbGetOutputOut() );

    bbtkDebugDecTab("Core",9);
printf("EED BinaryThresholdImageFilterGeneric::Process End\n");
  }

  //===================================================

	


	

	
	
}
// EO namespace bbtk

#endif 
