/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkExtractImageFilter.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.7 $
=========================================================================*/

/* ---------------------------------------------------------------------

* Copyright (c) CREATIS-LRMN (Centre de Recherche en Imagerie Medicale)
* Authors : Eduardo Davila, Laurent Guigues, Jean-Pierre Roux
*
*  This software is governed by the CeCILL-B license under French law and 
*  abiding by the rules of distribution of free software. You can  use, 
*  modify and/ or redistribute the software under the terms of the CeCILL-B 
*  license as circulated by CEA, CNRS and INRIA at the following URL 
*  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
*  or in the file LICENSE.txt.
*
*  As a counterpart to the access to the source code and  rights to copy,
*  modify and redistribute granted by the license, users are provided only
*  with a limited warranty  and the software's author,  the holder of the
*  economic rights,  and the successive licensors  have only  limited
*  liability. 
*
*  The fact that you are presently reading this means that you have had
*  knowledge of the CeCILL-B license and that you accept its terms.
* ------------------------------------------------------------------------ */                                                                         


#ifdef _USE_ITK_

#include "bbitkExtractImageFilter.h"
#include "bbitkPackage.h"

namespace bbitk
{
  
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(ExtractImageFilter,
					      bbtk::AtomicBlackBox);
  BBTK_BLACK_BOX_IMPLEMENTATION(ExtractImageFilterGeneric,
				     bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itk,ExtractImageFilterGeneric)
    


  //===================================================
  // Method which switches on the Process method instanciated on
  // the type of the itk Image stored in the anyImagePointer input
  void ExtractImageFilterGeneric::ProcessSwitch()
  {
     BBTK_TEMPLATE_ITK_IMAGE_SWITCH(bbGetInputIn().type(), this->Process);
  }
  //===================================================


  //-----------------------------------------------------------------	
    void ExtractImageFilterGeneric::bbUserSetDefaultValues()
  {
  }
  
  //-----------------------------------------------------------------	
  void ExtractImageFilterGeneric::bbUserInitializeProcessing()
  {
  }
  
  //-----------------------------------------------------------------	
  void ExtractImageFilterGeneric::bbUserFinalizeProcessing()
  {
  }	
  
  
} 
// EO namespace bbitk


#endif // _USE_ITK_

