/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageProperties.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.16 $
=========================================================================*/



/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_

#include "bbitkImageProperties.h"
#include "bbitkPackage.h"
#include "itkMinimumMaximumImageFilter.h"

namespace bbitk 
{
  BBTK_BLACK_BOX_IMPLEMENTATION(ImageProperties,bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itk,ImageProperties);

	//-----------------------------------------------------------------	
	void ImageProperties::bbUserSetDefaultValues()
	{
	}

	//-----------------------------------------------------------------	
	void ImageProperties::bbUserInitializeProcessing()
	{
	}

	//-----------------------------------------------------------------	
	void ImageProperties::bbUserFinalizeProcessing()
	{
	}

  void ImageProperties::DoIt()
  {
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(bbGetInputIn().type(),DoIt);
  }

  /** 
      Template Processing 
  */
  template<class itkImageType>
  void ImageProperties::DoIt()
  {
    bbtkDebugMessageInc("Core",9,"bbitk::ImageProperties::DoIt<"
			<<bbtk::TypeName<itkImageType>()
			<<">()"<<std::endl);

    itkImageType* im = bbGetInputIn().get<itkImageType*>();
    unsigned int dim = im->GetImageDimension();

    bbSetOutputTypeName(bbtk::TypeName<typename itkImageType::PixelType>());
    bbSetOutputDimension(dim);
    const typename itkImageType::RegionType& r =im->GetLargestPossibleRegion();
    bbSetOutputLargestPossibleRegion(r);

    const typename itkImageType::IndexType& ind = r.GetIndex();
    std::vector<int> vind;
    for (unsigned int i=0;i<dim;++i) 
       vind.push_back(ind[i]);
    bbSetOutputIndex(vind);

    const typename itkImageType::SizeType& sz = r.GetSize();
    std::vector<int> vsz;
    for (unsigned int i=0;i<dim;++i) 
       vsz.push_back(sz[i]);
    
  // brute hack to avoid failure of most black boxes that expects 3D images. // JPR
   if (dim==2)
        vsz.push_back(1);
    bbSetOutputSize(vsz);
    
    const typename itkImageType::PointType& orgn = im->GetOrigin();
    std::vector<float> vog;
    for (unsigned int i=0;i<dim;++i) 
       vog.push_back(orgn[i]);
       
 // brute hack to avoid failure of most black boxes that expects 3D images. // EC
    if (dim==2)
       vog.push_back(1.0);
  
    bbSetOutputOrigin(vog);

    typename itkImageType::SpacingType sp = im->GetSpacing();
    std::vector<double> vsp;
    for (unsigned int i=0;i<dim;++i) 
       vsp.push_back(double(sp[i]));
       
 // brute hack to avoid failure of most black boxes that expects 3D images. // JPR
    if (dim==2)
       vsp.push_back(1.0);
  
    bbSetOutputSpacing(vsp);


  // Min Max Value                     // EED
	  std::vector<float> vminmax;
	  typedef itk::MinimumMaximumImageFilter< itkImageType > MinMaxFilterType;
	  typename MinMaxFilterType::Pointer minMaxCalculator = MinMaxFilterType::New();
	  minMaxCalculator->SetInput(im);
	  minMaxCalculator->Update();
	  vminmax.push_back( (float) (minMaxCalculator->GetMinimum()) );
	  vminmax.push_back( (float) (minMaxCalculator->GetMaximum()) );	  
	  bbSetOutputMinMax(vminmax);
	  
    bbtkDebugDecTab("Core",9);
  }
}
// eo namespace bbtk

#endif
