/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageReader.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.9 $
=========================================================================*/



/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_

#include "bbitkImageReader.h"
#include "bbitkPackage.h"
#include "itkImageFileReader.h"

namespace bbitk 
{
  BBTK_BLACK_BOX_IMPLEMENTATION(ImageReader,bbtk::AtomicBlackBox);
  
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itk,ImageReader);

	//-----------------------------------------------------------------	
	void ImageReader::bbUserSetDefaultValues()
	{
	}
	
	//-----------------------------------------------------------------	
	void ImageReader::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ImageReader::bbUserFinalizeProcessing()
	{
	}	
	
  void ImageReader::Read()
  {
    std::string filename = bbGetInputIn();

    itk::ImageIOBase::Pointer genericReader = 
      itk::ImageIOFactory::CreateImageIO(filename.c_str(), 
					 itk::ImageIOFactory::ReadMode);
    if (!genericReader)
      {
	bbtkError("File format unknown (while reading [" << filename << "])");
      }
    genericReader->SetFileName(filename.c_str());
    genericReader->ReadImageInformation();  
    
    bbtk::TypeInfo typ = GetITKImagePtrTypeInfoFromPixelTypeInfoAndDimension(genericReader->GetComponentTypeInfo(), genericReader->GetNumberOfDimensions());

    BBTK_TEMPLATE_ITK_IMAGE_SWITCH( typ, Read);
  }


  /** 
      Template Processing 
  */
  template<class itkImageType>
  void ImageReader::Read()
  {
    bbtkDebugMessageInc("Core",9,"itkImageReader<"<<
			bbtk::TypeName<itkImageType>()
			<<">::Read()"<<std::endl);

    typedef itk::ImageFileReader< itkImageType > itkReaderType;

    typename itkReaderType::Pointer reader = itkReaderType::New();
    std::string filename = bbGetInputIn();
    reader->SetFileName(filename.c_str());
    try { reader->Update(); }
    catch( std::exception& e ) 
      {
	bbtkError("could not read image \""<< filename << "\" : "<<e.what());
      }

    reader->GetOutput()->Register();
    bbSetOutputOut( reader->GetOutput() );

    bbtkDebugDecTab("Core",9);
  }

}
// eo namespace bbtk

#endif
