/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageRegion.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.7 $
=========================================================================*/




#ifdef _USE_ITK_

#include "bbitkImageRegion.h"
#include "bbitkPackage.h"

namespace bbitk
{

  BBTK_BLACK_BOX_IMPLEMENTATION(ImageRegionCreator,
				bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itk,ImageRegionCreator);

  
  void ImageRegionCreator::bbUserSetDefaultValues()		
  {	}
  void ImageRegionCreator::bbUserInitializeProcessing()	
  {	}
  void ImageRegionCreator::bbUserFinalizeProcessing()		
  {	}
	
  
  void ImageRegionCreator::DoIt()
  {
    const std::vector<long>& index = bbGetInputIndex();
    const std::vector<long>& size = bbGetInputSize();
    //   	   std::cout<< "isize="<<index.size()<<std::endl;
    // 	   std::cout<< "ssize="<<size.size()<<std::endl;
    unsigned long maxs = index.size() > size.size() ? index.size() : size.size();
    switch (maxs) 
      {
      case 2 : DoItForDimension<2>(); break;
      case 3 : DoItForDimension<3>(); break;
      case 4 : DoItForDimension<4>(); break;
      default : bbtkError("ImageRegionCreator : cannot build a region of dimension "<<maxs);
      }
     

  }

  template <unsigned int Dimension>
  void ImageRegionCreator::DoItForDimension()
  {
    std::vector<long> index = bbGetInputIndex();
    std::vector<long> size = bbGetInputSize();
    //    	   std::cout<< "isize="<<index.size()<<std::endl;
    //    	   std::cout<< "ssize="<<size.size()<<std::endl;
 
    int ds = index.size() - size.size();
    if (ds<0) 
      {
	for (int i=0;i<-ds;++i) 
 index.push_back(0);
      }
    else 
      {
	for (int i=0;i<ds;++i) size.push_back(0);
      }

    typename itk::ImageRegion<Dimension>::IndexType I;
    typename itk::ImageRegion<Dimension>::SizeType S;

    std::vector<long>::const_iterator ii,si;
    int d(0);
    for (ii=index.begin(), si=size.begin(); 
	 ii!=index.end(); ++ii, ++si, ++d)
      {
	I[d] = *ii;
	S[d] = *si;
	//  std::cout << "o="<<*ii<<" d="<<*si<<std::endl;
      }


    bbSetOutputOut ( itk::ImageRegion<Dimension>(I,S) );
  }

}
// eo namespace

#endif
