/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageSeriesReader.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.12 $
=========================================================================*/



/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_

#include "bbitkImageSeriesReader.h"
#include "bbitkPackage.h"
#include "itkImageSeriesReader.h"

namespace bbitk 
{
  BBTK_BLACK_BOX_IMPLEMENTATION(ImageSeriesReader,bbtk::AtomicBlackBox);
  
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itk,ImageSeriesReader);

    
	//-----------------------------------------------------------------	
	void ImageSeriesReader::bbUserSetDefaultValues()
	{
		bbSetInputXSpacing(-1.0);
		bbSetInputYSpacing(-1.0);
		bbSetInputZSpacing(-1.0);		
	}
	
	//-----------------------------------------------------------------	
	void ImageSeriesReader::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ImageSeriesReader::bbUserFinalizeProcessing()
	{
	}	
	
	
	
  void ImageSeriesReader::Read()
  {
std::cout << "--------------------------------------------------- ImageSeriesReader::Read( NO template)" << std::endl;
    const std::vector<std::string>& filenames = bbGetInputFileNames();
    if (!filenames.size()) 
      {
	typedef	Image_uint8_t_2_ptr itype;
	Image_uint8_t_2::Pointer p = Image_uint8_t_2::New();
	Image_uint8_t_2::IndexType i;
	i.Fill(0);
	Image_uint8_t_2::SizeType s;
	s.Fill(1);
	Image_uint8_t_2::RegionType r(i,s);
	p->SetRegions(r);
	p->Allocate();
	p->Register();
	bbSetOutputOut(p.GetPointer());
std::cout << "--------------------------------------------------- ImageSeriesReader::Read( NO image found)" << std::endl;
	return;
  	//bbtkError("Void vector passed to "<<bbGetFullName());
      }

    std::string filename = filenames[0];
    std::cout << "--------------------------------------------------- size " << filenames.size() << std::endl;
std::cout << "--------------------------------------------------- filenames[0] : " << filenames[0]<< std::endl; 
std::cout << "--------------------------------------------------- filename.c_str : " << filename.c_str()<< std::endl; 
   
    itk::ImageIOBase::Pointer genericReader = 
      itk::ImageIOFactory::CreateImageIO(filename.c_str(), 
					 itk::ImageIOFactory::ReadMode);
    					 
    if (!genericReader)
      {
	bbtkError(bbGetFullName()<<" : File format unknown (while reading [" << filename << "])");
      }
    genericReader->SetFileName(filename.c_str());
    genericReader->ReadImageInformation();
    
    // a stack of 2D images will result as a 3D image // JPRx
    int plusUn;
    if (filenames.size()>1)
       plusUn = 1;
    else
       plusUn = 0;
    
    bbtk::TypeInfo typ = GetITKImagePtrTypeInfoFromPixelTypeInfoAndDimension(genericReader->GetComponentTypeInfo(), genericReader->GetNumberOfDimensions() + plusUn);
      
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(typ,Read);
    
  }

  /** 
      Template Processing 
  */
  template<class T>
  void ImageSeriesReader::Read()
  {
std::cout << "--------------------------------------------------- ImageSeriesReader::Read()" << std::endl;
    bbtkDebugMessageInc("Core",9,"bbitk::ImageSeriesReader<"
			<<bbtk::TypeName<T>()
			<<">::Read()"<<std::endl);

    typedef T itkImageType;
    typedef itk::ImageSeriesReader< itkImageType > itkReaderType;

    typename itkReaderType::Pointer reader = itkReaderType::New();
    const std::vector<std::string>& filenames = bbGetInputFileNames();
    
std::cout << "--------------------------------------------------- size " << filenames.size() << std::endl;
	for (int i = 0; i< (int)(filenames.size()); i++)
	std::cout << "-- [" <<filenames[i] << "]" << std::endl;
	
    reader->SetFileNames(filenames);    

    try { reader->Update(); }
    catch( std::exception& e ) 
      {
	bbtkError("could not read image series : "<<e.what());
      }

    // JPRx     
    typename itkImageType::SpacingType spacingJPRx;
        
    bool spacingToBeSet = false;
    if (bbGetInputXSpacing() > 0.)
    {
       spacingToBeSet = true;
       spacingJPRx[0]= bbGetInputXSpacing();
    }

    if (bbGetInputYSpacing() > 0.)
    {
       spacingToBeSet = true;
       spacingJPRx[1]= bbGetInputYSpacing();
    }

    if (bbGetInputZSpacing() > 0.)
    {
       spacingToBeSet = true;
       spacingJPRx[2]= bbGetInputZSpacing();
    }

    if (spacingToBeSet)
       reader->GetOutput()->SetSpacing(spacingJPRx);   
    // JPRx 

    reader->GetOutput()->Register();
    //    if (bbGetOutputOut()) 
    bbSetOutputOut ( reader->GetOutput() );

    bbtkDebugDecTab("Core",9);
  }

}
// eo namespace bbtk

#endif
