/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageSeriesReader.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.12 $
=========================================================================*/




/**
 * \file 
 * \brief class ITKImageSeriesReader : generic ITKImage reader
 */
/**
 * \class bbtk::ITKImageSeriesReader
 * \brief Generic ITKImage reader
 */
#ifdef _USE_ITK_

#ifndef __bbitkImageSeriesReader_h_INCLUDED__
#define __bbitkImageSeriesReader_h_INCLUDED__

#include "bbtkAtomicBlackBox.h"
#include "bbitkImage.h"

namespace bbitk
{

  //=================================================================
  // BlackBox declaration
  class ImageSeriesReader : public bbtk::AtomicBlackBox  
  {
    
    BBTK_BLACK_BOX_INTERFACE(ImageSeriesReader,
			     bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(FileNames,std::vector<std::string>);
    BBTK_DECLARE_INPUT(XSpacing,float);
    BBTK_DECLARE_INPUT(YSpacing,float);    
    BBTK_DECLARE_INPUT(ZSpacing,float);    
    BBTK_DECLARE_OUTPUT(Out,anyImagePointer);
    BBTK_PROCESS(Read);
    void Read();

  private:
    // Template read method 
    template<class T> void Read();
  };
  //=================================================================
  

  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageSeriesReader,bbtk::AtomicBlackBox);
  BBTK_NAME("ImageSeriesReader");
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Generic itk image series reader");
  BBTK_CATEGORY("image;read/write");
  typedef std::vector<std::string> vectorofstring;
  BBTK_INPUT(ImageSeriesReader,FileNames,
	     "vector of file names with complete paths",vectorofstring,"file names list");
  BBTK_INPUT(ImageSeriesReader,XSpacing, "if images don't contain information",float,"");	     
  BBTK_INPUT(ImageSeriesReader,YSpacing, "if images don't contain information",float,"" );	     
  BBTK_INPUT(ImageSeriesReader,ZSpacing, "if images don't contain information",float,"");
  	     
  BBTK_OUTPUT(ImageSeriesReader,Out,"Output itk::image<T,D> with type T and dimension D determined by the content of the files + vector size",anyImagePointer,"");
  
  BBTK_END_DESCRIBE_BLACK_BOX(ImageSeriesReader);
  //=================================================================
  

}
//namespace bbtk
#endif

#endif
