/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkImageWriter.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:39 $
  Version:   $Revision: 1.6 $
=========================================================================*/


/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_

#include "bbitkImageWriter.h"
#include "bbitkPackage.h"
#include "itkImageFileWriter.h"

namespace bbitk 
{
  BBTK_BLACK_BOX_IMPLEMENTATION(ImageWriter,bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itk,ImageWriter);


	//-----------------------------------------------------------------	
	void ImageWriter::bbUserSetDefaultValues()
	{
	}
	
	//-----------------------------------------------------------------	
	void ImageWriter::bbUserInitializeProcessing()
	{
	}
	
	//-----------------------------------------------------------------	
	void ImageWriter::bbUserFinalizeProcessing()
	{
	}

  void ImageWriter::Write()
  {
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(bbGetInputIn().type(),Write);
  }



  /** 
      Template Processing 
  */
  template<class itkImageType>
  void ImageWriter::Write()
  {
    bbtkDebugMessageInc("Core",9,"bbitk::ImageWriter::Write<"
			<<bbtk::TypeName<itkImageType>()
			<<">()"<<std::endl);

    typedef itk::ImageFileWriter< itkImageType > itkWriterType;
    typename itkWriterType::Pointer writer = itkWriterType::New();
    writer->SetInput(bbGetInputIn().unsafe_get<const itkImageType*>());
    writer->SetFileName(bbGetInputFilename().c_str());

    try { writer->Update(); }
    catch( std::exception & e ) 
      {
	bbtkError("could not write image \""<< bbGetInputFilename() 
		  << "\" : "<<e.what());
      }

    bbtkDebugDecTab("Core",9);
  }






}
// eo namespace bbtk

#endif
