/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkvtkitkImage2vtkImageData.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:49 $
  Version:   $Revision: 1.12 $
=========================================================================*/


/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_
#ifdef _USE_VTK_

#include "bbitkvtkitkImage2vtkImageData.h"
#include "bbitkvtkPackage.h"
#include "itkImageToVTKImageFilter.h"


namespace bbitkvtk 
{
  BBTK_BLACK_BOX_IMPLEMENTATION(itkImage2vtkImageData,bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itkvtk,itkImage2vtkImageData);

  void itkImage2vtkImageData::Convert()
  {
    bbtk::TypeInfo t = bbGetInputIn().type();
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(t,Convert);
  }

   template<class T>
   void itkImage2vtkImageData::Convert()
   {
    bbtkDebugMessage("process",5,"==> ["<<bbGetFullName()<<"] : Convert<"
		     <<bbtk::TypeName<T>()
		     <<">()"<<std::endl);

    typedef T itkImageType;
    typedef itkImageType* itkImageTypePointer;
    typedef itk::ImageToVTKImageFilter< itkImageType > ItkToVtkConnection;
    typename ItkToVtkConnection::Pointer conv;

    // No converter yet : create it and set its input
    if (!mConverter) 
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : No converter yet : creating it"<<std::endl);
	conv = ItkToVtkConnection::New();
	mConverter = conv;
	conv->SetInput( this->bbGetInputIn().get< itkImageTypePointer >() );
      }
    else 
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter ok "<<std::endl);

	// Input itkImageType type changed ? 
	// Have to change the converter and set its input
	conv = dynamic_cast<ItkToVtkConnection*>
	                   ((itk::ProcessObject*)mConverter);
	if (!conv) 
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter of wrong input type : reacreating it "<<std::endl);

	    mConverter->UnRegister();
	    conv = ItkToVtkConnection::New();
	    mConverter = conv;
	    conv->SetInput( this->bbGetInputIn().get<itkImageTypePointer>() );
	  }
	// Input image type did not change but input image pointer did:
	// set new input
	else if ( this->bbGetInputIn().get<itkImageTypePointer>() 
		  != (itkImageType*)(conv->GetExporter()->GetInputs()[0].GetPointer()))
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter input changed : resetting it"<<std::endl);

	    conv->SetInput( this->bbGetInputIn().get<itkImageTypePointer>() );
	  }
	else 
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Nothing changed"<<std::endl);
	  }
      }
    try
      {
	
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Trying update"<<std::endl);	 

	conv->Update();
	bbSetOutputOut(conv->GetOutput());
      }
    catch( itk::ExceptionObject & e) 
      {
	bbtkError("itkImage2vtkImageData<"
		  <<bbtk::TypeName<T>()
		  <<">::Convert() : "<<e);
      } 
    bbtkDebugMessage("process",5,"<== ["<<bbGetFullName()<<"] : Convert<"
		     <<bbtk::TypeName<T>()
		     <<">() *DONE*"<<std::endl);
 }

  void itkImage2vtkImageData::bbUserSetDefaultValues()
  {
    bbSetOutputOut(NULL);
    mConverter = 0;
  }

  void itkImage2vtkImageData::bbUserInitializeProcessing()
  {
  }

  void itkImage2vtkImageData::bbUserFinalizeProcessing()
  {
  }


}
// eo namespace bbitkvtk

#endif
// _USE_VTK_
#endif
// _USE_ITK_
