/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbitkvtkitkImageVector2vtkImageDataVector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:49 $
  Version:   $Revision: 1.2 $
=========================================================================*/



/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_
#ifdef _USE_VTK_

#include "bbitkvtkitkImageVector2vtkImageDataVector.h"
#include "bbitkvtkPackage.h"
#include "itkImageToVTKImageFilter.h"


namespace bbitkvtk 
{
  BBTK_BLACK_BOX_IMPLEMENTATION(itkImageVector2vtkImageDataVector,bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itkvtk,itkImageVector2vtkImageDataVector);

  void itkImageVector2vtkImageDataVector::Convert()
  {
  // suppose *all* the images have the same type // JPR
    bbtk::TypeInfo t = bbGetInputIn()[0].type();
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(t,Convert);
  }

   template<class T>
   void itkImageVector2vtkImageDataVector::Convert()
   {
    bbtkDebugMessage("process",5,"==> ["<<bbGetFullName()<<"] : Convert<"
		     <<bbtk::TypeName<T>()
		     <<">()"<<std::endl);

    typedef T itkImageType;
    typedef itkImageType* itkImageTypePointer;
    typedef itk::ImageToVTKImageFilter< itkImageType > ItkToVtkConnection;
    typename ItkToVtkConnection::Pointer conv;

int vectorSize = bbGetInputIn().size();
std::cout << " itkImageVector2vtkImageDataVector vector size :" << vectorSize << std::endl;
for (int i=0; i< vectorSize ; i++)
{
    // No converter yet : create it and set its input
    if (!mConverter) 
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : No converter yet : creating it"<<std::endl);
	conv = ItkToVtkConnection::New();
	mConverter = conv;
	conv->SetInput( this->bbGetInputIn()[i].get< itkImageTypePointer >() );
      }
    else 
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter ok "<<std::endl);
	
	// Input itkImageType type changed ? 
	// Have to change the converter and set its input
	conv = dynamic_cast<ItkToVtkConnection*>
	  ((itk::ProcessObject*)mConverter);
	if (!conv) 
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter of wrong input type : reacreating it "<<std::endl);

	    mConverter->UnRegister();
	    conv = ItkToVtkConnection::New();
	    mConverter = conv;
	    conv->SetInput( this->bbGetInputIn()[i].get<itkImageTypePointer>() );
	  }
	// Input image type did not change but input image pointer did:
	// set new input
	else if ( this->bbGetInputIn()[i].get<itkImageTypePointer>() 
		  != (itkImageType*)(conv->GetExporter()->GetInputs()[0].GetPointer()))
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter input changed : resetting it"<<std::endl);

	    conv->SetInput( this->bbGetInputIn()[i].get<itkImageTypePointer>() );
	  }
	else 
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Nothing changed"<<std::endl);
	  }
      }
    try
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Trying update"<<std::endl);	 

	conv->Update();
	m_Output_Vector.push_back(conv->GetOutput());
      }
    catch( itk::ExceptionObject & e) 
      {
	bbtkError("itkImageVector2vtkImageDataVector<"
		  <<bbtk::TypeName<T>()
		  <<">::Convert() : "<<e);
      } 
    bbtkDebugMessage("process",5,"<== ["<<bbGetFullName()<<"] : Convert<"
		     <<bbtk::TypeName<T>()
		     <<">() *DONE*"<<std::endl);
		     
} // end iterate on vector size

bbSetOutputOut(m_Output_Vector);
   
}


  void itkImageVector2vtkImageDataVector::bbUserSetDefaultValues()
  {
   // bbSetOutputOut(std::vector<vtkImageData*>); // syntax? JPR
    mConverter = 0;
  }

  void itkImageVector2vtkImageDataVector::bbUserInitializeProcessing()
	{
	}
	
  void itkImageVector2vtkImageDataVector::bbUserFinalizeProcessing()	
	{
	}

	
}
// eo namespace bbitkvtk

#endif
// _USE_VTK_
#endif
// _USE_ITK_
