/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
                                                                               
  Program:   bbtk
  Module:    $RCSfile: bbitkvtkvtkImageData2itkImage.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:50:49 $
  Version:   $Revision: 1.8 $

=========================================================================*/


/**
 *  \file 
 *  \brief 
 */
#ifdef _USE_ITK_
#ifdef _USE_VTK_

#include "bbitkvtkvtkImageData2itkImage.h"
#include "bbitkvtkPackage.h"
#include "itkVTKImageToImageFilter.h"


namespace bbitkvtk 
{

  BBTK_BLACK_BOX_IMPLEMENTATION(vtkImageData2itkImage,bbtk::AtomicBlackBox);

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(itkvtk,vtkImageData2itkImage);

#define BBTK_TEMPLATE_VTK_IMAGE_DATA_SWITCH_DIM(I,DIM,M)                        \
  if (I->GetDataDimension()==DIM)                                               \
    {                                                                           \
      if (I->GetScalarType()==VTK_CHAR) M<char,DIM>();                          \
      else if (I->GetScalarType()==VTK_SIGNED_CHAR) M<signed char,DIM>();       \
      else if (I->GetScalarType()==VTK_UNSIGNED_CHAR) M<unsigned char,DIM>();   \
      else if (I->GetScalarType()==VTK_SHORT) M<short,DIM>();                   \
      else if (I->GetScalarType()==VTK_UNSIGNED_SHORT) M<unsigned short,DIM>(); \
      else if (I->GetScalarType()==VTK_INT) M<int,DIM>();                       \
      else if (I->GetScalarType()==VTK_UNSIGNED_INT) M<unsigned int,DIM>();     \
      else if (I->GetScalarType()==VTK_LONG) M<long,DIM>();                     \
      else if (I->GetScalarType()==VTK_UNSIGNED_LONG) M<unsigned long,DIM>();   \
      else if (I->GetScalarType()==VTK_FLOAT) M<float,DIM>();                   \
      else if (I->GetScalarType()==VTK_DOUBLE) M<double,DIM>();                 \
    }

#define BBTK_TEMPLATE_VTK_IMAGE_DATA_SWITCH(I,M) \
  BBTK_TEMPLATE_VTK_IMAGE_DATA_SWITCH_DIM(I,2,M) \
  BBTK_TEMPLATE_VTK_IMAGE_DATA_SWITCH_DIM(I,3,M)

  void vtkImageData2itkImage::Convert()
  {
     BBTK_TEMPLATE_VTK_IMAGE_DATA_SWITCH(bbGetInputIn(),Convert)
  }


   template<class T, unsigned int D>
   void vtkImageData2itkImage::Convert()
   {
    bbtkDebugMessage("process",5,"==> ["<<bbGetFullName()<<"] : Convert<"
			<<bbtk::TypeName<T>()<<","<<D
			<<">()"<<std::endl);


    typedef itk::Image<T,D> itkImageType;
    typedef itk::VTKImageToImageFilter< itkImageType > VtkToItkConnection;
    typename VtkToItkConnection::Pointer conv;

    // No converter yet : create it and set its input
    if (!mConverter) 
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : No converter yet : creating it"<<std::endl);
	conv = VtkToItkConnection::New();
	mConverter = conv;
	conv->SetInput( this->bbGetInputIn() );
      }
    else 
      {
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter ok "<<std::endl);
	// Input vtkImage type changed ? 
	// Have to change the converter and set its input
	conv = dynamic_cast<VtkToItkConnection*>
	                   ((itk::ProcessObject*)mConverter);
	if (!conv) 
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter of wrong input type : reacreating it "<<std::endl);

	    mConverter->UnRegister();
	    conv = VtkToItkConnection::New();
	    mConverter = conv;
	    conv->SetInput( this->bbGetInputIn() );
	  }
	// Input image type did not change but input image pointer did:
	// set new input
	else if ( this->bbGetInputIn() != conv->GetExporter()->GetInput())
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Converter input changed : resetting it"<<std::endl);

	    conv->SetInput( this->bbGetInputIn() );
	  }
	else 
	  {
	    bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Nothing changed"<<std::endl);	  
	  }
      }
    try
      {
	
	bbtkDebugMessage("process",5,"    ["<<bbGetFullName()<<"] : Trying update"<<std::endl);	 
	conv->Update();
	itkImageType* out = const_cast<itkImageType*>(conv->GetOutput());
	bbSetOutputOut(out);
      }
    catch( itk::ExceptionObject & e) 
      {
	bbtkError("vtkImageData2itkImage<"
		  <<bbtk::TypeName<T>()<<","<<D
		  <<">::Convert() : "<<e);
      } 
    bbtkDebugMessage("process",5,"<== ["<<bbGetFullName()<<"] : Convert<"
		     <<bbtk::TypeName<T>()<<","<<D
		     <<">() *DONE*"<<std::endl);
}


  void vtkImageData2itkImage::bbUserSetDefaultValues()
  {
    //    bbSetOutputOut(NULL);
    mConverter = 0;
  }

  void vtkImageData2itkImage::bbUserInitializeProcessing()
  {
  }

  void vtkImageData2itkImage::bbUserFinalizeProcessing()
  {
  }


}
// eo namespace bbtk

#endif
// _USE_VTK_
#endif
// _USE_ITK_
