/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwLayoutSplit.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.5 $
=========================================================================*/



/**
 *  \file
 *  \brief
 */


#ifdef USE_KWWIDGETS

#include "bbkwLayoutSplit.h"
#include "bbkwPackage.h"
#include "bbtkUtilities.h"

#include <vtkKWSplitFrame.h>

namespace bbkw
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(kw,LayoutSplit);
  BBTK_BLACK_BOX_IMPLEMENTATION(LayoutSplit,bbtk::KWBlackBox);

  void LayoutSplit::bbUserConstructor()
  {
    bbSetInputOrientation("VERTICAL");
    bbSetInputProportion(50);
    bbSetInputWidget1(NULL);
    bbSetInputWidget2(NULL);
  }

  void LayoutSplit::Process()
  {
  }


  void LayoutSplit::CreateWidget(vtkKWFrame* parent) 
  {
    vtkKWSplitFrame *splitframe = vtkKWSplitFrame::New();
    bbSetOutputWidget(splitframe);
    splitframe->SetParent(parent);
    splitframe->Create();
    splitframe->SetFrame1MinimumSize(5);
    splitframe->SetFrame2MinimumSize(5);
    splitframe->SetExpandableFrameToBothFrames();

 
    int width = parent->GetWidth();
    int height = parent->GetHeight();
    int orientation = 0;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"0|H|HORIZONTAL")==true)  
      { 
	orientation = 0; 
     }
    else if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"1|V|VERTICAL")==true) 	  
      {
	orientation = 1; 
      }
    else 
      {
	bbtkWarning("Unrecognized value '"<<bbGetInputOrientation()<<"' for input 'Orientation' of LayoutSplit "<<bbGetName()<<std::endl);
      }

    if (orientation==0)
      {
	splitframe->SetOrientationToHorizontal ();
	width = width / 2;
      }
    else 
      {
	splitframe->SetOrientationToVertical ();
	height = height / 2 ;	
      }  

   width = width - 5;
   height = height - 5 ;
 
   /*   
    bbGetOutputWidget()->GetApplication()->Script("place %s -x 0 -y 0 -width %d -height %d",
						  bbGetOutputWidget()->GetWidgetName(),
						  parent->GetWidth(),
						  parent->GetHeight() );
   */
   bbGetOutputWidget()->GetApplication()->Script
     ("pack %s -expand yes -fill both",
      bbGetOutputWidget()->GetWidgetName());

    splitframe->SetReliefToGroove();
    splitframe->SetBorderWidth(2);


    vtkKWWidget* w1 =  bbCreateWidgetOfInput("Widget1",splitframe->GetFrame1());
    
    vtkKWWidget* w2 = bbCreateWidgetOfInput("Widget2",splitframe->GetFrame2());
 
    splitframe->GetApplication()->Script
      ("pack %s -expand yes -fill both",
       w1->GetWidgetName()) ;
   splitframe->GetApplication()->Script
      ("pack %s -expand yes -fill both",
       w2->GetWidgetName()) ;

    /*
    splitframe->GetApplication()->Script("pack %s -expand yes -fill x -fill y", 	w2->GetWidgetName());
    */
   /*
   splitframe->GetApplication()->Script("place %s -x 0 -y 0 -width %d -height %d",
					w1->GetWidgetName(),
   					width,
					height);

  splitframe->GetApplication()->Script("place %s -x 0 -y 0 -width %d -height %d",
				       w2->GetWidgetName(),
				       width,
				       height);
  
    */

  }


  // This callback is necessary to get actual processing of the view 
  // when window is shown
  /*
  void  LayoutSplit::OnShowWidget()
  {
    if (bbGetOutputWidget()==0)
      {
	return;
	//bbtkError("LayoutSplit::OnShowWidget() : Output Widget == 0 !");
      }
    kwSplitterWindow* win = (kwSplitterWindow*)bbGetOutputWidget();
    int w,h;
    if (win==0)
      {
	return;
	//	bbtkError("LayoutSplit::OnShowWidget() : win == 0 !");
      }
    win->GetClientSize(&w,&h);
    int pos = 100;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),
				    "0|H|HORIZONTAL")==true)  
      { 
	pos = (int)(w * bbGetInputProportion() * 0.01);
      }
    else 
      {
	pos = (int)(h * bbGetInputProportion() * 0.01);
      } 
    //    std::cout << "pos = "<<pos<<std::endl;
  
    win->SetSashPosition(pos,true);
    bbUserOnShowWidget("Widget1");
    bbUserOnShowWidget("Widget2");
  }
  */



}//namespace bbkw

#endif // _USE_KWWIDGETS_

