/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwLayoutSplit.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.4 $
=========================================================================*/



/**
 */
/**
 * \file 
 * \brief Widget which splits a window into two parts 
 */
/**
 * \class bbkw::LayoutSplit
 * \brief Widget which splits a window into two parts 
 */


#ifdef USE_KWWIDGETS


#ifndef __bbKwLayoutSplit_h__
#define __bbKwLayoutSplit_h__

#include "bbtkKWBlackBox.h"

namespace bbkw
{
  
  
  
  
  class LayoutSplit : public bbtk::KWBlackBox
  {
    
    BBTK_BLACK_BOX_INTERFACE(LayoutSplit,bbtk::KWBlackBox);
    BBTK_DECLARE_INPUT(Widget1,vtkKWWidget*);
    BBTK_DECLARE_INPUT(Widget2,vtkKWWidget*);
    BBTK_DECLARE_INPUT(Orientation,std::string);
    BBTK_DECLARE_INPUT(Proportion,int);
    BBTK_PROCESS(Process);
    BBTK_CREATE_KWWIDGET(CreateWidget);
   void CreateWidget(vtkKWFrame*);

    void Process();
  protected:
    virtual void bbUserConstructor();

  };
  
 
//=================================================================
// BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(LayoutSplit,bbtk::KWBlackBox);
  BBTK_NAME("kwLayoutSplit");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Widget which splits a window in two fixed size parts (vtkKWSplitFrame)");
  // Already inserted for any KwBlackBox  BBTK_CATEGORY("widget");
  BBTK_INPUT(LayoutSplit,Widget1,"Upper or left widget",vtkKWWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget2,"Lower or right widget",vtkKWWidget*,"");
  BBTK_INPUT(LayoutSplit,Orientation,"Orientation (default H), 0=H=HORIZONTAL , 1=V=VERTICAL",std::string,"");
   BBTK_INPUT(LayoutSplit,Proportion,"Proportion (in percent) of the first children in the window",int,"");
  BBTK_END_DESCRIBE_BLACK_BOX(LayoutSplit);
  //=================================================================
}

//namespace bbtk
#endif  //__bbtkKwLayoutSplit_h__

#endif //_USE_KWWIDGETS_
