/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwOutputText.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.2 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 *
 * Long 
 * description
 *  
 */

#ifdef USE_KWWIDGETS

#include "bbkwOutputText.h"
#include "bbkwPackage.h"
#include "bbtkUtilities.h"

#include "vtkKWLabel.h"
/*
#include "vtkObjectFactory.h"
#include "vtkCommand.h"
*/
namespace bbkw
{

  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  // KwBlackBox implementation
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

   //--------------------------------------------------------------------------
  BBTK_BLACK_BOX_IMPLEMENTATION(OutputText,bbtk::KWBlackBox);
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(kw,OutputText);
  
  //--------------------------------------------------------------------------
  void OutputText::bbUserConstructor() 
  { 
    bbSetInputIn("");
    bbSetOutputWidget(0);
  }
  
 //--------------------------------------------------------------------------
  void OutputText::Process() 
  {
    vtkKWLabel* s = (vtkKWLabel*)bbGetOutputWidget();
    if (s)
      {
	s->SetText( bbGetInputIn().c_str() );
      }
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  void OutputText::CreateWidget(vtkKWFrame* parent) 
  {
    vtkKWLabel* s = vtkKWLabel::New();
    bbSetOutputWidget(s);
    //    s->AddObserver(vtkKWScale::ScaleValueChangingEvent,this);
    s->SetParent((vtkKWWidget*)parent);
    s->Create();

    s->SetText(bbGetInputIn().c_str() );
    // s->SetResolution(1.0);
    // s->SetLength(150);
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  /*  
  void OutputText::Execute(vtkObject* caller, unsigned long, void*)
  {
    //    std::cout << "$$$$$$$$$$$$ OutputText CB $$$$$$$$$$$$"<<std::endl;
    vtkKWScale* scale = (vtkKWScale*)caller;
    bbSetOutputOut( scale->GetValue() );
    bbSetInputIn( scale->GetValue() );
    // and signal that the output has changed
    bbSignalOutputModification("Out");    
  } 
  */
  //--------------------------------------------------------------------------
  


} //namespace bbkw

#endif // USE_KWWIDGETS


