/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwSlicer.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.4 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 *
 * Long 
 * description
 *  
 */

#ifdef USE_KWWIDGETS

#include "bbkwSlicer.h"
#include "bbkwPackage.h"
#include "bbtkUtilities.h"

#include "vtkKWSlicer.h"
#include "vtkImageData.h"

namespace bbkw
{
  
 
  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  // KwBlackBox implementation
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  BBTK_BLACK_BOX_IMPLEMENTATION(Slicer,bbtk::KWBlackBox);
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(kw,Slicer);
  
  //--------------------------------------------------------------------------
  void Slicer::bbUserConstructor() 
  { 
    bbSetInputIn(0);
    bbSetOutputWidget(0);
  }
  
 //--------------------------------------------------------------------------
  void Slicer::Process() 
  {
    vtkKWSlicer* s = (vtkKWSlicer*)bbGetOutputWidget();
    if (s && bbGetInputIn()) 
      {
	s->SetImage(bbGetInputIn());
      }
  }
  //--------------------------------------------------------------------------
  void Slicer::CreateWidget(vtkKWFrame* parent) 
  {
    vtkKWSlicer* s = vtkKWSlicer::New();
    bbSetOutputWidget(s);
    s->SetParent(parent);
    if (bbGetInputIn()) 
      {
	s->SetImage(bbGetInputIn());
      }

    s->Create();
    //    bbPlaceWidget();
    /*
    s->GetApplication()->Script("pack %s -side top -expand y",
				s->GetWidgetName());
    */
  
  }

} //namespace bbkw

#endif // USE_KWWIDGETS


