/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwSlider.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.4 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
*/

/**
 * \class bbkw::Slider
 * \brief 

 * \class bbkw::SliderWidget
 * \brief 
 */

#ifdef USE_KWWIDGETS

// Prevents multiple inclusions : use symbols of the form
// __FILENAME_INCLUDED__ 
// where FILENAME must be replaced by the actual file name
#ifndef __bbkwSlider_h_INCLUDED__
#define __bbkwSlider_h_INCLUDED__

// Include KWBlackBox definition
#include "bbtkKWBlackBox.h"

class vtkObject;
class vtkCommand;
#include "vtkCommand.h"

// Namespace of the package "kw" is "bbkw" 
// Namespace associated to packages should be of the form :
// bbPACKAGENAME
namespace bbkw
{
  
  //------------------------------------------------------------------------
  // The black box
  class /*BBTK_EXPORT*/ Slider : public bbtk::KWBlackBox, public vtkCommand
  {
    
    BBTK_BLACK_BOX_INTERFACE(Slider,bbtk::KWBlackBox);
    BBTK_DECLARE_INPUT(In,int);
    BBTK_DECLARE_INPUT(Min,int);
    BBTK_DECLARE_INPUT(Max,int);
    BBTK_DECLARE_INPUT(Label,bool);
    BBTK_DECLARE_INPUT(Title,std::string);
    BBTK_DECLARE_INPUT(Orientation,std::string);
    BBTK_DECLARE_INPUT(ChangeResolution,bool);
    BBTK_DECLARE_INPUT(ReactiveOnTrack,int);    
    BBTK_DECLARE_OUTPUT(Out,int);
    BBTK_PROCESS(Process);
    BBTK_CREATE_KWWIDGET(CreateWidget);
    void Process();
    void CreateWidget(vtkKWFrame*);
    virtual void Execute(vtkObject* caller, unsigned long, void*);
 
 protected:
    virtual void bbUserConstructor();
  };
  //=================================================================
 
  //=================================================================
  // the black box description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(Slider,bbtk::KWBlackBox);
  BBTK_NAME("kwSlider");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  // Already inserted for any KWBlackBox  BBTK_CATEGORY("widget");
  BBTK_DESCRIPTION("Slider widget (vtkKWScale)");
  BBTK_INPUT(Slider,In,"Initial position of the slider (default 0)",int,"");
  BBTK_INPUT(Slider,Min,"Minimum value of the slider (default 0)",int,"");
  BBTK_INPUT(Slider,Max,"Maximum value of the slider (default 500)",int,"");
  BBTK_INPUT(Slider,Label,"Show slider labels ? (default FALSE) ",bool,"");
  BBTK_INPUT(Slider,Title,"Title shown above the slider (default '') ", std::string,"");
  BBTK_INPUT(Slider,Orientation, "Orientation : (default H)  0=H=HORIZONTAL, 1=V=VERTICAL ",std::string,"");
  BBTK_INPUT(Slider,ChangeResolution, "Can the user change the resolution of the slider ? (default FALSE) ",bool,"");
  BBTK_INPUT(Slider,ReactiveOnTrack, "Slider sends info when track moves (default 0 = no)",int,"");  
  BBTK_OUTPUT(Slider,Out,"Current position of the slider",int,"");
  BBTK_END_DESCRIBE_BLACK_BOX(Slider);
  //=================================================================
  


} //namespace bbkw

#endif  //__bbtkkwSlider_h_INCLUDED__

#endif // USE_KWWIDGETS
