/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwTransferFunctionEditor.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.4 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 *
 * Long 
 * description
 *  
 */

#ifdef USE_KWWIDGETS

#include "bbkwTransferFunctionEditor.h"
#include "bbkwPackage.h"
//#include "bbtkUtilities.h"

#include "vtkKWPiecewiseFunctionEditor.h"
#include "vtkPointData.h"

//#include "vtkKWScale.h"
#include "vtkObjectFactory.h"
#include "vtkCommand.h"

namespace bbkw
{

  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  // KwBlackBox implementation
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

   //--------------------------------------------------------------------------
  BBTK_BLACK_BOX_IMPLEMENTATION(TransferFunctionEditor,bbtk::KWBlackBox);
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(kw,TransferFunctionEditor);
  
  //--------------------------------------------------------------------------
  void TransferFunctionEditor::bbUserConstructor() 
  { 
    bbSetInputIn(0);
    bbSetOutputOut(0);
    bbSetInputTitle("Transfer function");
    bbSetOutputWidget(0);
  }
  
 //--------------------------------------------------------------------------
  void TransferFunctionEditor::Process() 
  {
    //    bbSetOutputOut( bbGetInputIn() );
    vtkPiecewiseFunction* f = bbGetOutputOut();
    if (!f) 
      { 
	f = vtkPiecewiseFunction::New();
	bbSetOutputOut(f);
      }
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  void TransferFunctionEditor::CreateWidget(vtkKWFrame* parent) 
  {
    vtkPiecewiseFunction* f = bbGetOutputOut();
    if (!f) 
      { 
	f = vtkPiecewiseFunction::New();
	bbSetOutputOut(f);
      }

    vtkKWPiecewiseFunctionEditor *w = vtkKWPiecewiseFunctionEditor::New();
    bbSetOutputWidget(w);
    w->AddObserver(vtkKWPiecewiseFunctionEditor::FunctionChangedEvent,this);
    w->SetParent((vtkKWWidget*)parent);
    w->Create();

    w->SetBorderWidth(2);
    w->SetReliefToGroove();
    w->SetPadX(2);
    w->SetPadY(2);
    //    w->ExpandCanvasWidthOff();
    //    w->ExpandCanvasHeightOn();
  //    w->SetCanvasWidth(450);
    w->SetCanvasHeight( parent->GetHeight() - 100 );
    w->SetLabelText(bbGetInputTitle().c_str());
    w->SetBalloonHelpString("Edit the transfer function");
    w->LockEndPointsParameterOn();

    w->PointIndexVisibilityOff();
    w->SelectedPointIndexVisibilityOff();
    w->MidPointVisibilityOff();
    w->PointGuidelineVisibilityOff();
    w->MidPointGuidelineVisibilityOff();
    w->MidPointGuidelineValueVisibilityOff();
    w->SetMidPointGuidelineValueFormat("%-#6.0f");
    w->MidPointEntryVisibilityOff();
    w->SharpnessEntryVisibilityOff();
    w->SetLabelPositionToTop();

    if ( bbGetInputIn()!=NULL ) 
      {
	vtkKWHistogram *h = vtkKWHistogram::New();
	h->BuildHistogram( bbGetInputIn()->GetPointData()->GetScalars(), 0);
	double *range = h->GetRange();
	f->AddPoint(range[0], 0.0 );
	f->AddPoint(range[1], 1.0 );
	w->SetHistogram(h);
	h->Delete();
      }
    else 
      {
	f->AddPoint(0.0, 0.0);
	f->AddPoint(1.0, 1.0);	
      }

    w->SetPiecewiseFunction(f);

    w->ParameterTicksVisibilityOn();
    w->ComputeValueTicksFromHistogramOn();
    w->SetParameterTicksFormat( w->GetMidPointGuidelineValueFormat());

    w->Delete();
    f->Delete();
  
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
      void TransferFunctionEditor::OnChange()

      {
	std::cout << "TransferFunctionEditor::OnChange()" << std::endl;
      }
  
  void TransferFunctionEditor::Execute(vtkObject* caller, unsigned long , void*)
  {
    bbSignalOutputModification("Out");    
    //  std::cout << "$$$$$$$$$$$$ TransferFunctionEditor CB $$$$$$$$$$$$"<<std::endl;
    
    /*
    vtkKWScale* scale = (vtkKWScale*)caller;
    bbSetOutputOut( scale->GetValue() );
    bbSetInputIn( scale->GetValue() );
    // and signal that the output has changed
    bbSignalOutputModification("Out");    
    */
  } 
  //--------------------------------------------------------------------------
  


} //namespace bbkw

#endif // USE_KWWIDGETS


