/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbkwTransferFunctionEditor.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.3 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
*/

/**
 * \class bbkw::TransferFunctionEditor
 * \brief 

 * \class bbkw::TransferFunctionEditorWidget
 * \brief 
 */

#ifdef USE_KWWIDGETS
#ifdef USE_VTK

// Prevents multiple inclusions : use symbols of the form
// __FILENAME_INCLUDED__ 
// where FILENAME must be replaced by the actual file name
#ifndef __bbkwTransferFunctionEditor_h_INCLUDED__
#define __bbkwTransferFunctionEditor_h_INCLUDED__

// Include KWBlackBox definition
#include "bbtkKWBlackBox.h"
#include "bbkw_EXPORT.h"

class vtkObject;
class vtkCommand;
#include "vtkCommand.h"
#include "vtkImageData.h"
#include "vtkPiecewiseFunction.h"


// Namespace of the package "kw" is "bbkw" 
// Namespace associated to packages should be of the form :
// bbPACKAGENAME
namespace bbkw
{
  
  //------------------------------------------------------------------------
  // The black box
  class bbkw_EXPORT TransferFunctionEditor : public bbtk::KWBlackBox, 
					     public vtkCommand
  {
    
    BBTK_BLACK_BOX_INTERFACE(TransferFunctionEditor,bbtk::KWBlackBox);

    BBTK_DECLARE_INPUT(In,vtkImageData*);
    BBTK_DECLARE_OUTPUT(Out,vtkPiecewiseFunction*);

    BBTK_DECLARE_INPUT(Title,std::string);

    BBTK_PROCESS(Process);
    BBTK_CREATE_KWWIDGET(CreateWidget);

    void Process();
    void CreateWidget(vtkKWFrame*);
    virtual void Execute(vtkObject* caller, unsigned long, void*);
    void OnChange();
 protected:
    virtual void bbUserConstructor();
  };
  //=================================================================
 
  //=================================================================
  // the black box description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(TransferFunctionEditor,bbtk::KWBlackBox);
  BBTK_NAME("kwTransferFunctionEditor");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  // Already inserted for any KWBlackBox  BBTK_CATEGORY("widget");
  BBTK_DESCRIPTION("Transfer function editor (vtkKWPiecewiseFunctionEditor)");
  BBTK_INPUT(TransferFunctionEditor,In,
	     "Image from which to extract the histogram to display",
	     vtkImageData*,"");
  BBTK_INPUT(TransferFunctionEditor,Title,
	     "Title",std::string,"");
  BBTK_OUTPUT(TransferFunctionEditor,Out,"Piecewise function",
	      vtkPiecewiseFunction*,"");
  BBTK_END_DESCRIBE_BLACK_BOX(TransferFunctionEditor);
  //=================================================================
  


} //namespace bbkw

#endif  //__bbkwTransferFunctionEditor_h_INCLUDED__

#endif // USE_KWWIDGETS

#endif // USE_VTK
