/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbkwViewer3D.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.2 $
 
=========================================================================*/
/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_WXWIDGETS_


#include "bbkwViewer3D.h"
#include "bbkwPackage.h"

#include "vtkKWRenderWidget.h"

namespace bbkw
{

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(kw,kwViewer3D);
  BBTK_BLACK_BOX_IMPLEMENTATION(kwViewer3D,bbtk::KWBlackBox);

  void kwViewer3D::bbUserConstructor() 
  { 
    bbSetInputIn1(NULL);
    bbSetInputIn2(NULL);
    bbSetInputIn3(NULL);
    bbSetInputIn4(NULL);
    bbSetInputIn5(NULL);
    bbSetInputObs1(NULL);
    bbSetInputObs2(NULL);
    bbSetInputObs3(NULL);
    bbSetInputObs4(NULL);
    bbSetInputObs5(NULL);
    bbSetOutputWidget(NULL);
  }
  
  void kwViewer3D::bbUserDestructor() 
  { 
    /*
   vtkKWRenderWidget* w = (vtkKWRenderWidget*)bbGetOutputWidget();
    if (w) 
      {
	w->Delete();
      }
    */
  }

  void kwViewer3D::Process() 
  { 
    vtkKWRenderWidget* w = (vtkKWRenderWidget*)bbGetOutputWidget();
    if (w) 
      {
	if ( (bbGetInputIn1()!=NULL) &&
	     (bbGetInputStatus("In1")!=bbtk::UPTODATE))
	  {
	    w->AddViewProp(bbGetInputIn1());
	  }
	if ( (bbGetInputIn2()!=NULL) &&
	     (bbGetInputStatus("In2")!=bbtk::UPTODATE))
	  {
	    w->AddViewProp(bbGetInputIn2());
	  }
	if ( (bbGetInputIn3()!=NULL) &&
	     (bbGetInputStatus("In3")!=bbtk::UPTODATE))
	  {
	    w->AddViewProp(bbGetInputIn3());
	  }
	if ( (bbGetInputIn4()!=NULL) &&
	     (bbGetInputStatus("In4")!=bbtk::UPTODATE))
	  {
	    w->AddViewProp(bbGetInputIn4());
	  }
	if ( (bbGetInputIn5()!=NULL) &&
	     (bbGetInputStatus("In5")!=bbtk::UPTODATE))
	  {
	    w->AddViewProp(bbGetInputIn5());
	  }
	w->ResetCamera();
	w->Render();
      }
  }
  

  void kwViewer3D::CreateWidget(vtkKWFrame* parent)
  {
    vtkKWRenderWidget *w = vtkKWRenderWidget::New();
    bbSetOutputWidget(w);
    w->SetParent((vtkKWWidget*)parent);
    w->Create();
    w->SetRenderModeToInteractive();

    Process();
    w->Delete();
    /*
    vtkRenderWindowInteractor *interactor = w->GetInteractor();
    if (interactor!=NULL)
      {
	if (bbGetInputObs1()!=NULL) 
	  {
	    bbGetInputObs1()->SetInteractor(interactor);
	    bbGetInputObs1()->EnabledOn();
	  }
	if (bbGetInputObs2()!=NULL) 
	  {
	    bbGetInputObs2()->SetInteractor(interactor);
	    bbGetInputObs2()->EnabledOn();
	  }
	if (bbGetInputObs3()!=NULL) 
	  {
	    bbGetInputObs3()->SetInteractor(interactor);
	    bbGetInputObs3()->EnabledOn();
	  }
	if (bbGetInputObs4()!=NULL) 
	  {
	    bbGetInputObs4()->SetInteractor(interactor);
	    bbGetInputObs4()->EnabledOn();
	  }
	if (bbGetInputObs5()!=NULL) 
	  {
	    bbGetInputObs5()->SetInteractor(interactor);
	    bbGetInputObs5()->EnabledOn();
	  }
	bbSetOutputInteractor(  w->GetInteractor() );
      }
   

    */
    
  }




}//namespace bbkw

#endif

