/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
                                                                                
  Program:   bbtk
  Module:    $RCSfile: bbkwViewer3D.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:05 $
  Version:   $Revision: 1.2 $
                                                                                
=========================================================================*//**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef USE_KWWIDGETS
#ifdef USE_VTK


#ifndef __bbkwViewer3D_h__
#define __bbkwViewer3D_h__

#include "bbtkKWBlackBox.h"
#include "vtkProp3D.h"
#include "vtkInteractorObserver.h"

#include "bbkw_EXPORT.h"

namespace bbkw
{

  //------------------------------------------------------------------------  
  class bbkw_EXPORT kwViewer3D : public bbtk::KWBlackBox
  {    
    BBTK_BLACK_BOX_INTERFACE(kwViewer3D,bbtk::KWBlackBox);
    BBTK_DECLARE_INPUT(In1, vtkProp3D *);
    BBTK_DECLARE_INPUT(In2, vtkProp3D *);
    BBTK_DECLARE_INPUT(In3, vtkProp3D *);
    BBTK_DECLARE_INPUT(In4, vtkProp3D *);
    BBTK_DECLARE_INPUT(In5, vtkProp3D *);
    BBTK_DECLARE_INPUT(Obs1, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs2, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs3, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs4, vtkInteractorObserver *);
    BBTK_DECLARE_INPUT(Obs5, vtkInteractorObserver *);
    BBTK_PROCESS(Process);
    BBTK_CREATE_KWWIDGET(CreateWidget);
    //    BBTK_ON_SHOW_WIDGET(OnShowWidget);
  
    void Process();
    void CreateWidget(vtkKWFrame*);
    //    void OnShowWidget();

  protected:
    virtual void bbUserConstructor();
    virtual void bbUserDestructor();
  };
   
  //=================================================================
  // UserBlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(kwViewer3D,bbtk::KWBlackBox);
  BBTK_NAME("kwViewer3D");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("3D viewer widget (vtkKWRenderWidget)");
  BBTK_CATEGORY("viewer");
  BBTK_INPUT(kwViewer3D,In1,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(kwViewer3D,In2,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(kwViewer3D,In3,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(kwViewer3D,In4,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(kwViewer3D,In5,"Input actor",vtkProp3D *,"");
  BBTK_INPUT(kwViewer3D,Obs1,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(kwViewer3D,Obs2,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(kwViewer3D,Obs3,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(kwViewer3D,Obs4,"Input observer",vtkInteractorObserver *,"");
  BBTK_INPUT(kwViewer3D,Obs5,"Input observer",vtkInteractorObserver *,"");
  BBTK_END_DESCRIBE_BLACK_BOX(kwViewer3D);
  //=================================================================


}//namespace bbtk

#endif  //__bbkwViewer3D_h__

#endif //USE_KW
#endif //USE_VTK
 
