/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifdef USE_KWWIDGETS

#ifndef __vtkKWSlicer_h
#define __vtkKWSlicer_h


#include "vtkKWCompositeWidget.h"

class vtkImageData;
class vtkKWRenderWidget;
class vtkImageViewer2;
class vtkKWScale;
class vtkKWWindowLevelPresetSelector;
class vtkKWSimpleAnimationWidget;
class vtkKWMenu;
class vtkKWSplitFrame;
class vtkKWCornerAnnotationEditor;
//namespace bbkw {

class vtkKWSlicer : public vtkKWCompositeWidget
{
public:
  static vtkKWSlicer* New();
  vtkTypeRevisionMacro(vtkKWSlicer,vtkKWCompositeWidget);

  void SetImage(vtkImageData*);
  void UpdateImage();

  // Description:
  // Callbacks
  virtual void SetSliceFromScaleCallback(double value);
  virtual void SetSliceCallback(int slice);
  virtual int  GetSliceCallback();
  virtual int  GetSliceMinCallback();
  virtual int  GetSliceMaxCallback();
  virtual void SetSliceOrientationToXYCallback();
  virtual void SetSliceOrientationToXZCallback();
  virtual void SetSliceOrientationToYZCallback();
  virtual void WindowLevelPresetApplyCallback(int id);
  virtual int  WindowLevelPresetAddCallback();
  virtual void WindowLevelPresetUpdateCallback(int id);
  virtual void WindowLevelPresetHasChangedCallback(int id);

  void ProcessCallbackCommandEvents(vtkObject *caller, 
				    unsigned long event, 
				    void *calldata);
protected:
  vtkKWSlicer();
  ~vtkKWSlicer();

  // Description:
  // Create the widget.
  virtual void CreateWidget();
  vtkKWSplitFrame                     *Frame;
  vtkImageData                   *Image;
  vtkImageViewer2                *ImageViewer; 
  vtkKWScale                     *SliceScale;
  vtkKWWindowLevelPresetSelector *WindowLevelPresetSelector;
  vtkKWRenderWidget              *RenderWidget;
  vtkKWSimpleAnimationWidget     *AnimationWidget;
  vtkKWMenu                      *OrientationMenu;
  vtkKWCornerAnnotationEditor    *AnnotationEditor;

  virtual void UpdateSliceRanges();

private:
  vtkKWSlicer(const vtkKWSlicer&);   // Not implemented.
  void operator=(const vtkKWSlicer&);  // Not implemented.
};

//}
#endif
#endif
